/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import com.google.common.base.Strings;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.PendingCommand;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.SidedProvider;
import net.minecraftforge.fml.client.gui.screen.ConfirmationScreen;
import net.minecraftforge.fml.client.gui.screen.NotificationScreen;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class StartupQuery {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker SQ = MarkerManager.getMarker((String)"STARTUPQUERY");
    private InterruptedException exception;
    private static volatile StartupQuery pending;
    private final String header;
    private final String text;
    private final String action;
    @Nullable
    private AtomicBoolean result;
    private CountDownLatch signal = new CountDownLatch(1);
    private volatile boolean synchronous;

    public static QueryBuilder builder() {
        return new QueryBuilder();
    }

    public static void abort() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            server.func_71263_m(false);
        }
        throw new AbortedException();
    }

    public static boolean pendingQuery() {
        return pending != null;
    }

    public static void reset() {
        pending = null;
    }

    public static boolean check() {
        if (pending != null) {
            try {
                try {
                    ((Consumer)SidedProvider.STARTUPQUERY.get()).accept(pending);
                }
                catch (RuntimeException e) {
                    LOGGER.error(SQ, "An exception occurred during startup query handling", (Throwable)e);
                }
                pending.throwException();
            }
            catch (InterruptedException e) {
                LOGGER.warn(SQ, "query interrupted");
                StartupQuery.abort();
            }
            pending = null;
        }
        return true;
    }

    private void throwException() throws InterruptedException {
        if (this.exception != null) {
            throw this.exception;
        }
    }

    private StartupQuery(String header, String text, String action, @Nullable AtomicBoolean result) {
        this.header = header;
        this.text = text;
        this.action = action;
        this.result = result;
    }

    @Nullable
    public Boolean getResult() {
        return this.result == null ? null : Boolean.valueOf(this.result.get());
    }

    public void setResult(boolean result) {
        this.result.set(result);
    }

    public String getHeader() {
        return this.header;
    }

    public String getText() {
        return this.text;
    }

    public String getAction() {
        return this.action;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void finish() {
        this.signal.countDown();
    }

    private void execute() {
        String prop = System.getProperty("fml.queryResult");
        if (this.result != null && prop != null) {
            LOGGER.info(SQ, "Using fml.queryResult {} to answer the following query:\n{}", (Object)prop, (Object)this.text);
            if (prop.equalsIgnoreCase("confirm")) {
                this.setResult(true);
                return;
            }
            if (prop.equalsIgnoreCase("cancel")) {
                this.setResult(false);
                return;
            }
            LOGGER.warn(SQ, "Invalid value for fml.queryResult: {}, expected confirm or cancel", (Object)prop);
        }
        this.synchronous = false;
        pending = this;
        if (FMLEnvironment.dist.isDedicatedServer() || EffectiveSide.get() == LogicalSide.CLIENT) {
            this.synchronous = true;
            StartupQuery.check();
        }
        try {
            this.signal.await();
            StartupQuery.reset();
        }
        catch (InterruptedException e) {
            LOGGER.warn(SQ, "query interrupted");
            StartupQuery.abort();
        }
    }

    public static class QueryWrapperServer {
        public static Consumer<StartupQuery> dedicatedServerQuery(Supplier<DedicatedServer> serverSupplier) {
            return query -> {
                DedicatedServer server = (DedicatedServer)serverSupplier.get();
                if (query.getResult() == null) {
                    if (!query.getHeader().isEmpty()) {
                        LOGGER.warn(SQ, "\n" + query.getHeader() + "\n");
                    }
                    LOGGER.warn(SQ, "\n" + query.getText());
                    if (!query.getAction().isEmpty()) {
                        LOGGER.warn(SQ, "\n\n" + query.getAction());
                    }
                    query.finish();
                } else {
                    StringBuilder text = new StringBuilder("\n");
                    if (!query.getHeader().isEmpty()) {
                        text.append(query.getHeader()).append("\n\n");
                    }
                    text.append(query.getText()).append("\n");
                    if (!query.getAction().isEmpty()) {
                        text.append("\n").append(query.getAction());
                    }
                    text.append("\nConfirm with '/fml confirm' or cancel with '/fml cancel'.").append("\nAlternatively start the server with -Dfml.queryResult=confirm or -Dfml.queryResult=cancel to preselect the answer.");
                    LOGGER.warn(SQ, (CharSequence)text);
                    if (!query.isSynchronous()) {
                        return;
                    }
                    boolean done = false;
                    while (!done && server.func_71278_l()) {
                        if (Thread.interrupted()) {
                            ((StartupQuery)query).exception = new InterruptedException();
                            throw new RuntimeException();
                        }
                        DedicatedServer dedServer = server;
                        List list = dedServer.field_71341_l;
                        synchronized (list) {
                            Iterator it = dedServer.field_71341_l.iterator();
                            while (it.hasNext()) {
                                String cmd = ((PendingCommand)it.next()).field_73702_a.trim().toLowerCase();
                                String string = cmd = cmd.charAt(0) == '/' ? cmd.substring(1) : cmd;
                                if (cmd.equals("fml confirm")) {
                                    LOGGER.info(SQ, "confirmed");
                                    query.setResult(true);
                                    done = true;
                                    it.remove();
                                    continue;
                                }
                                if (cmd.equals("fml cancel")) {
                                    LOGGER.info(SQ, "cancelled");
                                    query.setResult(false);
                                    done = true;
                                    it.remove();
                                    continue;
                                }
                                if (!cmd.equals("stop")) continue;
                                StartupQuery.abort();
                            }
                        }
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException ie) {
                            ((StartupQuery)query).exception = ie;
                        }
                    }
                    query.finish();
                }
            };
        }
    }

    public static class QueryWrapperClient {
        public static Consumer<StartupQuery> clientQuery(Supplier<Minecraft> clientSupplier) {
            return query -> {
                Minecraft client = (Minecraft)clientSupplier.get();
                if (query.getResult() == null) {
                    client.func_147108_a((Screen)new NotificationScreen((StartupQuery)query));
                } else {
                    client.func_147108_a((Screen)new ConfirmationScreen((StartupQuery)query));
                }
                if (query.isSynchronous()) {
                    while (client.field_71462_r instanceof NotificationScreen) {
                        if (Thread.interrupted()) {
                            ((StartupQuery)query).exception = new InterruptedException();
                            throw new RuntimeException();
                        }
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException ie) {
                            ((StartupQuery)query).exception = ie;
                        }
                    }
                }
            };
        }
    }

    public static class AbortedException
    extends RuntimeException {
        private static final long serialVersionUID = -5933665223696833921L;

        private AbortedException() {
        }
    }

    public static class QueryBuilder {
        private String header = "";
        private String text = "";
        private String action = "";

        QueryBuilder() {
        }

        public QueryBuilder header(String header) {
            this.header = Strings.nullToEmpty((String)header);
            return this;
        }

        public QueryBuilder text(String text) {
            this.text = Strings.nullToEmpty((String)text);
            return this;
        }

        public QueryBuilder action(String action) {
            this.action = Strings.nullToEmpty((String)action);
            return this;
        }

        public boolean confirm() {
            return this.build(new AtomicBoolean()).getResult();
        }

        public void notification() {
            this.build(null);
        }

        private StartupQuery build(AtomicBoolean result) {
            StartupQuery query = new StartupQuery(this.header, this.text, this.action, new AtomicBoolean());
            query.execute();
            return query;
        }
    }
}

