/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids.capability.wrappers;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MilkBucketItem;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class FluidBucketWrapper
implements IFluidHandlerItem,
ICapabilityProvider {
    private final LazyOptional<IFluidHandlerItem> holder = LazyOptional.of(() -> this);
    @Nonnull
    protected ItemStack container;

    public FluidBucketWrapper(@Nonnull ItemStack container) {
        this.container = container;
    }

    @Override
    @Nonnull
    public ItemStack getContainer() {
        return this.container;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        if (fluid.getFluid() == Fluids.field_204546_a || fluid.getFluid() == Fluids.field_204547_b || fluid.getFluid().getRegistryName().equals((Object)new ResourceLocation("milk"))) {
            return true;
        }
        return fluid.getFluid().getAttributes().getBucket(fluid) != null;
    }

    @Nonnull
    public FluidStack getFluid() {
        Item item = this.container.func_77973_b();
        if (item instanceof BucketItem) {
            return new FluidStack(((BucketItem)item).getFluid(), 1000);
        }
        return FluidStack.EMPTY;
    }

    protected void setFluid(@Nonnull FluidStack fluidStack) {
        this.container = fluidStack.isEmpty() ? new ItemStack((IItemProvider)Items.field_151133_ar) : FluidUtil.getFilledBucket(fluidStack);
    }

    @Override
    public int getTanks() {
        return 1;
    }

    @Override
    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    @Override
    public int getTankCapacity(int tank) {
        return 1000;
    }

    @Override
    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return true;
    }

    @Override
    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.container.func_190916_E() != 1 || resource.getAmount() < 1000 || this.container.func_77973_b() instanceof MilkBucketItem || !this.getFluid().isEmpty() || !this.canFillFluidType(resource)) {
            return 0;
        }
        if (action.execute()) {
            this.setFluid(resource);
        }
        return 1000;
    }

    @Override
    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.container.func_190916_E() != 1 || resource.getAmount() < 1000) {
            return FluidStack.EMPTY;
        }
        FluidStack fluidStack = this.getFluid();
        if (!fluidStack.isEmpty() && fluidStack.isFluidEqual(resource)) {
            if (action.execute()) {
                this.setFluid(FluidStack.EMPTY);
            }
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }

    @Override
    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.container.func_190916_E() != 1 || maxDrain < 1000) {
            return FluidStack.EMPTY;
        }
        FluidStack fluidStack = this.getFluid();
        if (!fluidStack.isEmpty()) {
            if (action.execute()) {
                this.setFluid(FluidStack.EMPTY);
            }
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        return CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.orEmpty(capability, this.holder);
    }
}

