/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import java.util.Arrays;
import java.util.Collection;
import net.minecraft.data.TagsProvider;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;

public interface IForgeTagBuilder<T> {
    default public TagsProvider.Builder<T> getBuilder() {
        return (TagsProvider.Builder)this;
    }

    default public TagsProvider.Builder<T> addTags(ITag.INamedTag<T> ... values) {
        TagsProvider.Builder<T> builder = this.getBuilder();
        for (ITag.INamedTag<T> value : values) {
            builder.func_240531_a_(value);
        }
        return builder;
    }

    default public TagsProvider.Builder<T> replace() {
        return this.replace(true);
    }

    default public TagsProvider.Builder<T> replace(boolean value) {
        this.getBuilder().getInternalBuilder().replace(value);
        return this.getBuilder();
    }

    default public TagsProvider.Builder<T> addOptional(ResourceLocation ... locations) {
        return this.addOptional(Arrays.asList(locations));
    }

    default public TagsProvider.Builder<T> addOptional(Collection<ResourceLocation> locations) {
        return this.getBuilder().add((ITag.ITagEntry)ForgeHooks.makeOptionalTag(true, locations));
    }

    default public TagsProvider.Builder<T> addOptionalTag(ResourceLocation ... locations) {
        return this.addOptionalTag(Arrays.asList(locations));
    }

    default public TagsProvider.Builder<T> addOptionalTag(Collection<ResourceLocation> locations) {
        return this.getBuilder().add((ITag.ITagEntry)ForgeHooks.makeOptionalTag(false, locations));
    }
}

