/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.gui.overlay.DebugOverlayGui;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.FoodStats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.world.GameType;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.lwjgl.opengl.GL11;

public class ForgeIngameGui
extends IngameGui {
    private static final int WHITE = 0xFFFFFF;
    public static boolean renderVignette = true;
    public static boolean renderHelmet = true;
    public static boolean renderPortal = true;
    public static boolean renderSpectatorTooltip = true;
    public static boolean renderHotbar = true;
    public static boolean renderCrosshairs = true;
    public static boolean renderBossHealth = true;
    public static boolean renderHealth = true;
    public static boolean renderArmor = true;
    public static boolean renderFood = true;
    public static boolean renderHealthMount = true;
    public static boolean renderAir = true;
    public static boolean renderExperiance = true;
    public static boolean renderJumpBar = true;
    public static boolean renderObjective = true;
    public static int left_height = 39;
    public static int right_height = 39;
    public static double rayTraceDistance = 20.0;
    private FontRenderer fontrenderer = null;
    private RenderGameOverlayEvent eventParent;
    private GuiOverlayDebugForge debugOverlay;

    public ForgeIngameGui(Minecraft mc) {
        super(mc);
        this.debugOverlay = new GuiOverlayDebugForge(mc);
    }

    public void func_238445_a_(MatrixStack mStack, float partialTicks) {
        ScoreObjective scoreobjective1;
        int slot;
        this.field_194811_H = this.field_73839_d.func_228018_at_().func_198107_o();
        this.field_194812_I = this.field_73839_d.func_228018_at_().func_198087_p();
        this.eventParent = new RenderGameOverlayEvent(mStack, partialTicks, this.field_73839_d.func_228018_at_());
        renderHealthMount = this.field_73839_d.field_71439_g.func_184187_bx() instanceof LivingEntity;
        renderFood = this.field_73839_d.field_71439_g.func_184187_bx() == null;
        renderJumpBar = this.field_73839_d.field_71439_g.func_110317_t();
        right_height = 39;
        left_height = 39;
        if (this.pre(RenderGameOverlayEvent.ElementType.ALL, mStack)) {
            return;
        }
        this.fontrenderer = this.field_73839_d.field_71466_p;
        RenderSystem.enableBlend();
        if (renderVignette && Minecraft.func_71375_t()) {
            this.func_212303_b(this.field_73839_d.func_175606_aa());
        } else {
            RenderSystem.enableDepthTest();
            RenderSystem.defaultBlendFunc();
        }
        if (renderHelmet) {
            this.renderHelmet(partialTicks, mStack);
        }
        if (renderPortal && !this.field_73839_d.field_71439_g.func_70644_a(Effects.field_76431_k)) {
            this.func_194805_e(partialTicks);
        }
        if (this.field_73839_d.field_71442_b.func_178889_l() == GameType.SPECTATOR) {
            if (renderSpectatorTooltip) {
                this.field_175197_u.func_238528_a_(mStack, partialTicks);
            }
        } else if (!this.field_73839_d.field_71474_y.field_74319_N && renderHotbar) {
            this.func_238443_a_(partialTicks, mStack);
        }
        if (!this.field_73839_d.field_71474_y.field_74319_N) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_230926_e_(-90);
            this.field_73842_c.setSeed(this.field_73837_f * 312871);
            if (renderCrosshairs) {
                this.func_238456_d_(mStack);
            }
            if (renderBossHealth) {
                this.renderBossHealth(mStack);
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.field_73839_d.field_71442_b.func_78755_b() && this.field_73839_d.func_175606_aa() instanceof PlayerEntity) {
                if (renderHealth) {
                    this.renderHealth(this.field_194811_H, this.field_194812_I, mStack);
                }
                if (renderArmor) {
                    this.renderArmor(mStack, this.field_194811_H, this.field_194812_I);
                }
                if (renderFood) {
                    this.renderFood(this.field_194811_H, this.field_194812_I, mStack);
                }
                if (renderHealthMount) {
                    this.renderHealthMount(this.field_194811_H, this.field_194812_I, mStack);
                }
                if (renderAir) {
                    this.renderAir(this.field_194811_H, this.field_194812_I, mStack);
                }
            }
            if (renderJumpBar) {
                this.func_238446_a_(mStack, this.field_194811_H / 2 - 91);
            } else if (renderExperiance) {
                this.renderExperience(this.field_194811_H / 2 - 91, mStack);
            }
            if (this.field_73839_d.field_71474_y.field_92117_D && this.field_73839_d.field_71442_b.func_178889_l() != GameType.SPECTATOR) {
                this.func_238453_b_(mStack);
            } else if (this.field_73839_d.field_71439_g.func_175149_v()) {
                this.field_175197_u.func_238527_a_(mStack);
            }
        }
        this.renderSleepFade(this.field_194811_H, this.field_194812_I, mStack);
        this.renderHUDText(this.field_194811_H, this.field_194812_I, mStack);
        this.renderFPSGraph(mStack);
        this.func_238444_a_(mStack);
        if (!this.field_73839_d.field_71474_y.field_74319_N) {
            this.renderRecordOverlay(this.field_194811_H, this.field_194812_I, partialTicks, mStack);
            this.renderSubtitles(mStack);
            this.renderTitle(this.field_194811_H, this.field_194812_I, partialTicks, mStack);
        }
        Scoreboard scoreboard = this.field_73839_d.field_71441_e.func_96441_U();
        ScoreObjective objective = null;
        ScorePlayerTeam scoreplayerteam = scoreboard.func_96509_i(this.field_73839_d.field_71439_g.func_195047_I_());
        if (scoreplayerteam != null && (slot = scoreplayerteam.func_178775_l().func_175746_b()) >= 0) {
            objective = scoreboard.func_96539_a(3 + slot);
        }
        ScoreObjective scoreObjective = scoreobjective1 = objective != null ? objective : scoreboard.func_96539_a(1);
        if (renderObjective && scoreobjective1 != null) {
            this.func_238447_a_(mStack, scoreobjective1);
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.disableAlphaTest();
        this.renderChat(this.field_194811_H, this.field_194812_I, mStack);
        this.renderPlayerList(this.field_194811_H, this.field_194812_I, mStack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableAlphaTest();
        this.post(RenderGameOverlayEvent.ElementType.ALL, mStack);
    }

    protected void func_238456_d_(MatrixStack mStack) {
        if (this.pre(RenderGameOverlayEvent.ElementType.CROSSHAIRS, mStack)) {
            return;
        }
        this.bind(AbstractGui.field_230665_h_);
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        super.func_238456_d_(mStack);
        this.post(RenderGameOverlayEvent.ElementType.CROSSHAIRS, mStack);
    }

    protected void func_238444_a_(MatrixStack mStack) {
        if (this.pre(RenderGameOverlayEvent.ElementType.POTION_ICONS, mStack)) {
            return;
        }
        super.func_238444_a_(mStack);
        this.post(RenderGameOverlayEvent.ElementType.POTION_ICONS, mStack);
    }

    protected void renderSubtitles(MatrixStack mStack) {
        if (this.pre(RenderGameOverlayEvent.ElementType.SUBTITLES, mStack)) {
            return;
        }
        this.field_184049_t.func_195620_a(mStack);
        this.post(RenderGameOverlayEvent.ElementType.SUBTITLES, mStack);
    }

    protected void renderBossHealth(MatrixStack mStack) {
        if (this.pre(RenderGameOverlayEvent.ElementType.BOSSHEALTH, mStack)) {
            return;
        }
        this.bind(AbstractGui.field_230665_h_);
        RenderSystem.defaultBlendFunc();
        this.field_73839_d.func_213239_aq().func_76320_a("bossHealth");
        RenderSystem.enableBlend();
        this.field_184050_w.func_238484_a_(mStack);
        RenderSystem.disableBlend();
        this.field_73839_d.func_213239_aq().func_76319_b();
        this.post(RenderGameOverlayEvent.ElementType.BOSSHEALTH, mStack);
    }

    protected void func_212303_b(Entity entity) {
        MatrixStack mStack = new MatrixStack();
        if (this.pre(RenderGameOverlayEvent.ElementType.VIGNETTE, mStack)) {
            RenderSystem.enableDepthTest();
            RenderSystem.defaultBlendFunc();
            return;
        }
        super.func_212303_b(entity);
        this.post(RenderGameOverlayEvent.ElementType.VIGNETTE, mStack);
    }

    private void renderHelmet(float partialTicks, MatrixStack mStack) {
        if (this.pre(RenderGameOverlayEvent.ElementType.HELMET, mStack)) {
            return;
        }
        ItemStack itemstack = this.field_73839_d.field_71439_g.field_71071_by.func_70440_f(3);
        if (this.field_73839_d.field_71474_y.field_74320_O == 0 && !itemstack.func_190926_b()) {
            Item item = itemstack.func_77973_b();
            if (item == Blocks.field_196625_cS.func_199767_j()) {
                this.func_194808_p();
            } else {
                item.renderHelmetOverlay(itemstack, (PlayerEntity)this.field_73839_d.field_71439_g, this.field_194811_H, this.field_194812_I, partialTicks);
            }
        }
        this.post(RenderGameOverlayEvent.ElementType.HELMET, mStack);
    }

    protected void renderArmor(MatrixStack mStack, int width, int height) {
        if (this.pre(RenderGameOverlayEvent.ElementType.ARMOR, mStack)) {
            return;
        }
        this.field_73839_d.func_213239_aq().func_76320_a("armor");
        RenderSystem.enableBlend();
        int left = width / 2 - 91;
        int top = height - left_height;
        int level = this.field_73839_d.field_71439_g.func_70658_aO();
        for (int i = 1; level > 0 && i < 20; i += 2) {
            if (i < level) {
                this.func_238474_b_(mStack, left, top, 34, 9, 9, 9);
            } else if (i == level) {
                this.func_238474_b_(mStack, left, top, 25, 9, 9, 9);
            } else if (i > level) {
                this.func_238474_b_(mStack, left, top, 16, 9, 9, 9);
            }
            left += 8;
        }
        left_height += 10;
        RenderSystem.disableBlend();
        this.field_73839_d.func_213239_aq().func_76319_b();
        this.post(RenderGameOverlayEvent.ElementType.ARMOR, mStack);
    }

    protected void func_194805_e(float partialTicks) {
        MatrixStack mStack = new MatrixStack();
        if (this.pre(RenderGameOverlayEvent.ElementType.PORTAL, mStack)) {
            return;
        }
        float f1 = this.field_73839_d.field_71439_g.field_71080_cy + (this.field_73839_d.field_71439_g.field_71086_bY - this.field_73839_d.field_71439_g.field_71080_cy) * partialTicks;
        if (f1 > 0.0f) {
            super.func_194805_e(f1);
        }
        this.post(RenderGameOverlayEvent.ElementType.PORTAL, mStack);
    }

    protected void func_238443_a_(float partialTicks, MatrixStack mStack) {
        if (this.pre(RenderGameOverlayEvent.ElementType.HOTBAR, mStack)) {
            return;
        }
        if (this.field_73839_d.field_71442_b.func_178889_l() == GameType.SPECTATOR) {
            this.field_175197_u.func_238528_a_(mStack, partialTicks);
        } else {
            super.func_238443_a_(partialTicks, mStack);
        }
        this.post(RenderGameOverlayEvent.ElementType.HOTBAR, mStack);
    }

    protected void renderAir(int width, int height, MatrixStack mStack) {
        if (this.pre(RenderGameOverlayEvent.ElementType.AIR, mStack)) {
            return;
        }
        this.field_73839_d.func_213239_aq().func_76320_a("air");
        PlayerEntity player = (PlayerEntity)this.field_73839_d.func_175606_aa();
        RenderSystem.enableBlend();
        int left = width / 2 + 91;
        int top = height - right_height;
        int air = player.func_70086_ai();
        if (player.func_208600_a((ITag)FluidTags.field_206959_a) || air < 300) {
            int full = MathHelper.func_76143_f((double)((double)(air - 2) * 10.0 / 300.0));
            int partial = MathHelper.func_76143_f((double)((double)air * 10.0 / 300.0)) - full;
            for (int i = 0; i < full + partial; ++i) {
                this.func_238474_b_(mStack, left - i * 8 - 9, top, i < full ? 16 : 25, 18, 9, 9);
            }
            right_height += 10;
        }
        RenderSystem.disableBlend();
        this.field_73839_d.func_213239_aq().func_76319_b();
        this.post(RenderGameOverlayEvent.ElementType.AIR, mStack);
    }

    public void renderHealth(int width, int height, MatrixStack mStack) {
        boolean highlight;
        this.bind(field_230665_h_);
        if (this.pre(RenderGameOverlayEvent.ElementType.HEALTH, mStack)) {
            return;
        }
        this.field_73839_d.func_213239_aq().func_76320_a("health");
        RenderSystem.enableBlend();
        PlayerEntity player = (PlayerEntity)this.field_73839_d.func_175606_aa();
        int health = MathHelper.func_76123_f((float)player.func_110143_aJ());
        boolean bl = highlight = this.field_175191_F > (long)this.field_73837_f && (this.field_175191_F - (long)this.field_73837_f) / 3L % 2L == 1L;
        if (health < this.field_175194_C && player.field_70172_ad > 0) {
            this.field_175190_E = Util.func_211177_b();
            this.field_175191_F = this.field_73837_f + 20;
        } else if (health > this.field_175194_C && player.field_70172_ad > 0) {
            this.field_175190_E = Util.func_211177_b();
            this.field_175191_F = this.field_73837_f + 10;
        }
        if (Util.func_211177_b() - this.field_175190_E > 1000L) {
            this.field_175194_C = health;
            this.field_175189_D = health;
            this.field_175190_E = Util.func_211177_b();
        }
        this.field_175194_C = health;
        int healthLast = this.field_175189_D;
        ModifiableAttributeInstance attrMaxHealth = player.func_110148_a(Attributes.field_233818_a_);
        float healthMax = (float)attrMaxHealth.func_111126_e();
        float absorb = MathHelper.func_76123_f((float)player.func_110139_bj());
        int healthRows = MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f / 10.0f));
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        this.field_73842_c.setSeed(this.field_73837_f * 312871);
        int left = width / 2 - 91;
        int top = height - left_height;
        left_height += healthRows * rowHeight;
        if (rowHeight != 10) {
            left_height += 10 - rowHeight;
        }
        int regen = -1;
        if (player.func_70644_a(Effects.field_76428_l)) {
            regen = this.field_73837_f % 25;
        }
        int TOP = 9 * (this.field_73839_d.field_71441_e.func_72912_H().func_76093_s() ? 5 : 0);
        int BACKGROUND = highlight ? 25 : 16;
        int MARGIN = 16;
        if (player.func_70644_a(Effects.field_76436_u)) {
            MARGIN += 36;
        } else if (player.func_70644_a(Effects.field_82731_v)) {
            MARGIN += 72;
        }
        float absorbRemaining = absorb;
        for (int i = MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f)) - 1; i >= 0; --i) {
            int row = MathHelper.func_76123_f((float)((float)(i + 1) / 10.0f)) - 1;
            int x = left + i % 10 * 8;
            int y = top - row * rowHeight;
            if (health <= 4) {
                y += this.field_73842_c.nextInt(2);
            }
            if (i == regen) {
                y -= 2;
            }
            this.func_238474_b_(mStack, x, y, BACKGROUND, TOP, 9, 9);
            if (highlight) {
                if (i * 2 + 1 < healthLast) {
                    this.func_238474_b_(mStack, x, y, MARGIN + 54, TOP, 9, 9);
                } else if (i * 2 + 1 == healthLast) {
                    this.func_238474_b_(mStack, x, y, MARGIN + 63, TOP, 9, 9);
                }
            }
            if (absorbRemaining > 0.0f) {
                if (absorbRemaining == absorb && absorb % 2.0f == 1.0f) {
                    this.func_238474_b_(mStack, x, y, MARGIN + 153, TOP, 9, 9);
                    absorbRemaining -= 1.0f;
                    continue;
                }
                this.func_238474_b_(mStack, x, y, MARGIN + 144, TOP, 9, 9);
                absorbRemaining -= 2.0f;
                continue;
            }
            if (i * 2 + 1 < health) {
                this.func_238474_b_(mStack, x, y, MARGIN + 36, TOP, 9, 9);
                continue;
            }
            if (i * 2 + 1 != health) continue;
            this.func_238474_b_(mStack, x, y, MARGIN + 45, TOP, 9, 9);
        }
        RenderSystem.disableBlend();
        this.field_73839_d.func_213239_aq().func_76319_b();
        this.post(RenderGameOverlayEvent.ElementType.HEALTH, mStack);
    }

    public void renderFood(int width, int height, MatrixStack mStack) {
        if (this.pre(RenderGameOverlayEvent.ElementType.FOOD, mStack)) {
            return;
        }
        this.field_73839_d.func_213239_aq().func_76320_a("food");
        PlayerEntity player = (PlayerEntity)this.field_73839_d.func_175606_aa();
        RenderSystem.enableBlend();
        int left = width / 2 + 91;
        int top = height - right_height;
        right_height += 10;
        boolean unused = false;
        FoodStats stats = this.field_73839_d.field_71439_g.func_71024_bL();
        int level = stats.func_75116_a();
        for (int i = 0; i < 10; ++i) {
            int idx = i * 2 + 1;
            int x = left - i * 8 - 9;
            int y = top;
            int icon = 16;
            int background = 0;
            if (this.field_73839_d.field_71439_g.func_70644_a(Effects.field_76438_s)) {
                icon += 36;
                background = 13;
            }
            if (unused) {
                background = 1;
            }
            if (player.func_71024_bL().func_75115_e() <= 0.0f && this.field_73837_f % (level * 3 + 1) == 0) {
                y = top + (this.field_73842_c.nextInt(3) - 1);
            }
            this.func_238474_b_(mStack, x, y, 16 + background * 9, 27, 9, 9);
            if (idx < level) {
                this.func_238474_b_(mStack, x, y, icon + 36, 27, 9, 9);
                continue;
            }
            if (idx != level) continue;
            this.func_238474_b_(mStack, x, y, icon + 45, 27, 9, 9);
        }
        RenderSystem.disableBlend();
        this.field_73839_d.func_213239_aq().func_76319_b();
        this.post(RenderGameOverlayEvent.ElementType.FOOD, mStack);
    }

    protected void renderSleepFade(int width, int height, MatrixStack mStack) {
        if (this.field_73839_d.field_71439_g.func_71060_bI() > 0) {
            this.field_73839_d.func_213239_aq().func_76320_a("sleep");
            RenderSystem.disableDepthTest();
            RenderSystem.disableAlphaTest();
            int sleepTime = this.field_73839_d.field_71439_g.func_71060_bI();
            float opacity = (float)sleepTime / 100.0f;
            if (opacity > 1.0f) {
                opacity = 1.0f - (float)(sleepTime - 100) / 10.0f;
            }
            int color = (int)(220.0f * opacity) << 24 | 0x101020;
            ForgeIngameGui.func_238467_a_((MatrixStack)mStack, (int)0, (int)0, (int)width, (int)height, (int)color);
            RenderSystem.enableAlphaTest();
            RenderSystem.enableDepthTest();
            this.field_73839_d.func_213239_aq().func_76319_b();
        }
    }

    protected void renderExperience(int x, MatrixStack mStack) {
        this.bind(field_230665_h_);
        if (this.pre(RenderGameOverlayEvent.ElementType.EXPERIENCE, mStack)) {
            return;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        if (this.field_73839_d.field_71442_b.func_78763_f()) {
            super.func_238454_b_(mStack, x);
        }
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.post(RenderGameOverlayEvent.ElementType.EXPERIENCE, mStack);
    }

    public void func_238446_a_(MatrixStack mStack, int x) {
        this.bind(field_230665_h_);
        if (this.pre(RenderGameOverlayEvent.ElementType.JUMPBAR, mStack)) {
            return;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        super.func_238446_a_(mStack, x);
        RenderSystem.enableBlend();
        this.field_73839_d.func_213239_aq().func_76319_b();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.post(RenderGameOverlayEvent.ElementType.JUMPBAR, mStack);
    }

    protected void renderHUDText(int width, int height, MatrixStack mStack) {
        RenderGameOverlayEvent.Text event;
        this.field_73839_d.func_213239_aq().func_76320_a("forgeHudText");
        RenderSystem.defaultBlendFunc();
        ArrayList<String> listL = new ArrayList<String>();
        ArrayList<String> listR = new ArrayList<String>();
        if (this.field_73839_d.func_71355_q()) {
            long time = this.field_73839_d.field_71441_e.func_82737_E();
            if (time >= 120500L) {
                listR.add(I18n.func_135052_a((String)"demo.demoExpired", (Object[])new Object[0]));
            } else {
                listR.add(I18n.func_135052_a((String)"demo.remainingTime", (Object[])new Object[]{StringUtils.func_76337_a((int)((int)(120500L - time)))}));
            }
        }
        if (this.field_73839_d.field_71474_y.field_74330_P && !this.pre(RenderGameOverlayEvent.ElementType.DEBUG, mStack)) {
            this.debugOverlay.update();
            listL.addAll(this.debugOverlay.getLeft());
            listR.addAll(this.debugOverlay.getRight());
            this.post(RenderGameOverlayEvent.ElementType.DEBUG, mStack);
        }
        if (!MinecraftForge.EVENT_BUS.post((Event)(event = new RenderGameOverlayEvent.Text(mStack, this.eventParent, listL, listR)))) {
            int top = 2;
            for (String msg : listL) {
                if (msg == null) continue;
                int n = 2 + this.fontrenderer.func_78256_a(msg) + 1;
                this.fontrenderer.getClass();
                ForgeIngameGui.func_238467_a_((MatrixStack)mStack, (int)1, (int)(top - 1), (int)n, (int)(top + 9 - 1), (int)-1873784752);
                this.fontrenderer.func_238421_b_(mStack, msg, 2.0f, (float)top, 0xE0E0E0);
                this.fontrenderer.getClass();
                top += 9;
            }
            top = 2;
            for (String msg : listR) {
                if (msg == null) continue;
                int w = this.fontrenderer.func_78256_a(msg);
                int left = width - 2 - w;
                this.fontrenderer.getClass();
                ForgeIngameGui.func_238467_a_((MatrixStack)mStack, (int)(left - 1), (int)(top - 1), (int)(left + w + 1), (int)(top + 9 - 1), (int)-1873784752);
                this.fontrenderer.func_238421_b_(mStack, msg, (float)left, (float)top, 0xE0E0E0);
                this.fontrenderer.getClass();
                top += 9;
            }
        }
        this.field_73839_d.func_213239_aq().func_76319_b();
        this.post(RenderGameOverlayEvent.ElementType.TEXT, mStack);
    }

    protected void renderFPSGraph(MatrixStack mStack) {
        if (this.field_73839_d.field_71474_y.field_74330_P && this.field_73839_d.field_71474_y.field_181657_aC && !this.pre(RenderGameOverlayEvent.ElementType.FPS_GRAPH, mStack)) {
            this.debugOverlay.func_194818_a(mStack);
            this.post(RenderGameOverlayEvent.ElementType.FPS_GRAPH, mStack);
        }
    }

    protected void renderRecordOverlay(int width, int height, float partialTicks, MatrixStack mStack) {
        if (this.field_73845_h > 0) {
            this.field_73839_d.func_213239_aq().func_76320_a("overlayMessage");
            float hue = (float)this.field_73845_h - partialTicks;
            int opacity = (int)(hue * 255.0f / 20.0f);
            if (opacity > 255) {
                opacity = 255;
            }
            if (opacity > 8) {
                RenderSystem.pushMatrix();
                RenderSystem.translatef((float)(width / 2), (float)(height - 68), (float)0.0f);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                int color = this.field_73844_j ? MathHelper.func_181758_c((float)(hue / 50.0f), (float)0.7f, (float)0.6f) & 0xFFFFFF : 0xFFFFFF;
                this.func_238448_a_(mStack, this.fontrenderer, -4, this.fontrenderer.func_238414_a_((ITextProperties)this.field_73838_g), 0xFFFFFF | opacity << 24);
                this.fontrenderer.func_238422_b_(mStack, (ITextProperties)this.field_73838_g, (float)(-this.fontrenderer.func_238414_a_((ITextProperties)this.field_73838_g) / 2), -4.0f, color | opacity << 24);
                RenderSystem.disableBlend();
                RenderSystem.popMatrix();
            }
            this.field_73839_d.func_213239_aq().func_76319_b();
        }
    }

    protected void renderTitle(int width, int height, float partialTicks, MatrixStack mStack) {
        if (this.field_175195_w > 0) {
            this.field_73839_d.func_213239_aq().func_76320_a("titleAndSubtitle");
            float age = (float)this.field_175195_w - partialTicks;
            int opacity = 255;
            if (this.field_175195_w > this.field_175193_B + this.field_175192_A) {
                float f3 = (float)(this.field_175199_z + this.field_175192_A + this.field_175193_B) - age;
                opacity = (int)(f3 * 255.0f / (float)this.field_175199_z);
            }
            if (this.field_175195_w <= this.field_175193_B) {
                opacity = (int)(age * 255.0f / (float)this.field_175193_B);
            }
            if ((opacity = MathHelper.func_76125_a((int)opacity, (int)0, (int)255)) > 8) {
                RenderSystem.pushMatrix();
                RenderSystem.translatef((float)(width / 2), (float)(height / 2), (float)0.0f);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.pushMatrix();
                RenderSystem.scalef((float)4.0f, (float)4.0f, (float)4.0f);
                int l = opacity << 24 & 0xFF000000;
                this.func_175179_f().func_238407_a_(mStack, (ITextProperties)this.field_175201_x, (float)(-this.func_175179_f().func_238414_a_((ITextProperties)this.field_175201_x) / 2), -10.0f, 0xFFFFFF | l);
                RenderSystem.popMatrix();
                RenderSystem.pushMatrix();
                RenderSystem.scalef((float)2.0f, (float)2.0f, (float)2.0f);
                this.func_175179_f().func_238407_a_(mStack, (ITextProperties)this.field_175200_y, (float)(-this.func_175179_f().func_238414_a_((ITextProperties)this.field_175200_y) / 2), 5.0f, 0xFFFFFF | l);
                RenderSystem.popMatrix();
                RenderSystem.disableBlend();
                RenderSystem.popMatrix();
            }
            this.field_73839_d.func_213239_aq().func_76319_b();
        }
    }

    protected void renderChat(int width, int height, MatrixStack mStack) {
        this.field_73839_d.func_213239_aq().func_76320_a("chat");
        RenderGameOverlayEvent.Chat event = new RenderGameOverlayEvent.Chat(mStack, this.eventParent, 0, height - 48);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)event.getPosX(), (float)event.getPosY(), (float)0.0f);
        this.field_73840_e.func_238492_a_(mStack, this.field_73837_f);
        RenderSystem.popMatrix();
        this.post(RenderGameOverlayEvent.ElementType.CHAT, mStack);
        this.field_73839_d.func_213239_aq().func_76319_b();
    }

    protected void renderPlayerList(int width, int height, MatrixStack mStack) {
        ScoreObjective scoreobjective = this.field_73839_d.field_71441_e.func_96441_U().func_96539_a(0);
        ClientPlayNetHandler handler = this.field_73839_d.field_71439_g.field_71174_a;
        if (this.field_73839_d.field_71474_y.field_74321_H.func_151470_d() && (!this.field_73839_d.func_71387_A() || handler.func_175106_d().size() > 1 || scoreobjective != null)) {
            this.field_175196_v.func_175246_a(true);
            if (this.pre(RenderGameOverlayEvent.ElementType.PLAYER_LIST, mStack)) {
                return;
            }
            this.field_175196_v.func_238523_a_(mStack, width, this.field_73839_d.field_71441_e.func_96441_U(), scoreobjective);
            this.post(RenderGameOverlayEvent.ElementType.PLAYER_LIST, mStack);
        } else {
            this.field_175196_v.func_175246_a(false);
        }
    }

    protected void renderHealthMount(int width, int height, MatrixStack mStack) {
        PlayerEntity player = (PlayerEntity)this.field_73839_d.func_175606_aa();
        Entity tmp = player.func_184187_bx();
        if (!(tmp instanceof LivingEntity)) {
            return;
        }
        this.bind(field_230665_h_);
        if (this.pre(RenderGameOverlayEvent.ElementType.HEALTHMOUNT, mStack)) {
            return;
        }
        boolean unused = false;
        int left_align = width / 2 + 91;
        this.field_73839_d.func_213239_aq().func_219895_b("mountHealth");
        RenderSystem.enableBlend();
        LivingEntity mount = (LivingEntity)tmp;
        int health = (int)Math.ceil(mount.func_110143_aJ());
        float healthMax = mount.func_110138_aP();
        int hearts = (int)(healthMax + 0.5f) / 2;
        if (hearts > 30) {
            hearts = 30;
        }
        int MARGIN = 52;
        int BACKGROUND = 52 + (unused ? 1 : 0);
        int HALF = 97;
        int FULL = 88;
        int heart = 0;
        while (hearts > 0) {
            int top = height - right_height;
            int rowCount = Math.min(hearts, 10);
            hearts -= rowCount;
            for (int i = 0; i < rowCount; ++i) {
                int x = left_align - i * 8 - 9;
                this.func_238474_b_(mStack, x, top, BACKGROUND, 9, 9, 9);
                if (i * 2 + 1 + heart < health) {
                    this.func_238474_b_(mStack, x, top, 88, 9, 9, 9);
                    continue;
                }
                if (i * 2 + 1 + heart != health) continue;
                this.func_238474_b_(mStack, x, top, 97, 9, 9, 9);
            }
            right_height += 10;
            heart += 20;
        }
        RenderSystem.disableBlend();
        this.post(RenderGameOverlayEvent.ElementType.HEALTHMOUNT, mStack);
    }

    private boolean pre(RenderGameOverlayEvent.ElementType type, MatrixStack mStack) {
        return MinecraftForge.EVENT_BUS.post((Event)new RenderGameOverlayEvent.Pre(mStack, this.eventParent, type));
    }

    private void post(RenderGameOverlayEvent.ElementType type, MatrixStack mStack) {
        MinecraftForge.EVENT_BUS.post((Event)new RenderGameOverlayEvent.Post(mStack, this.eventParent, type));
    }

    private void bind(ResourceLocation res) {
        this.field_73839_d.func_110434_K().func_110577_a(res);
    }

    private class GuiOverlayDebugForge
    extends DebugOverlayGui {
        private Minecraft mc;

        private GuiOverlayDebugForge(Minecraft mc) {
            super(mc);
            this.mc = mc;
        }

        public void update() {
            Entity entity = this.mc.func_175606_aa();
            this.field_211537_g = entity.func_213324_a(rayTraceDistance, 0.0f, false);
            this.field_211538_h = entity.func_213324_a(rayTraceDistance, 0.0f, true);
        }

        protected void func_230024_c_(MatrixStack mStack) {
        }

        protected void func_230025_d_(MatrixStack mStack) {
        }

        private List<String> getLeft() {
            List ret = this.func_209011_c();
            ret.add("");
            ret.add("Debug: Pie [shift]: " + (this.mc.field_71474_y.field_74329_Q ? "visible" : "hidden") + " FPS [alt]: " + (this.mc.field_71474_y.field_181657_aC ? "visible" : "hidden"));
            ret.add("For help: press F3 + Q");
            return ret;
        }

        private List<String> getRight() {
            return this.func_175238_c();
        }
    }
}

