/*
 * Decompiled with CFR 0.152.
 */
package clayborn.universalremote.version;

import clayborn.universalremote.util.TextFormatter;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;

public class VersionTracker {
    private static final Map<String, IVersionProvider> m_providers = new ConcurrentHashMap<String, IVersionProvider>();
    private static final Map<String, VersionData> m_downloads = new ConcurrentHashMap<String, VersionData>();
    private static final Gson gson = new Gson();
    private static AtomicBoolean downloadStarted = new AtomicBoolean(false);
    private static AtomicBoolean downloadComplete = new AtomicBoolean(false);
    private static AtomicBoolean displayedInfo = new AtomicBoolean(false);

    public static synchronized void register(IVersionProvider provider) {
        m_providers.put(provider.getModId(), provider);
    }

    private static int versionCompare(String str1, String str2) {
        int i;
        String[] vals1 = str1.split("\\.");
        String[] vals2 = str2.split("\\.");
        for (i = 0; i < vals1.length && i < vals2.length && vals1[i].equals(vals2[i]); ++i) {
        }
        if (i < vals1.length && i < vals2.length) {
            int diff = Integer.valueOf(vals1[i]).compareTo(Integer.valueOf(vals2[i]));
            return Integer.signum(diff);
        }
        return Integer.signum(vals1.length - vals2.length);
    }

    private static boolean isUpdateNeeded(IVersionProvider provider, VersionData data) {
        try {
            return VersionTracker.versionCompare(provider.getVersion(), data.version) < 0;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static synchronized void downloadVersions() {
        if (downloadStarted.get()) {
            return;
        }
        downloadStarted.set(true);
        Thread async = new Thread(new Runnable(){

            @Override
            public void run() {
                for (IVersionProvider provider : m_providers.values()) {
                    try {
                        URL url = new URL(provider.getVersionCheckUrl());
                        String download = IOUtils.toString((URL)url, (Charset)Charset.forName("UTF-8"));
                        VersionData data = (VersionData)gson.fromJson(download, VersionData.class);
                        if (VersionTracker.isUpdateNeeded(provider, data)) {
                            provider.getLogger().warn(String.format("%s using out of date version '%s'. Newest version is '%s'.", provider.getUnlocalizedName(), provider.getVersion(), data.version));
                        } else {
                            provider.getLogger().info("%s is up to date.");
                        }
                        m_downloads.put(provider.getModId(), data);
                    }
                    catch (IOException e) {
                        provider.getLogger().warn(String.format("Unable to retreive online version data for %s.", provider.getUnlocalizedName()));
                    }
                }
                downloadComplete.set(true);
            }
        });
        async.run();
    }

    private static ITextComponent buildUpdateMessage(IVersionProvider provider, VersionData data) {
        ITextComponent msg = TextFormatter.addHoverText(TextFormatter.style(TextFormatting.DARK_RED, "[%s] ", provider.getLocalizedName()), TextFormatter.format("%s -> %s", provider.getVersion(), data.version));
        msg.func_150257_a(TextFormatter.translateAndStyle(TextFormatting.WHITE, "universalremote.version.update_available", data.version));
        msg.func_150257_a(TextFormatter.addURLClick(TextFormatter.addHoverText(TextFormatter.style(TextFormatting.GOLD, " [%s]", TextFormatter.translate("universalremote.version.download", new Object[0]).func_150260_c()), TextFormatter.translate("universalremote.version.click_to_download", new Object[0])), data.downloadUrl));
        return msg;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public synchronized void onTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && downloadComplete.get() && !displayedInfo.get()) {
            for (IVersionProvider provider : m_providers.values()) {
                VersionData data;
                if (!m_downloads.containsKey(provider.getModId()) || !VersionTracker.isUpdateNeeded(provider, data = m_downloads.get(provider.getModId()))) continue;
                try {
                    event.player.func_145747_a(VersionTracker.buildUpdateMessage(provider, data));
                }
                catch (NullPointerException e) {
                    return;
                }
            }
            displayedInfo.set(true);
            try {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static interface IVersionProvider {
        public String getModId();

        public String getUnlocalizedName();

        public String getLocalizedName();

        public String getVersion();

        public String getVersionCheckUrl();

        public Logger getLogger();
    }

    public static class VersionData {
        public String version;
        public String downloadUrl;
    }
}

