/*
 * Decompiled with CFR 0.152.
 */
package clayborn.universalremote.items;

import clayborn.universalremote.items.ItemBase;
import clayborn.universalremote.items.ItemNBTEnergyStorage;
import clayborn.universalremote.util.CapabilityHelper;
import clayborn.universalremote.util.TextFormatter;
import java.text.NumberFormat;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ItemEnergyBase
extends ItemBase {
    private final int m_energyCapacity;
    private final int m_energyReceiveRate;
    private final int m_energyExtractRate;

    public ItemEnergyBase(int energyCapacity, int energyReceiveRate, int energyExtractRate, String name, CreativeTabs tab) {
        super(name, tab);
        this.m_energyCapacity = energyCapacity;
        this.m_energyReceiveRate = energyReceiveRate;
        this.m_energyExtractRate = energyExtractRate;
        this.func_77625_d(1);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new EnergyCapabilityProvider(stack, this.m_energyCapacity, this.m_energyReceiveRate, this.m_energyExtractRate);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getDurabilityForDisplay(stack) > 0.0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        IEnergyStorage storage = (IEnergyStorage)CapabilityHelper.tryGetCapability(stack, CapabilityEnergy.ENERGY, null);
        if (storage != null) {
            return 1.0 - (double)storage.getEnergyStored() / (double)storage.getMaxEnergyStored();
        }
        return super.getDurabilityForDisplay(stack);
    }

    public void func_77624_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        IEnergyStorage storage = (IEnergyStorage)CapabilityHelper.tryGetCapability(stack, CapabilityEnergy.ENERGY, null);
        if (storage != null) {
            NumberFormat format = NumberFormat.getInstance();
            tooltip.add(TextFormatter.translateAndStyle(TextFormatting.DARK_GREEN, "universalremote.strings.powertooltip", format.format(storage.getEnergyStored()), format.format(storage.getMaxEnergyStored())).func_150254_d());
        }
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return MathHelper.func_181758_c((float)0.33333334f, (float)0.5f, (float)0.25f);
    }

    public boolean func_179215_a(NBTTagCompound nbt) {
        return super.func_179215_a(nbt);
    }

    public class EnergyCapabilityProvider
    implements ICapabilityProvider {
        private final ItemNBTEnergyStorage m_storage;

        public EnergyCapabilityProvider(ItemStack stack, int energyCapacity, int energyReceiveRate, int energyExtractRate) {
            this.m_storage = new ItemNBTEnergyStorage(stack, energyCapacity, energyReceiveRate, energyExtractRate);
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == CapabilityEnergy.ENERGY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == CapabilityEnergy.ENERGY) {
                return (T)this.m_storage;
            }
            return null;
        }
    }
}

