/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import net.minecraftforge.installer.DownloadUtils;
import net.minecraftforge.installer.json.Artifact;
import net.minecraftforge.installer.json.Install;
import net.minecraftforge.installer.json.Manifest;
import net.minecraftforge.installer.json.Mirror;
import net.minecraftforge.installer.json.Version;

public class Util {
    public static Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter((Type)((Object)Artifact.class), new Artifact.Adapter()).create();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Install loadInstallProfile() {
        try (InputStream stream = Util.class.getResourceAsStream("/install_profile.json");){
            Install install = GSON.fromJson(new InputStreamReader(stream), Install.class);
            return install;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Mirror[] loadMirriorList(InputStream stream) {
        return GSON.fromJson(new InputStreamReader(stream), Mirror[].class);
    }

    public static Manifest loadManifest(InputStream stream) {
        return GSON.fromJson(new InputStreamReader(stream), Manifest.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Version loadVersion(Install profile) {
        try (InputStream stream = Util.class.getResourceAsStream(profile.getJson());){
            Version version = GSON.fromJson(new InputStreamReader(stream), Version.class);
            return version;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Version getVanillaVersion(String version, File target) {
        Version version2;
        if (!target.exists()) {
            Manifest manifest = DownloadUtils.downloadManifest();
            if (manifest == null) {
                return null;
            }
            String url = manifest.getUrl(version);
            if (url == null) {
                return null;
            }
            if (!DownloadUtils.downloadFile(target, url)) {
                return null;
            }
        }
        FileInputStream stream = new FileInputStream(target);
        Throwable throwable = null;
        try {
            version2 = GSON.fromJson(new InputStreamReader(stream), Version.class);
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    Util.$closeResource(throwable, stream);
                    throw throwable3;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Util.$closeResource(throwable, stream);
        return version2;
    }
}

