/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz;

import org.tukaani.xz.FilterEncoder;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.FinishableOutputStream;
import org.tukaani.xz.LZMA2Encoder;
import org.tukaani.xz.LZMA2OutputStream;
import org.tukaani.xz.UncompressedLZMA2OutputStream;
import org.tukaani.xz.UnsupportedOptionsException;

public class LZMA2Options
extends FilterOptions {
    private static final int[] presetToDictSize;
    private static final int[] presetToDepthLimit;
    private int dictSize;
    private byte[] presetDict = null;
    private int lc;
    private int lp;
    private int pb;
    private int mode;
    private int niceLen;
    private int mf;
    private int depthLimit;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LZMA2Options() {
        try {
            this.setPreset(6);
        }
        catch (UnsupportedOptionsException unsupportedOptionsException) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            throw new RuntimeException();
        }
    }

    public void setPreset(int n) throws UnsupportedOptionsException {
        if (n < 0 || n > 9) {
            throw new UnsupportedOptionsException("Unsupported preset: " + n);
        }
        this.lc = 3;
        this.lp = 0;
        this.pb = 2;
        this.dictSize = presetToDictSize[n];
        if (n <= 3) {
            this.mode = 1;
            this.mf = 4;
            this.niceLen = n <= 1 ? 128 : 273;
            this.depthLimit = presetToDepthLimit[n];
        } else {
            this.mode = 2;
            this.mf = 20;
            this.niceLen = n == 4 ? 16 : (n == 5 ? 32 : 64);
            this.depthLimit = 0;
        }
    }

    public int getDictSize() {
        return this.dictSize;
    }

    public byte[] getPresetDict() {
        return this.presetDict;
    }

    public int getLc() {
        return this.lc;
    }

    public int getLp() {
        return this.lp;
    }

    public int getPb() {
        return this.pb;
    }

    public int getMode() {
        return this.mode;
    }

    public int getNiceLen() {
        return this.niceLen;
    }

    public int getMatchFinder() {
        return this.mf;
    }

    public int getDepthLimit() {
        return this.depthLimit;
    }

    public FinishableOutputStream getOutputStream(FinishableOutputStream finishableOutputStream) {
        if (this.mode == 0) {
            return new UncompressedLZMA2OutputStream(finishableOutputStream);
        }
        return new LZMA2OutputStream(finishableOutputStream, this);
    }

    FilterEncoder getFilterEncoder() {
        return new LZMA2Encoder(this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            throw new RuntimeException();
        }
    }

    static {
        $assertionsDisabled = !LZMA2Options.class.desiredAssertionStatus();
        presetToDictSize = new int[]{262144, 0x100000, 0x200000, 0x400000, 0x400000, 0x800000, 0x800000, 0x1000000, 0x2000000, 0x4000000};
        presetToDepthLimit = new int[]{4, 8, 24, 48};
    }
}

