#define LINES_ON      2
#define LINES_OFF     1
#define OFF_INTENSITY 0.5

texture rubyTexture;
float2 rubyTextureSize;
float2 rubyInputSize;
float2 rubyOutputSize;
sampler sourceSampler = sampler_state
{
   texture = <rubyTexture>;
   MagFilter = LINEAR;
   AddressU  = CLAMP;
   AddressV  = CLAMP;
};

float4 Ps(float2 texCoord : TEXCOORD0) : COLOR
{
   float pixelRatio = rubyOutputSize.y * (rubyTextureSize.y / rubyInputSize.y);

   return tex2D(sourceSampler, texCoord)
      * (floor(texCoord.y * pixelRatio) % (LINES_ON + LINES_OFF) < LINES_ON ? 1.0 : OFF_INTENSITY);
}


technique Scanlines
{
   pass P0
   {
      PixelShader = compile ps_2_0 Ps();
   }
}
