//CRT curvature shader
//license: GPL
//author: DOLLS

texture rubyTexture;

float2 barrelDistortion(float2 coord) {
  float2 cc = coord - 0.5;
  float dist = dot(cc, cc);
  return coord + cc * (dist + 0.2 * dist * dist) * 0.2
}


float4 main(float2 texCoord:TEXCOORD0)
{
   return tex2D(rubyTexture, barrelDistortion(texCoord));
}
