local assets ={
	Asset("ANIM", "anim/buling_rocky.zip"),
	Asset("ANIM", "anim/hat_tiexue.zip"),
	Asset("ANIM", "anim/buling_plane.zip"),
	Asset("ANIM", "anim/swap_buling_weapon.zip"),
	Asset("ANIM", "anim/buling_parachute.zip"),
	Asset("ANIM", "anim/buling_saomiaofx.zip"),
}

local function jidi(inst)
	local inst = CreateEntity()
    inst.entity:AddTransform()
	inst.entity:AddSoundEmitter()
    inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    inst:AddComponent("inspectable")
	inst:AddTag("robot")
	inst.AnimState:SetBank("buling_zaxiang")
    inst.AnimState:SetBuild("buling_zaxiang")
	inst:AddTag("buling_yingdi")
	inst.Transform:SetScale(2, 2, 2)
	inst.AnimState:PlayAnimation("jidi")
	inst:AddComponent("inventory")
	inst:AddComponent( "childspawner" )
	inst.components.childspawner:SetRegenPeriod(10)
	inst.components.childspawner:SetSpawnPeriod(10)
	inst.components.childspawner:SetMaxChildren(10)
	inst.components.childspawner:StartSpawning()
	inst.components.childspawner:StartRegen()
	inst.components.childspawner.childname = "buling_player"
	inst.components.inventory.maxslots = 25
	inst:AddComponent("health")
	inst.components.health:SetMaxHealth(2000)
	inst:AddComponent("combat")
	return inst
end
local function jiangluosan(inst)
	local inst = CreateEntity()
    inst.entity:AddTransform()
	inst.entity:AddSoundEmitter()
    inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    inst:AddComponent("inspectable")
	inst.AnimState:SetBank("buling_parachute")
    inst.AnimState:SetBuild("buling_parachute")
	--inst.Transform:SetScale(2, 2, 2)
	inst.AnimState:PlayAnimation("idle")
	inst:ListenForEvent("animover", function()
		SpawnPrefab("small_puff").Transform:SetPosition(inst:GetPosition():Get())
		SpawnPrefab("buling_player").Transform:SetPosition(inst.Transform:GetWorldPosition())
		inst:Remove()
	end)
	return inst
end
local function planefn(Sim)
		local function OnThrown(inst, owner, target)
		if target ~= owner then
			owner.SoundEmitter:PlaySound("dontstarve/wilson/boomerang_throw")
		end
		inst.AnimState:PlayAnimation("idle", true)
	end
	local function OnHit(inst, owner, target)
		if target then
			inst.bulingtarget = target
		end
		local impactfx = SpawnPrefab("explode_small")
		if impactfx then
			local follower = impactfx.entity:AddFollower()
			follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
			impactfx:FacePoint(inst.Transform:GetWorldPosition())
		end
		inst.Physics:SetMotorVel(8,0,0)
	end
	local function testforplant(inst)
		local x,y,z = inst.Transform:GetWorldPosition()
		local ent = TheSim:FindFirstEntityWithTag("player")
		if ent and ent:GetDistanceSqToInst(inst) < 1 and inst:HasTag("nofire") then
			inst:Remove()
		end
		local target = FindEntity(inst, 1, function(item) 
			return inst.bulingtarget and item == inst.bulingtarget 
		end)
		if target and not inst:HasTag("bulingcd") and target.components.combat and target.components.health and not target.components.health:IsDead() then
			inst.bulingtarget.components.combat:GetAttacked(inst,45)
			inst:AddTag("bulingcd")
			local impactfx = SpawnPrefab("explode_small")
			if impactfx then
				local follower = impactfx.entity:AddFollower()
				follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
				impactfx:FacePoint(inst.Transform:GetWorldPosition())
			end 
			inst.task = inst:DoTaskInTime(.5,function() 
				inst:RemoveTag("bulingcd")
			end)
		end
	end
	local inst = CreateEntity()
	local trans = inst .entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    RemovePhysicsColliders(inst)
    inst.Transform:SetFourFaced()
    anim:SetBank("buling_plane")
    anim:SetBuild("buling_plane")
    anim:PlayAnimation("idle")
    anim:SetRayTestOnBB(true);
    inst:AddTag("projectile")
    inst:AddTag("thrown")
	inst.Physics:SetMotorVel(8,0,0)
    inst:AddComponent("inspectable")
	inst:AddComponent("locomotor")
    inst:AddComponent("projectile")
    inst.components.projectile:SetSpeed(10)
    --inst.components.projectile:SetCanCatch(true)
    inst.components.projectile:SetOnThrownFn(OnThrown)
    inst.components.projectile:SetOnHitFn(OnHit)
    --inst.components.projectile:SetOnCaughtFn(OnCaught)
    inst.components.projectile:SetLaunchOffset(Vector3(0, 0.2, 0))
	
	inst:DoPeriodicTask(2,function() 
		inst.Physics:SetMotorVel(8,0,0)
		if inst.bulingtarget and inst.bulingtarget ~= GetPlayer() and inst.bulingtarget:IsValid() then
			local pos = inst.bulingtarget:GetPosition()
			inst:ForceFacePoint(pos.x+math.random(-8,8),pos.y,pos.z+math.random(-8,8))
		else
			inst:AddTag("nofire")
			inst.bulingtarget = GetPlayer()
		end
	end)
	inst:DoPeriodicTask(1,function() 
		inst.Physics:SetMotorVel(8,0,0)
		if inst.bulingtarget and inst.bulingtarget:IsValid()  then 
			local pos = inst.bulingtarget:GetPosition()
			inst:ForceFacePoint(pos.x,pos.y,pos.z)
		end
	end)
	inst:DoTaskInTime(5,function()
		inst:AddTag("nofire")
		inst.bulingtarget = GetPlayer()
	end)
	inst:DoPeriodicTask(0.1,function() testforplant(inst) end)
    return inst
end
local function empfn()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	MakeInventoryPhysics(inst)
	inst.persists = false
	inst.AnimState:SetBank("buling_box")
	inst.AnimState:SetBuild("buling_box")
	inst.AnimState:PlayAnimation("emp")
	local function onthrown(inst, thrower, pt, time_to_target)
		inst.Physics:SetFriction(.2)
		inst:FacePoint(pt:Get())
		local shadow = SpawnPrefab("warningshadow")
		shadow.Transform:SetPosition(pt:Get())
		shadow:shrink(time_to_target, 2, 0.5)
		inst.UpdateTask = inst:DoPeriodicTask(FRAMES, function()
		local pos = inst:GetPosition()
			if pos.y <= 0.3 then
				inst:DoTaskInTime(0.1, function()
					local pos = Vector3(inst.Transform:GetWorldPosition())
					local ents = TheSim:FindEntities(pos.x, 0, pos.z, 3, nil, {"FX", "NOCLICK", "DECOR", "INLIMBO"})
					SpawnPrefab("groundpoundring_fx").Transform:SetPosition(inst:GetPosition():Get())
					SpawnPrefab("groundpound_fx").Transform:SetPosition(inst:GetPosition():Get())
					for k,v in pairs(ents) do
						print(k,v)
						if v and v:HasTag("bp_source") and v.beeritem ~= nil then
							if v.components.container then v.components.container:DropEverything() end
							local tornado = SpawnPrefab(v.beeritem)
							tornado.Transform:SetPosition(v.Transform:GetWorldPosition())
							v:Remove()
							SpawnPrefab("lightning_rod_fx").Transform:SetPosition(v:GetPosition():Get())
							SpawnPrefab("statue_transition_2").Transform:SetPosition(v:GetPosition():Get())
							inst:Remove()
						end
						if v.components.beerpower then
							v.components.beerpower.power = 0
							SpawnPrefab("lightning_rod_fx").Transform:SetPosition(v:GetPosition():Get())
							inst:Remove()
						end
					end
				end)
			end
		end)
	end
	inst:AddComponent("throwable")
	inst.components.throwable.onthrown = onthrown
	inst.components.throwable.random_angle = 0
	inst.components.throwable.max_y = 50
	inst:DoTaskInTime(2,function()
		inst:Remove()
	end)
	return inst
end

local function saomiaofx(inst)
	local inst = CreateEntity()
    inst.entity:AddTransform()
	inst.entity:AddSoundEmitter()
    inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
	inst.AnimState:SetBank("buling_saomiao")
    inst.AnimState:SetBuild("buling_saomiaofx")
	inst.AnimState:PlayAnimation("idle")
	inst.AnimState:SetLayer(LAYER_BACKGROUND)
	inst.AnimState:SetOrientation(ANIM_ORIENTATION.OnGround)
	inst.AnimState:SetSortOrder(3)
	inst.persists = false
	inst:ListenForEvent("animover", function()
		inst:Remove()
	end)
	return inst
end
local function bulingfx(inst)
	local inst = CreateEntity()
    inst.entity:AddTransform()
	inst.entity:AddSoundEmitter()
    inst.entity:AddAnimState()
	inst.persists = false
    --MakeInventoryPhysics(inst)
	return inst
end
--[[local function buling_recipe_yanjiutai(inst)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddSoundEmitter()
    inst.entity:AddAnimState()
	inst:DoTaskInTime(0,function()GetPlayer().buling_recipe_yanjiutai = inst  end)
	local function buling_recipes()
		local buling_yanjiutai = Recipe("buling_yanjiutai_item", {Ingredient("buling_zhongziding", 8,"images/inventoryimages/buling_zhongziding.xml", "buling_zhongziding.tex"),Ingredient("buling_core", 1,"images/inventoryimages/buling_core.xml", "buling_core.tex"),Ingredient("buling_puleidi_plank", 8,"images/inventoryimages/buling_puleidi_plank.xml", "buling_puleidi_plank.tex")}, RECIPETABS.BLTAB,TECH.NONE,nil,"buling_manual_placer",2)
		buling_yanjiutai.atlas = "images/inventoryimages/buling_yanjiutai.xml"
		buling_yanjiutai.image = "buling_yanjiutai.tex"
	end
	buling_recipes()
	return inst
end
local function buling_recipe_yanjiutongxuntai(inst)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddSoundEmitter()
    inst.entity:AddAnimState()
	inst:DoTaskInTime(0,function()GetPlayer().buling_recipe_yanjiutongxuntai = inst  end)
	local function buling_recipes()
		local buling_yanjiutai = Recipe("buling_yanjiutai_item", {Ingredient("buling_zhongziding", 8,"images/inventoryimages/buling_zhongziding.xml", "buling_zhongziding.tex"),Ingredient("buling_core", 1,"images/inventoryimages/buling_core.xml", "buling_core.tex"),Ingredient("buling_puleidi_plank", 8,"images/inventoryimages/buling_puleidi_plank.xml", "buling_puleidi_plank.tex")}, RECIPETABS.BLTAB,TECH.NONE,nil,"buling_manual_placer",2)
		buling_yanjiutai.atlas = "images/inventoryimages/buling_yanjiutai.xml"
		buling_yanjiutai.image = "buling_yanjiutai.tex"
	end
	buling_recipes()
	return inst
end]]
return Prefab("buling_jidi", jidi, assets),
Prefab("buling_parachute", jiangluosan, assets),
Prefab("buling_player_emp", empfn, assets),
Prefab("buling_saomiaofx", saomiaofx, assets),
Prefab("buling_fx", bulingfx, assets),
--Prefab("buling_recipe_yanjiutai", buling_recipe_yanjiutai, assets),
Prefab( "buling_plane", planefn, assets)
