local assets ={
	Asset("ANIM", "anim/wx78_bulingbuling.zip"),
	Asset("ANIM", "anim/swap_buling_gun_black.zip"),
	Asset("ANIM", "anim/swap_buling_gun_white.zip"),
	Asset("ANIM", "anim/swap_lightsword_buling.zip"),
}
local function empfind(inst)
	local pos = Vector3(inst.Transform:GetWorldPosition())
	local ents = TheSim:FindEntities(pos.x, pos.y, pos.z, 15, nil, {"FX", "NOCLICK", "DECOR", "INLIMBO"})
	SpawnPrefab("buling_saomiaofx").Transform:SetPosition(inst:GetPosition():Get())
	for k,v in pairs(ents) do
		if v:HasTag("bp_source") or v.components.beerpower then
			inst.components.thrower:Throw(v:GetPosition())
		end
	end
end
local function moonmonster()
	local function BlowdartDropped(inst)
		inst:Remove()
	end
	
	local function EquipBlowdart(inst)
		if inst.components.inventory and not inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS) and inst.job == "gunmen" then
			local blowdart = CreateEntity()
			blowdart.entity:AddTransform()
			blowdart:AddComponent("weapon")
			blowdart:AddTag("sharp")
			blowdart.components.weapon:SetDamage(inst.components.combat.defaultdamage)
			blowdart.components.weapon:SetRange(8)
			blowdart.components.weapon:SetProjectile("blowdart_walrus")
			blowdart:AddComponent("inventoryitem")
			blowdart.persists = false
			blowdart.components.inventoryitem:SetOnDroppedFn(BlowdartDropped)
			blowdart:AddComponent("equippable")
			
			inst.components.inventory:Equip(blowdart)
		end
	end
	local function equipweapon(inst)
		if not inst.job then
			local jobs = {"engineer","gunmen","konoye"}
			inst.job = jobs[math.random(#jobs)]
		end
		if inst.job == "engineer" then
			inst.components.health:SetAbsorptionAmount(0.9)
			inst.items.SWORD = "swap_buling_lightstuff"
			inst.components.combat.defaultdamage = 50
		elseif inst.job == "gunmen" then
			inst.components.health:SetAbsorptionAmount(0.5)
			inst.items.SWORD = "swap_buling_gun_black"
			inst.components.combat.defaultdamage = 34
			inst:DoTaskInTime(1, EquipBlowdart)
		elseif inst.job == "konoye" then
			inst.items.SWORD = "swap_buling_chopper"
			inst.components.combat.defaultdamage = 68
		end
	end
	local function OnWentHome(inst)
		if inst.components.homeseeker and 
		inst.components.homeseeker.home and 
		inst.components.homeseeker.home:IsValid() then
			if inst.components.homeseeker.home.components.inventory then
				inst.components.inventory:TransferInventory(inst.components.homeseeker.home)               
			end
		end
	end
	local function retargetfn(inst)
		if not inst.components.health:IsDead() then
			return FindEntity(inst, TUNING.FROG_TARGET_DIST, function(guy) 
				if guy.components.combat and guy.components.health and not guy.components.health:IsDead() and not guy:HasTag("robot") and not guy:HasTag("wall") then
					return guy.components.health ~= nil
				end
			end)
		end
	end
	local function OnAttacked(inst, data)
		inst.components.combat:SetTarget(data.attacker)
		inst.components.combat:ShareTarget(data.attacker, 10, function(dude) return dude:HasTag("buling_player")--[[dude.prefabs == inst.prefabs]] and not dude.components.health:IsDead() end, 30)
	end
	local items ={
		AXE = "swap_axe",
		PICK = "swap_pickaxe",
		SWORD = "swap_nightmaresword",
		HAMMER = "swap_hammer",
		HACK = "swap_machete",
		SHOVEL = "swap_shovel"
	}
	local function EquipItem(inst, item,weapon)
		if item then
			inst.AnimState:OverrideSymbol("swap_object", item, item)
			inst.AnimState:Show("ARM_carry") 
			inst.AnimState:Hide("ARM_normal")
		end
		if weapon then
			inst.AnimState:OverrideSymbol("swap_object", "swap_buling_weapon", item)
		end
	end
	
    local inst = CreateEntity()
	inst.items = items
	inst.entity:AddDynamicShadow()
	inst.equipfn = EquipItem
    EquipItem(inst)
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
	local shadow = inst.entity:AddDynamicShadow()
	shadow:SetSize( 1.5, .5 )
	local sound = inst.entity:AddSoundEmitter()
	MakeCharacterPhysics(inst, 10, .5)
	inst.DynamicShadow:SetSize(3, 1)
    inst:AddComponent("inspectable")
	inst.AnimState:SetBank("wilson")
    inst.AnimState:SetBuild("wx78_bulingbuling")
	inst:AddTag("buling_player")
	inst.AnimState:PlayAnimation("idle")
	inst.Transform:SetFourFaced(inst)
	inst:AddComponent("health")
	inst.components.health:SetMaxHealth(150)
	inst.components.health:SetAbsorptionAmount(0.8)
	inst:AddComponent("locomotor")
	inst:AddComponent("eater")
    inst.components.locomotor.walkspeed = 6
	inst.force_onwenthome_message = true
	inst:AddComponent("inventory")
    inst.components.inventory.ignorescangoincontainer = true
    local brain = require "brains/buling_playerbrain"
	inst:SetBrain(brain)
	inst:AddTag("robot")
	inst:AddTag("character")
	inst:AddComponent("combat")
    inst.components.combat.defaultdamage = 50
	inst.components.combat:SetAttackPeriod(TUNING.EYETURRET_ATTACK_PERIOD)
	inst:SetStateGraph("SGbuling_player")
	inst.AnimState:Hide("ARM_carry")
    inst.AnimState:Show("ARM_normal")
	inst:ListenForEvent("attacked", OnAttacked)
	inst.components.combat:SetRetargetFunction(3, retargetfn)
	inst:AddComponent("knownlocations")
	inst:AddComponent("follower")
	inst:AddComponent("thrower")
    inst.components.thrower.throwable_prefab = "buling_player_emp"
	inst:ListenForEvent("onwenthome", OnWentHome)
	inst:DoPeriodicTask(45,function()
		if inst.job == "engineer" then 
			empfind(inst)
		end
	end)
	equipweapon(inst)
	local function onsave(inst, data)
		if inst.job then
			data.job = inst.job
		end
	end
	local function onload(inst, data)
		if data and data.job then
			inst.job = data.job
			equipweapon(inst)
		end
	end
	inst.OnSave = onsave
    inst.OnLoad = onload
	inst:RemoveTag("player")
    return inst
end
return Prefab("buling_player",moonmonster,assets)