require "stategraphs/SGbuling_glomling"
require "stategraphs/SGbuling_car"
local assets=
{
	Asset("ANIM", "anim/buling_glomling.zip"),
	Asset("ANIM", "anim/ui_buling_chest_5x5.zip"),
	Asset("ANIM", "anim/buling_car.zip"),
}
local function upcar(doer,inst)
	doer:DoTaskInTime(0.1,function()
		if not doer.components.health:IsDead() then
			doer.sg:GoToState("idle")
			--doer:SetStateGraph("SGwilsonboating")
			doer.components.driver.vehicle = inst
			doer.components.driver.driving = true
			--local follower = doer.entity:AddFollower()
			--follower:FollowSymbol(inst.GUID,"body", 0, 0, 0 )
			--ChangeToObstaclePhysics(doer)
			--doer.HUD.controls.status:Hide()
			doer.HUD.controls.crafttabs:Hide()
			doer.Transform:SetPosition(0,0,0)
			doer.entity:SetParent(inst.entity)
			doer:Hide()
			inst.locomotor = doer.components.locomotor
			inst.combat = doer.components.combat
			doer.components.locomotor = inst.components.locomotor
			doer.components.combat = inst.components.combat
			doer:DoTaskInTime(1.5,function() GetPlayer().Physics:Stop() 
			doer.Physics:SetActive(false)
			end)
		end
	end)
end
local function drop(inst,viewer)
	viewer:Show()
	local pos = Vector3(inst.Transform:GetWorldPosition())
	viewer.components.locomotor = inst.locomotor
	viewer.components.combat = inst.combat
	--viewer.entity:AddFollower():FollowSymbol(viewer.GUID,"body", 0, 0, 0)
	viewer.Transform:SetPosition(pos.x+1,0,pos.z)
	inst.work = nil
	ChangeToCharacterPhysics(viewer)
	viewer.Physics:SetMass(75)
	viewer.HUD.controls.crafttabs:Show()
	viewer.entity:SetParent(nil)
	viewer.HUD.controls.status:Show()
	viewer.components.driver.driving = false
	viewer.components.driver.vehicle = nil
	local x,y,z = GetPlayer().Transform:GetWorldPosition()
	GetPlayer().Transform:SetPosition(x,2,z)
	GetPlayer():PushEvent("buling_getoff")
	viewer.Physics:SetActive(true)
	local staff = viewer.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS)
	if staff and staff.prefab == "buling_rocky_staff" then
		staff:Remove()
	end
end
local function fn()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local sound = inst.entity:AddSoundEmitter()
	inst.entity:AddDynamicShadow()
    inst.entity:AddPhysics()
    inst.entity:AddAnimState():SetBloomEffectHandle( "shaders/anim.ksh" )
    inst.Transform:SetSixFaced(inst)
    --MakeGhostPhysics(inst, 1, .5)
	MakeAmphibiousGhostPhysics(inst, 10, .5)
    inst.DynamicShadow:SetSize( .8, .5 )
    inst.entity:AddAnimState():SetBank("buling_glomling")
    inst.entity:AddAnimState():SetBuild("buling_glomling")
    inst.entity:AddAnimState():PlayAnimation("idle_loop", true)
    inst:AddComponent("locomotor")
    inst.components.locomotor:SetSlowMultiplier( 0.6 )
    inst.components.locomotor.walkspeed = 4
    inst.components.locomotor.runspeed =  4
    inst:AddComponent("inspectable")
    inst.Transform:SetScale(3, 3, 3)
	inst:AddComponent("health")
	inst.components.health:SetMaxHealth(100)
    inst:AddComponent("knownlocations")
    inst:AddComponent("combat")
	inst:SetStateGraph("SGbuling_glomling")
	inst.bulingdrop = drop
	inst:AddTag("buling_carrier")
    ------------------    
    inst.SoundEmitter:PlaySound("dontstarve/ghost/ghost_howl_LP", "howl")
	inst:AddComponent("inspectable")
	inst:ListenForEvent("death", function() 
		inst.bulingdrop (inst,GetPlayer())
	end)
	inst:AddComponent("drivable")
	inst.components.drivable.sanitydrain = TUNING.ROWBOAT_SANITY_DRAIN
	inst.components.drivable.runspeed = 10
	inst.components.drivable.OnMounted = function(self,doer)
		upcar(doer,inst)
	end
    return inst
end
local function carfn()
	local slotpos = {}
	for y = 4, 0, -1 do
		for x = 0, 4 do
			table.insert(slotpos, Vector3(80*x-80*2, 80*y-80*2,0))
		end
	end
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local sound = inst.entity:AddSoundEmitter()
	inst.entity:AddDynamicShadow()
    inst.entity:AddPhysics()
    --inst.entity:AddAnimState():SetBloomEffectHandle( "shaders/anim.ksh" )
    inst.Transform:SetFourFaced(inst)
    MakeCharacterPhysics(inst, 1, .5)
    inst.DynamicShadow:SetSize( .8, .5 )
    inst.entity:AddAnimState():SetBank("buling_car")
    inst.entity:AddAnimState():SetBuild("buling_car")
    inst.entity:AddAnimState():PlayAnimation("idle", true)
    inst:AddComponent("locomotor")
    inst.components.locomotor:SetSlowMultiplier( 0.6 )
    inst.components.locomotor.walkspeed = 10
    inst.components.locomotor.runspeed =  10
    inst:AddComponent("inspectable")
	--inst.Transform:SetScale(3, 3, 3)
	inst:AddComponent("health")
	inst.components.health:SetMaxHealth(100)
    inst:AddComponent("knownlocations")
    inst:AddComponent("combat")
	inst:SetStateGraph("SGbuling_car")
	inst.bulingdrop = drop
	inst:AddTag("buling_carrier")
    ------------------    
    inst.SoundEmitter:PlaySound("dontstarve/ghost/ghost_howl_LP", "howl")
	inst:AddComponent("inspectable")
	inst:ListenForEvent("death", function() 
		inst.bulingdrop (inst,GetPlayer())
	end)
	inst:AddComponent("drivable")
	inst.components.drivable.sanitydrain = TUNING.ROWBOAT_SANITY_DRAIN
	inst.components.drivable.runspeed = 10
	inst.components.drivable.OnMounted = function(self,doer)
		upcar(doer,inst)
		GetPlayer():PushEvent("buling_drive_car")
	end
	inst:AddComponent("container")
	inst.components.container:SetNumSlots(#slotpos)
	inst.components.container.widgetslotpos = slotpos
    inst.components.container.widgetpos = Vector3(0,0,0)
    inst.components.container.side_align_tip = 100
	inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_buling_chest_5x5"
	inst.beeritem = "buling_car_log_item"
    return inst
end
local function gdfn()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	local sound = inst.entity:AddSoundEmitter()
	inst.entity:AddDynamicShadow()
	inst.Transform:SetFourFaced(inst)
	MakeCharacterPhysics(inst, 1, .5)
	anim:SetBank("rocky")
	inst.DynamicShadow:SetSize(3, 3 )
	anim:SetBuild("buling_rocky")
	anim:PlayAnimation("idle_loop", true)
	inst:AddComponent("lootdropper")
	inst:AddComponent("locomotor")
    inst.components.locomotor:SetSlowMultiplier( 0.6 )
    inst.components.locomotor.walkspeed = 5
    inst.components.locomotor.runspeed =  5
    inst:AddComponent("combat")
    inst.components.combat:SetAttackPeriod(3)
    inst.components.combat:SetRange(4)
    inst.components.combat:SetDefaultDamage(100)
	inst.Transform:SetScale(3, 3, 3)
	inst.components.combat:SetAreaDamage(6, 0.8)
	inst.bulingdrop = drop
	inst:AddTag("buling_carrier")
	inst:AddTag("atk")
    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(2000)
	inst:AddComponent("inventory")
    inst.components.inventory.dropondeath = false
	inst:SetStateGraph("SGbuling_rocky")
	inst:ListenForEvent("death", function() 
		inst.bulingdrop (inst,GetPlayer())
	end)
	inst:AddComponent("inspectable")
	inst:AddComponent("drivable")
	inst.components.drivable.sanitydrain = TUNING.ROWBOAT_SANITY_DRAIN
	inst.components.drivable.runspeed = 10
	inst.components.drivable.OnMounted = function(self,doer)
		upcar(doer,inst)
		GetPlayer():PushEvent("buling_drive_rocky")
		GetPlayer().components.inventory:Equip(SpawnPrefab("buling_rocky_staff"))
	end
	inst:ListenForEvent("onhitother",function() SpawnPrefab("groundpound_fx").Transform:SetPosition(inst.Transform:GetWorldPosition()) end)
	return inst
end
local function dcfn()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	local sound = inst.entity:AddSoundEmitter()
	inst.entity:AddDynamicShadow()
	inst.Transform:SetFourFaced(inst)
	MakeCharacterPhysics(inst, 1, .5)
	inst.DynamicShadow:SetSize(3, 3 )
	anim:SetBank("deerclops")
	anim:SetBuild("deerclops_build")
	inst.AnimState:OverrideSymbol("deerclops_body", "buling_deerclops", "deerclops_body")
	inst.AnimState:OverrideSymbol("beefalo_furpatch", "nil", "deerclops_body")
	inst.AnimState:OverrideSymbol("deerclops_head", "nil", "deerclops_body")
	--anim:PlayAnimation("idle_loop", true)
	inst:AddComponent("lootdropper")
	inst:AddComponent("locomotor")
    inst.components.locomotor:SetSlowMultiplier( 0.6 )
    inst.components.locomotor.walkspeed = 5
    inst.components.locomotor.runspeed =  5
    inst:AddComponent("combat")
    inst.components.combat:SetAttackPeriod(3)
    inst.components.combat:SetRange(4)
    inst.components.combat:SetDefaultDamage(100)
	inst.Transform:SetScale(1.7, 1.7, 1.7)
	inst.components.combat:SetAreaDamage(6, 0.8)
	inst.bulingdrop = drop
	inst:AddTag("buling_carrier")
    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(2000)
	inst:AddComponent("inventory")
    inst.components.inventory.dropondeath = false
	inst:SetStateGraph("SGbuling_deerclops")
	inst:ListenForEvent("death", function() 
		inst.bulingdrop (inst,GetPlayer())
	end)
	inst:AddComponent("inspectable")
	inst:AddComponent("drivable")
	inst.components.drivable.sanitydrain = TUNING.ROWBOAT_SANITY_DRAIN
	inst.components.drivable.runspeed = 10
	inst.components.drivable.OnMounted = function(self,doer)
		upcar(doer,inst)
		--GetPlayer():PushEvent("buling_drive_rocky")
		--GetPlayer().components.inventory:Equip(SpawnPrefab("buling_rocky_staff"))
	end
	return inst
end
return Prefab("buling_glomling",fn , assets),
Prefab("buling_rocky",gdfn,assets),
Prefab("buling_deerclops",dcfn,assets),
Prefab("buling_car_log",carfn , assets)