local assets = {
	--Asset( "ANIM", "anim/kiyohime_build_merlin.zip" ),
}
local function onsave(inst, data)
    if inst:HasTag("spawned_cave") then
        data.spawned_cave = true
    end
end

local function onload(inst, data)
    if data and data.spawned_cave then
        inst:AddTag("spawned_cave")
    end
end
local function getlocationoutofcenter(dist,hole,random,invert)
    local pos =  (math.random()*((dist/2) - (hole/2))) + hole/2    
    if invert or (random and math.random()<0.5) then
        pos = pos *-1
    end
    return pos
end
local function creatInterior(inst)    
    if not inst:HasTag("spawned_cave") then
        local interior_spawner = GetWorld().components.interiorspawner

        local name = "buling_cave_entrance".. interior_spawner:GetNewID()
        local height = 18
        local width = 26

        local newID = interior_spawner:GetNewID()

        local exterior_door_def = {
            my_door_id = name..newID.."_door",
            target_door_id = name..newID.."_exit",
            target_interior = newID,
        }
		local addprops = {}
        interior_spawner:AddDoor(inst, exterior_door_def)

        local    floortexture = "levels/textures/interiors/batcave_floor.tex"
        local    walltexture =  "levels/textures/interiors/batcave_wall_rock.tex"
        local    minimaptexture = "levels/textures/map_interior/mini_vamp_cave_noise.tex"
		local SHOPSOUND_EXIT = "dontstarve_DLC003/common/objects/store/door_close"
        addprops = {
                    { name = "prop_door", x_offset = -height/2, z_offset = 0, animdata = {bank ="exitrope", build ="cave_exit_rope", anim="idle_loop", background=true}, 
                        my_door_id = exterior_door_def.target_door_id, target_door_id = exterior_door_def.my_door_id, addtags={"guard_entrance"}, usesounds={SHOPSOUND_EXIT} },


                   --[[ { name = "deco_accademy_beam",          x_offset = -5,  z_offset = width/2, flip=true },
                    { name = "deco_accademy_beam",          x_offset = -5,  z_offset = -width/2 },
                    { name = "deco_accademy_cornerbeam",    x_offset = 4.7, z_offset = width/2, flip=true },
                    { name = "deco_accademy_cornerbeam",    x_offset = 4.7, z_offset = -width/2 },]]

                    { name = "firepit",          x_offset = -3,  z_offset =  -0 },                    
    
				}                         
                

        interior_spawner:CreateRoom("generic_interior", width, 10, height, name, newID, addprops, {}, walltexture, floortexture, minimaptexture, nil, "images/colour_cubes/pigshop_interior_cc.tex", true, nil, "batcave","BAT_CAVE","DIRT", nil, nil, true)        
        inst:AddTag("spawned_cave")
    end        
end
local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()

    inst.entity:AddSoundEmitter()

    MakeObstaclePhysics(inst, .5)

	anim:SetBank("cave_entrance")
	anim:SetBuild("cave_entrance")
	anim:PlayAnimation("idle_open")

    --inst:AddTag("structure")
    inst:AddTag("houndmound")
    inst:AddTag("batcave")

    -------------------

    inst:AddComponent("door")
    inst.components.door.outside = true

    inst:DoTaskInTime(0, function() 
         creatInterior(inst)
    end)

    inst.OnSave = onsave 
    inst.OnLoad = onload

    ---------------------
    inst:AddComponent("inspectable")
	MakeSnowCovered(inst)
    
	return inst
end
return Prefab( "buling_cave_entrance", fn, assets) 