
local Image = require "widgets/image"
local Widget = require "widgets/widget"
local UIAnim = require "widgets/uianim"
require("constants")

local Iai_ItemUI = Class(Widget, function(self, item)
	Widget._ctor(self, "Iai_ItemUI")
	
	self.item = item
	
	if not self.item then return end
	
	if self.item.components.container then
		if self.item.components.container.widgetbgatlas then
			self.bg = self:AddChild(Image())
			self.bg:SetTexture(self.item.components.container.widgetbgatlas, self.item.components.container.widgetbgimage)
		elseif self.item.components.container.widgetanimbank then
			self.bg = self:AddChild(UIAnim())
			self.bg:GetAnimState():SetBank(self.item.components.container.widgetanimbank)
			self.bg:GetAnimState():SetBuild(self.item.components.container.widgetanimbuild)
			self.bg:GetAnimState():PlayAnimation("open")
		else
			return
		end
		
	elseif self.item.components.inventory then
		self.bg = self:AddChild(UIAnim())
		self.bg:GetAnimState():SetBank("ui_chester_shadow_3x4")
		self.bg:GetAnimState():SetBuild("ui_chester_shadow_3x4")
		self.bg:GetAnimState():PlayAnimation("open")
		
	elseif self.item.components.unwrappable then
		self.bg = self:AddChild(UIAnim())
		self.bg:GetAnimState():SetBank("ui_bundle_2x2")
		self.bg:GetAnimState():SetBuild("ui_bundle_2x2")
		self.bg:GetAnimState():PlayAnimation("open")
		
	elseif self.item.prefab == "fish_farm" then
		self.bg = self:AddChild(Image())
		self.bg:SetTexture(HUD_ATLAS, "inventory_bg_single.tex")
	end
	
	if self.bg then
		self.bg:Hide()
		self.bg:SetClickable(false)
		self.basescale = 1
		
		self.bg:Show()
	end
end)

return Iai_ItemUI
