
local Text = require "widgets/text"
local Image = require "widgets/image"
local Widget = require "widgets/widget"
local UIAnim = require "widgets/uianim"
require("constants")

local Iai_ItemTile = Class(Widget, function(self, item)
	Widget._ctor(self, "Iai_ItemTile")
	
	self.item = item
	
	self.bg0 = self:AddChild(Image())
	self.bg0:SetTexture(HUD_ATLAS, "inv_slot.tex")
	self.bg0:Hide()
	self.bg0:SetClickable(false)
	
	self.bg = self:AddChild(Image())
	self.bg:SetTexture(HUD_ATLAS, "inv_slot_spoiled.tex")
	self.bg:Hide()
	self.bg:SetClickable(false)
	self.basescale = 1
	
	self.spoilage = self:AddChild(UIAnim())
	self.spoilage:GetAnimState():SetBank("spoiled_meter")
	self.spoilage:GetAnimState():SetBuild("spoiled_meter")
	self.spoilage:Hide()
	self.spoilage:SetClickable(false)
	
	self.bg0:Show()
	
	if self.item and
	self.item.prefab == "fish_farm" and
	self.item.components and
	self.item.components.breeder then
		if self.item.components.breeder.volume > 0 and
		self.item.components.breeder.product then
			self.bg:Show()
			self.spoilage:Show()
			self.spoilage:GetAnimState():SetPercent("anim", 0)
			
			local img, atl
			local test_prefab = SpawnPrefab(self.item.components.breeder.product)
			if test_prefab then
				atl, img = test_prefab.components.inventoryitem:GetAtlas(), test_prefab.components.inventoryitem:GetImage()
				test_prefab:Remove()
			else
				-- print((self.item.prefab).." IS REMOVED!!!")
				return
			end
			
			self.image = self:AddChild(Image(atl, img))
			self.image:SetClickable(false)
			
			self:SetQuantity(self.item.components.breeder.volume)
		end
		return
	end
	
	if self.item and
	self.item.is_bundled_item then
		if self.item.prefab and
		self.item.data then
			if self.item.data.bg then
				self.bg:Show()
			end
			
			if self.item.data.spoilage then
				self.spoilage:Show()
			end
			
			local img, atl
			local test_prefab = SpawnPrefab(self.item.prefab)
			if test_prefab then
				atl, img = test_prefab.components.inventoryitem:GetAtlas(), test_prefab.components.inventoryitem:GetImage()
				test_prefab:Remove()
			else
				-- print((self.item.prefab).." IS REMOVED!!!")
				return
			end
			
			self.image = self:AddChild(Image(atl, img))
			self.image:SetClickable(false)
			
			if self.item.data.stack then
				self:SetQuantity(self.item.data.stack)
			end
			
			if self.item.data.fuel_per then
				self:SetPercent(self.item.data.fuel_per)
			end

			if self.item.data.use_per then
				self:SetPercent(self.item.data.use_per)
			end

			if self.item.data.spoi_per then
				if self.item.data.spoilage then
					self:SetPerishPercent_Bundle(self.item.data.spoi_per)
				else
					self:SetPercent(self.item.data.spoi_per)
				end
			end
			
			if self.item.data.armor_per then
				self:SetPercent(self.item.data.armor_per)
			end
			
			return
		else
			return
		end
	end
	
	if not self.item then return end
	
	self.image = self:AddChild(Image(self.item.components.inventoryitem:GetAtlas(), self.item.components.inventoryitem:GetImage()))
	self.image:SetClickable(false)
	
	if self.item.prefab == "spoiled_food" or self.item.prefab == "spoiled_fish" or self:HasSpoilage() then
		self.bg:Show()
	end

	if self:HasSpoilage() then
		self.spoilage:Show()
	end

	if self.item.components.stackable then
		self:SetQuantity(self.item.components.stackable:StackSize())
	end
	
	if self.item.components.fueled then
		self:SetPercent(self.item.components.fueled:GetPercent(), self.item.components.fueled.currentfuel)
	end

	if self.item.components.finiteuses then
		self:SetPercent(self.item.components.finiteuses:GetPercent())
	end

	if self.item.components.perishable then
		if self:HasSpoilage() then
			self:SetPerishPercent(self.item.components.perishable:GetPercent())
		else
			self:SetPercent(self.item.components.perishable:GetPercent())
		end
	end
	
	if self.item.components.armor then
		self:SetPercent(self.item.components.armor:GetPercent())
	end
end)

function Iai_ItemTile:SetQuantity(quantity)
	if not self.quantity then
		self.quantity = self:AddChild(Text(NUMBERFONT, 42))
		self.quantity:SetPosition(2,16,0)
	end
	self.quantity:SetString(tostring(quantity))
end

function Iai_ItemTile:SetPerishPercent(percent)
	if self:HasSpoilage() then
		self.spoilage:GetAnimState():SetPercent("anim", 1-self.item.components.perishable:GetPercent())
	end
end

function Iai_ItemTile:SetPerishPercent_Bundle(percent)
	if self.item.data.spoilage then
		self.spoilage:GetAnimState():SetPercent("anim", 1-self.item.data.spoi_per)
	end
end

function Iai_ItemTile:SetPercent(percent)
	if not self.percent then
		self.percent = self:AddChild(Text(NUMBERFONT, 42))
		if JapaneseOnPS4() then
			self.percent:SetHorizontalSqueeze(0.7)
		end
		self.percent:SetPosition(5,-32+15,0)
	end
	local val_to_show = percent*100
	if val_to_show > 0 and val_to_show < 1 then
		val_to_show = 1
	end
	self.percent:SetString(string.format("%2.0f%%", val_to_show))
end

function Iai_ItemTile:HasSpoilage()
	return (self.item.components.perishable and (self.item.components.edible or self.item:HasTag("show_spoilage")))
end

return Iai_ItemTile
