
local Hoverer = require("widgets/hoverer")
local old_OnUpdate = Hoverer.OnUpdate
local Iai_ItemUI = require("widgets/iai_itemui")
local Iai_ItemTile = require("widgets/iai_itemtile")
local Unwrappable = require("components/unwrappable")
local old_WrapItems = Unwrappable.WrapItems
-- local INV_SCALE = .75
local SCENE_SCALE = .55
local X_OFFSET = 125
local Y_OFFSET = 175
local slotpos = {}

for y=2,-2,-1 do
	for x=-1,1 do
		table.insert(slotpos, Vector3(64*x, 64*y, 0))
	end
end

local bundle_slotpos = {
	Vector3(-37.5, 32 + 4, 0),
	Vector3(37.5, 32 + 4, 0),
	Vector3(-37.5, -(32 + 4), 0),
	Vector3(37.5, -(32 + 4), 0),
}

local fish_farm_slotpos = {Vector3(0,0,0)}

local function IsHUDScreen()
	if TheFrontEnd:GetActiveScreen() and
	TheFrontEnd:GetActiveScreen().name and
	type(TheFrontEnd:GetActiveScreen().name) == "string" and
	TheFrontEnd:GetActiveScreen().name == "HUD" then
		return true
	end
	return false
end

local function IsPressedAndHUD()
	return IsHUDScreen() and TheInput:IsControlPressed(CONTROL_FORCE_INSPECT)
end

local function DYC_info(bool)
	if GetPlayer() and
	GetPlayer().HUD and
	GetPlayer().HUD.dycIPObjectDetailRoot then
		if bool then
			GetPlayer().HUD.dycIPObjectDetailRoot.inst:Show()
		else
			GetPlayer().HUD.dycIPObjectDetailRoot.inst:Hide()
		end
	end
end

local function AdjustPos(self, sp, maxslots)
	local item = self.iai_item
	local scr_w, scr_h = TheSim:GetScreenSize()
	local pos = {left = 0, right = 0, up = 0}
	-- local pos = {left = 0, right = 0, up = 0, down = 0}
	
	local ui_world_pos = self.iai_iui:GetWorldPosition()
	
	pos.left = sp[1].x + ui_world_pos.x
	pos.right = sp[maxslots].x + ui_world_pos.x
	pos.up = sp[1].y + ui_world_pos.y
	-- pos.down = sp[maxslots].y + ui_world_pos.y
	
	if pos.left < 0 then
		self.iai_iui:SetPosition(self.iai_iui:GetPosition().x - pos.left, self.iai_iui:GetPosition().y, 0)
	end
	if pos.right > scr_w then
		self.iai_iui:SetPosition(self.iai_iui:GetPosition().x - pos.right + scr_w, self.iai_iui:GetPosition().y, 0)
	end
	if pos.up > scr_h then
		self.iai_iui:SetPosition(self.iai_iui:GetPosition().x, self.iai_iui:GetPosition().y - pos.up + scr_h, 0)
	end
	-- if pos.down < 0 then
		-- self.iai_iui:SetPosition(self.iai_iui:GetPosition().x, self.iai_iui:GetPosition().y - pos.down, 0)
	-- end
end

local function makeit(self, scale)
	local item = self.iai_item
	local x_offset = 0
	local y_offset = 0
	
	DYC_info(false)
	
	if not self.iai_it then
		self.iai_it = {}
	end
	
	self.iai_iui = self:AddChild(Iai_ItemUI(item))
	self.iai_iui:SetClickable(false)
	self.iai_iui:SetScale(scale,scale,scale)
	self.iai_iui:Show()
	
	if item.components.container then
		local sp = item.components.container.widgetslotpos
		
		if item.components.container.side_widget or
		item.prefab == "corkchest" or
		item.prefab == "octopuschest" then
			x_offset = X_OFFSET
		end
		
		y_offset = -sp[item.components.container.numslots].y + Y_OFFSET
		
		self.iai_iui:SetPosition((0+x_offset)*scale, (0+y_offset)*scale, 0)
		
		AdjustPos(self, sp, item.components.container.numslots)
		
		for i=1,item.components.container.numslots do
			self.iai_it[i] = self.iai_iui:AddChild(Iai_ItemTile(item.components.container.slots[i]))
			self.iai_it[i]:SetClickable(false)
			self.iai_it[i]:SetPosition(sp[i].x, sp[i].y, 0)
			self.iai_it[i]:Show()
		end
		
	elseif item.components.inventory then
		local sp = slotpos
		
		y_offset = 128 + Y_OFFSET
		
		self.iai_iui:SetPosition((0+x_offset)*scale, (0+y_offset)*scale, 0)
		
		local maxslots = item.components.inventory.maxslots < 16 and item.components.inventory.maxslots or 15
		
		AdjustPos(self, sp, maxslots)
		
		for i=1,maxslots do
			self.iai_it[i] = self.iai_iui:AddChild(Iai_ItemTile(item.components.inventory.itemslots[i]))
			self.iai_it[i]:SetClickable(false)
			self.iai_it[i]:SetPosition(sp[i].x, sp[i].y, 0)
			self.iai_it[i]:Show()
		end
	
	elseif item.components.unwrappable then
		local sp = bundle_slotpos
		
		y_offset = -sp[4].y + Y_OFFSET
		
		self.iai_iui:SetPosition((0+x_offset)*scale, (0+y_offset)*scale, 0)
		
		AdjustPos(self, sp, 4)
		
		-- no data
		if type(item.components.unwrappable.itemdata) ~= "table" then
			for i=1,4 do
				self.iai_it[i] = self.iai_iui:AddChild(Iai_ItemTile())
			end
			
		-- yes data
		elseif item.components.unwrappable.itemdata[1] then
		
			-- yes data no hook
			if not item.components.unwrappable.itemdata[1].is_bundled_item then
				for i=1,4 do
					if item.components.unwrappable.itemdata[i] then
						item.components.unwrappable.itemdata[i].is_bundled_item = true
					end
				end
			end
			for i=1,4 do
				self.iai_it[i] = self.iai_iui:AddChild(Iai_ItemTile(item.components.unwrappable.itemdata[i]))
			end
		
		-- ???
		else
			for i=1,4 do
				self.iai_it[i] = self.iai_iui:AddChild(Iai_ItemTile())
			end
		end
		
		for i=1,4 do
			self.iai_it[i]:SetClickable(false)
			self.iai_it[i]:SetPosition(sp[i].x, sp[i].y, 0)
			self.iai_it[i]:Show()
		end
		
	elseif item.prefab == "fish_farm" then
		local sp = fish_farm_slotpos
		
		y_offset = Y_OFFSET
		
		self.iai_iui:SetPosition((0+x_offset)*scale, (0+y_offset)*scale, 0)
		
		AdjustPos(self, sp, 1)
		
		for i=1,1 do
			self.iai_it[i] = self.iai_iui:AddChild(Iai_ItemTile(item))
			self.iai_it[i]:SetClickable(false)
			self.iai_it[i]:SetPosition(sp[i].x, sp[i].y, 0)
			self.iai_it[i]:Show()
		end
	end
end

local function killit(self)
	if self.iai_iui then
		self.iai_iui:Kill()
		self.iai_iui = nil
	end
	
	if self.iai_item then
		self.iai_item = nil
	end
	
	DYC_info(true)
end

Hoverer.OnUpdate = function(self, ...)
	if old_OnUpdate then old_OnUpdate(self, ...) end
	
	if not IsPressedAndHUD() then
		killit(self)
		return
	end
	
	local item = TheInput:GetHUDEntityUnderMouse()
	
	if item and
	item.widget and
	item.widget.parent and
	item.widget.parent.item and
	item.widget.parent.item.components and
	item.widget.parent.item.components.inventoryitem and
	(item.widget.parent.item.components.container and
	item.widget.parent.item.components.container.numslots and
	item.widget.parent.item.components.container.numslots > 0 and not
	item.widget.parent.item.components.container:IsOpen() or
	item.widget.parent.item.components.unwrappable) then
		item = item.widget.parent.item
		-- print("Is a INV bag", item)
	else
		item = TheInput:GetWorldEntityUnderMouse()
		if item and
		item.components and
		item ~= GetPlayer() and
		(item.components.container and
		item.components.container.numslots and
		item.components.container.numslots > 0 and not
		item.components.container:IsOpen() or
		(item.components.inventory and
		item.components.inventory.maxslots and
		item.components.inventory.maxslots > 0) or
		item.components.unwrappable or
		item.prefab == "fish_farm") then
			-- print("Is a SCE bag", item)
		else
			-- print("INVALID ITEM")
			item = nil
		end
	end
	
	if item then
		if self.iai_item ~= item then
			killit(self)
			self.iai_item = item
			makeit(self, SCENE_SCALE)
		end
	else
		killit(self)
	end
end

local function HasSpoilage(item)
	return (item.components.perishable and (item.components.edible or item:HasTag("show_spoilage")))
end

Unwrappable.WrapItems = function(self, items, ...)
	old_WrapItems(self, items, ...)
	
	if #items > 0 and
	self.itemdata and
	type(self.itemdata) == "table" and
	next(self.itemdata) then
		for k,v in ipairs(items) do
			self.itemdata[k].is_bundled_item = true

			if self.itemdata[k].data == nil then
				self.itemdata[k].data = {}
			end
			
			local d = self.itemdata[k].data
			
			if v.prefab == "spoiled_food" or
			v.prefab == "spoiled_fish" or
			HasSpoilage(v) then
				d.bg = true
			end
			
			if HasSpoilage(v) then
				d.spoilage = true
			end
			
			if v.components.stackable then
				d.stack = v.components.stackable:StackSize()
			end
			
			if v.components.fueled then
				d.fuel_per = v.components.fueled:GetPercent()
			end

			if v.components.finiteuses then
				d.use_per = v.components.finiteuses:GetPercent()
			end

			if v.components.perishable then
				d.spoi_per = v.components.perishable:GetPercent()
			end
			
			if v.components.armor then
				d.armor_per = v.components.armor:GetPercent()
			end
		end
	end
end
