name = "Gesture Wheel"
description = "Adds a wheel selection interface for emotes, making it easier to emote."
author = "rezecib"
version = "1.0.2"

forumthread = ""

api_version = 10

-- Compatible with the base game & ROG
dont_starve_compatible = true
reign_of_giants_compatible = true
dst_compatible = true

icon_atlas = "modicon.xml"
icon = "modicon.tex"

--These let clients know if they need to get the mod from the Steam Workshop to join the game
all_clients_require_mod = false

--This determines whether it causes a server to be marked as modded (and shows in the mod list)
clients_only_mod = true

--This lets people search for servers with this mod by these tags
server_filter_tags = {}

local alpha = {"A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"}
local KEY_A = 97
local keyslist = {}
for i = 1,#alpha do keyslist[i] = {description = alpha[i],data = i + KEY_A - 1} end

configuration_options =
{
    {
        name = "togglekey",
        label = "Toggle Button",
        options = keyslist,
        default = 103, --G
    },    
    {
        name = "imagetext",
        label = "Show Picture/Text",
        options = {
			{description = "Picture and Text", data = 3},
			{description = "Picture Only", data = 2},
			{description = "Text Only", data = 1},
		},
        default = 3,
    },    
    {
        name = "center",
        label = "Center Wheel",
        options = {
			{description = "Off", data = false},
			{description = "On", data = true},
		},
        default = false,
    },    
}