require("map/tasks")
------------------------------------------------------------
-- Island Hopping
------------------------------------------------------------
AddTask("Archipelago_Grasslands", {
		locks=LOCKS.NONE,
		keys_given=KEYS.MEAT,
		entrance_room = "ForceDisconnectedRoom",
		room_choices={
			["Guarded_PigKingdom"] = 1, 
			["WalrusHut_Grassy"] = 2,
			["BeeClearing"] = 1+math.random(2), 
			["FlowerPatch"] = 2, 
			["Guarded_Pondopolis"] = 1,
		}, 
		room_bg=GROUND.GRASS,
		background_room="BGGrass",
		colour={r=1,g=1,b=0,a=1}
	}) 
AddTask("Archipelago_Plains", {
		locks={LOCKS.MEAT},
		keys_given={KEYS.MEAT},
		entrance_room = "ForceDisconnectedRoom",
		room_choices={
			["BeefalowPlain"] = 3,
			["WalrusHut_Plains"] = 2,
		}, 
		room_bg=GROUND.SAVANNA,
		background_room="BGSavanna",
		colour={r=0,g=1,b=1,a=1}
	}) 
AddTask("Archipelago_Rocky", {
		locks=LOCKS.MEAT,
		keys_given=KEYS.MEAT,
		entrance_room = "ForceDisconnectedRoom",
		room_choices={
			["Rocky"] = 6,
		 }, 
		room_bg=GROUND.ROCKY,
		background_room="BGRocky",
		colour={r=0,g=1,b=0,a=1}
	})
AddTask("Archipelago_Swamp", {
		locks={LOCKS.MEAT},
		keys_given={KEYS.MEAT},
		entrance_room = "ForceDisconnectedRoom",
		room_choices={
			["Marsh"] = 2+math.random(3), 
			["SlightlyMermySwamp"]=3,
		},
		room_bg=GROUND.MARSH,
		background_room="BGMarsh",
		colour={r=.05,g=.05,b=.05,a=1}
	})
AddTask("Archipelago_Chess", {
		locks={LOCKS.MEAT},
		keys_given={KEYS.MEAT},
		entrance_room = "ForceDisconnectedRoom",
		room_choices={
			["MarbleForest"] = 2,
			["Thickchess"] = 2,
		},  
		room_bg=GROUND.CHECKER,
		background_room="MarbleForest",
		colour={r=.05,g=.5,b=.05,a=1},
	})
	
AddTask("Archipelago_WASPS", {
		locks=LOCKS.MEAT,
		keys_given=KEYS.MEAT,
		entrance_room = "ForceDisconnectedRoom",
		room_choices={
			["Waspnests"] = 3,	
		},
		room_bg=GROUND.DIRT,
		background_room="BGDeepForest",
		colour={r=math.random(),g=math.random(),b=math.random(),a=math.random()},
	})
AddTask("Archipelago_Graveyard", {
		locks=LOCKS.MEAT,
		keys_given=KEYS.MEAT,
		entrance_room = "ForceDisconnectedRoom",
		room_choices={
			["Graveyard"] = 3,
		}, 
		room_bg=GROUND.ROCKY,
		background_room="BGNoise",
		colour={r=1,g=1,b=0,a=1}
	}) 
AddTask("Archipelago_Houndoris", {
		locks=LOCKS.MEAT,
		keys_given=KEYS.MEAT,
		entrance_room = "ForceDisconnectedRoom",
		room_choices={
			["Moundfield"] = 3,
			["WalrusHut_Rocky"] = 1,
		}, 
		room_bg=GROUND.FOREST,
		background_room="BGRocky",
		colour={r=1,g=1,b=0,a=1}
	}) 
AddTask("Archipelago_IslandOfTheTallbirds", {
		locks=LOCKS.MEAT,
		keys_given=KEYS.MEAT,
		entrance_room = "ForceDisconnectedRoom",
		room_choices={
			["TallbirdNests"] = 2,
			["WalrusHut_Rocky"] = 1,
		}, 
		room_bg=GROUND.ROCKY,
		background_room="BGRocky",
		colour={r=1,g=1,b=0,a=1}
	}) 