require("map/tasks")
local blockersets = require("map/blockersets")

AddTask("biosphere_start_Challenging", {
		locks=LOCKS.NONE,
		keys_given={KEYS.PICKAXE,KEYS.AXE,KEYS.GRASS,KEYS.WOOD,KEYS.TIER1},
		room_choices={
			["Biosphere_Clearing"] = 1, 
		}, 
		room_bg=GROUND.GRASS,
		background_room="BGGrass",
		colour={r=1,g=1,b=0,a=1},
	})
AddTask("biosphere_frogsandwasps_challenging", {
		locks={LOCKS.BASIC_COMBAT,LOCKS.TIER3},
		keys_given={KEYS.MEAT,KEYS.GRASS,KEYS.HONEY,KEYS.TIER2,KEYS.WALRUS,KEYS.TIER5},
		entrance_room= "Waspnests",
		room_choices={
			["Biosphere_Guarded_Pondopolis"] = 1, 
		}, 
		room_bg=GROUND.GRASS,
		background_room="BGGrass",
		colour={r=1,g=1,b=0,a=1},
	})
AddTask("biosphere_rocky_challenging", {
		locks={LOCKS.ROCKS},
		keys_given={KEYS.TRINKETS,KEYS.STONE,KEYS.WOOD,KEYS.TIER1,KEYS.WALRUS,KEYS.TIER5},
		entrance_room=blockersets.tallbirds_hard,
		room_choices={
			["Biosphere_Rocky"] = 1,
		}, 
		room_bg=GROUND.ROCKY,
		background_room="BGNoise",
		colour={r=1,g=1,b=0,a=1},
	})
AddTask("biosphere_landofthepigs_challenging", {
		locks={LOCKS.PIGKING,LOCKS.TIER2},
		keys_given={KEYS.PIGS,KEYS.GOLD,KEYS.TIER3},
		entrance_room=blockersets.pigs_hard,
		room_choices={
			["Biosphere_Guarded_PigKingdom"] = 1, 
		}, 
		room_bg=GROUND.ROCKY,
		background_room="BGNoise",
		colour={r=1,g=1,b=0,a=1},
	})
AddTask("biosphere_beefaloplains_challenging", {
		locks={LOCKS.ADVANCED_COMBAT,LOCKS.TIER4},
		keys_given={KEYS.MEAT,KEYS.WOOL,KEYS.POOP,KEYS.HOUNDS,KEYS.WALRUS,KEYS.TIER4},
		entrance_room="Walrusfield",
		room_choices={
			["Biosphere_BeefalowPlain"] = 1,
		}, 
		room_bg=GROUND.SAVANNA,
		background_room="BGSavanna",
		colour={r=1,g=1,b=0,a=1},
	})
AddTask("biosphere_insane_challenging", {
		locks={LOCKS.ADVANCED_COMBAT,LOCKS.TIER4},
		keys_given={KEYS.MEAT,KEYS.WOOL,KEYS.POOP,KEYS.HOUNDS,KEYS.WALRUS,KEYS.TIER4},
		entrance_room=blockersets.merms_hard,
		room_choices={
			["SanityWall"] = 1,
			["InsanityWall"] = 1,
			
		}, 
		room_bg=GROUND.MARSH,
		background_room="BGMarsh",
		colour={r=1,g=1,b=0,a=1},
	})
AddTask("biosphere_marsh_challenging", {
		locks={LOCKS.ADVANCED_COMBAT,LOCKS.TIER4},
		keys_given={KEYS.MEAT,KEYS.WOOL,KEYS.POOP,KEYS.HOUNDS,KEYS.WALRUS,KEYS.TIER4},
		entrance_room=blockersets.tentacles_hard,
		room_choices={
			["Marsh"] = 1,
		}, 
		room_bg=GROUND.MARSH,
		background_room="BGMarsh",
		colour={r=1,g=1,b=0,a=1},
	})

--------------------------------
-- optional tasks --------------
--------------------------------	
AddTask("biosphere_tallbirds_challenging", {
		locks={LOCKS.ONLYTIER1},
		keys_given={KEYS.TALLBIRDS,KEYS.MEAT,KEYS.WOOL,KEYS.POOP,KEYS.TIER3,KEYS.TIER4,KEYS.GOLD,KEYS.AXE},
		entrance_room="Moundfield",
		room_choices={
			["TallbirdNests"] = 1,
		}, 
		room_bg=GROUND.ROCKY,
		background_room="BGRocky",
		colour={r=1,g=1,b=0,a=1},
	})
AddTask("biosphere_howsaboutanicegameofchess_challenging", {
		locks={LOCKS.ONLYTIER1},
		keys_given={KEYS.TALLBIRDS,KEYS.MEAT,KEYS.WOOL,KEYS.POOP,KEYS.TIER3,KEYS.TIER4,KEYS.GOLD,KEYS.AXE},
		entrance_room=blockersets.chess_hard,
		room_choices={
			["Thickchess"] = 1,
		}, 
		room_bg=GROUND.CHECKER,
		background_room="BGRocky",
		colour={r=1,g=1,b=0,a=1},
	})
AddTask("biosphere_OHGODSPIDERS_challenging", {
		locks={LOCKS.KILLERBEES,LOCKS.TIER3},
		keys_given={KEYS.HONEY,KEYS.TIER3},
		entrance_room= "Waspnests",
		room_choices={
			["FlowerPatch"] = 1,
		}, 
		room_bg=GROUND.GRASS,
		background_room="BGGrass",
		colour={r=1,g=1,b=0,a=1},
	})
