require("map/tasks")

AddTask("biosphere_start", {
		locks=LOCKS.NONE,
		keys_given={KEYS.PICKAXE,KEYS.AXE,KEYS.GRASS,KEYS.WOOD,KEYS.TIER1},
		room_choices={
			["Biosphere_Forest"] = 1,
			["Biosphere_Plain"] = 1, 
			["Biosphere_Rocky"] = 1,
			["Biosphere_PigKingdom"] = 1, 
		}, 
		room_bg=GROUND.GRASS,
		background_room="BGGrass",
		colour={r=1,g=1,b=0,a=1},
	})
AddTask("biosphere_frogsbeesandwalrusesohmy", {
		locks={LOCKS.BASIC_COMBAT,LOCKS.TIER3},
		keys_given={KEYS.MEAT,KEYS.GRASS,KEYS.HONEY,KEYS.TIER2,KEYS.WALRUS,KEYS.TIER5},
		room_choices={
			["Biosphere_BeeClearing"] = 1,
			["Biosphere_Pondopolis"] = 1, 
			["Biosphere_WalrusHut_Rocky"] = 1,
		}, 
		room_bg=GROUND.GRASS,
		background_room="BGGrass",
		colour={r=1,g=1,b=0,a=1},
	})
AddTask("biosphere_rocky", {
		locks={LOCKS.ROCKS},
		keys_given={KEYS.TRINKETS,KEYS.STONE,KEYS.WOOD,KEYS.TIER1,KEYS.WALRUS,KEYS.TIER5},
		room_choices={
			["Biosphere_Plain"] = 1, 
			["Biosphere_WalrusHut_Grassy"] = 1,
		}, 
		room_bg=GROUND.ROCKY,
		background_room="BGNoise",
		colour={r=1,g=1,b=0,a=1},
	})
AddTask("biosphere_landofthepigs", {
		locks={LOCKS.PIGKING,LOCKS.TIER2},
		keys_given={KEYS.PIGS,KEYS.GOLD,KEYS.TIER3},
		room_choices={
			["Biosphere_Forest"] = 1,
			["Biosphere_Clearing"] = 1, 
		}, 
		room_bg=GROUND.ROCKY,
		background_room="BGNoise",
		colour={r=1,g=1,b=0,a=1},
	})
AddTask("biosphere_plains", {
		locks={LOCKS.ADVANCED_COMBAT,LOCKS.TIER4},
		keys_given={KEYS.MEAT,KEYS.WOOL,KEYS.POOP,KEYS.HOUNDS,KEYS.WALRUS,KEYS.TIER4},
		room_choices={
			["Marsh"] = 1,
			["Biosphere_WalrusHut_Plains"] = 1,
		}, 
		room_bg=GROUND.SAVANNA,
		background_room="BGSavanna",
		colour={r=1,g=1,b=0,a=1},
	})
AddTask("biosphere_lordoftheflies", {
		locks={LOCKS.ADVANCED_COMBAT,LOCKS.TIER4},
		keys_given={KEYS.MEAT,KEYS.WOOL,KEYS.POOP,KEYS.HOUNDS,KEYS.WALRUS,KEYS.TIER4},
		room_choices={
			["Biosphere_BeefalowPlain"] = 1,
			["MermTown"] = 1,
		}, 
		room_bg=GROUND.MARSH,
		background_room="BGMarsh",
		colour={r=1,g=1,b=0,a=1},
	})

	
--------------------------------
-- optional tasks --------------
--------------------------------	


AddTask("biosphere_aintnothingbuthounds", {
		locks=LOCKS.MEAT,
		keys_given=KEYS.MEAT,
		room_choices={
			["Moundfield"] = 1,
		}, 
		room_bg=GROUND.FOREST,
		background_room="BGRocky",
		colour={r=1,g=1,b=0,a=1},
	})
AddTask("biosphere_tallbirds", {
		locks={LOCKS.ONLYTIER1},
		keys_given={KEYS.TALLBIRDS,KEYS.MEAT,KEYS.WOOL,KEYS.POOP,KEYS.TIER3,KEYS.TIER4,KEYS.GOLD,KEYS.AXE},
		room_choices={
			["TallbirdNests"] = 1,
		}, 
		room_bg=GROUND.ROCKY,
		background_room="BGRocky",
		colour={r=1,g=1,b=0,a=1},
	})
AddTask("biosphere_howsaboutanicegameofchess", {
		locks={LOCKS.ONLYTIER1},
		keys_given={KEYS.TALLBIRDS,KEYS.MEAT,KEYS.WOOL,KEYS.POOP,KEYS.TIER3,KEYS.TIER4,KEYS.GOLD,KEYS.AXE},
		room_choices={
			["Thickchess"] = 1,
		}, 
		room_bg=GROUND.CHECKER,
		background_room="BGRocky",
		colour={r=1,g=1,b=0,a=1},
	})
AddTask("biosphere_OHGODSPIDERS", {
		locks={LOCKS.SPIDERDENS,LOCKS.MONSTERS_DEFEATED,LOCKS.TIER3},
		keys_given={KEYS.SPIDERS,KEYS.TIER4},
		room_choices={
			["SpiderCity"] = 1,
		}, 
		room_bg=GROUND.FOREST,
		background_room="SpiderForest",
		colour={r=1,g=1,b=0,a=1},
	})
AddTask("biosphere_flowersandkillerbees", {
		locks={LOCKS.KILLERBEES,LOCKS.TIER3},
		keys_given={KEYS.HONEY,KEYS.TIER3},
		entrance_room= "Waspnests",
		room_choices={
			["Waspnests"] = 1,
			["FlowerPatch"] = 1,
		}, 
		room_bg=GROUND.GRASS,
		background_room="BGGrass",
		colour={r=1,g=1,b=0,a=1},
	})
