local require = GLOBAL.require
require("map/lockandkey")

local LOCKS = GLOBAL.LOCKS
local KEYS = GLOBAL.KEYS
local SIZE_VARIATION = 3
local GROUND = GLOBAL.GROUND

local function LevelPreInit(level)
	level.overrides.start_node = "EXMG_StarterZone"
	level.numoptionaltasks = 10
	
	table.insert(level.tasks, "EXMG_StarterArea")
	table.insert(level.tasks, "EXMG_Wilds")
	table.insert(level.tasks, "EXMG_MushArea")
	table.insert(level.tasks, "EXMG_BatArea")
	table.insert(level.tasks, "EXMG_CaveSpiderArea")
	table.insert(level.tasks, "EXMG_RockLobsterArea")
	table.insert(level.tasks, "EXMG_Residential")
	table.insert(level.tasks, "EXMG_TheLabyrinth")
	
	table.insert(level.tasks, "EXMG_TentacledCave")
	table.insert(level.tasks, "EXMG_Sacred")
	
	
	--level.tasks = { "ONE_GIANT_ROOM" }
	
	--print(level)
end

AddLevelPreInitAny(LevelPreInit)

AddTask("ONE_GIANT_ROOM", {
		locks=LOCKS.NONE,
		keys_given=KEYS.NONE,
		room_choices={
			["EXMG_StarterZone"] = 3, 
			["Forest"] = 3 + math.random(SIZE_VARIATION), 
			["BarePlain"] = 3 + math.random(SIZE_VARIATION), 
			["Plain"] = 3 + math.random(SIZE_VARIATION), 
			["Clearing"] = 3 + math.random(SIZE_VARIATION),
			["Pondopolis"] = 3 + math.random(SIZE_VARIATION),
			["BeeClearing"] = 3 + math.random(SIZE_VARIATION),
			["EvilFlowerPatch"] = 3 + math.random(SIZE_VARIATION), 
			["FlowerPatch"] = 3 + math.random(SIZE_VARIATION), 
			["WalrusHut_Plains"] = 1,
			["WalrusHut_Grassy"] = 1,
			["WalrusHut_Rocky"] = 1,
			["BGGrass"] = 2 + math.random(SIZE_VARIATION),
			["BGRocky"] = 2 + math.random(SIZE_VARIATION),
			["Graveyard"] = 3 + math.random(SIZE_VARIATION),
			["DeepForest"] = 2 + math.random(SIZE_VARIATION),
			["PigVillage"] = 1 + math.random(SIZE_VARIATION),
			["BGForest"] = 3 + math.random(SIZE_VARIATION), 
			["PigKingdom"] = 1, 
			["Graveyard"] = 1,
			["CrappyDeepForest"] = 3 + math.random(SIZE_VARIATION),
			["SpiderForest"] = 3 + math.random(SIZE_VARIATION),
			["BeefalowPlain"] = 3 + math.random(SIZE_VARIATION), 
			["Moundfield"] = 1 + math.random(SIZE_VARIATION), 		
			["MermTown"] = 1+math.random(SIZE_VARIATION), 
			["SpiderMarsh"] = 3+math.random(SIZE_VARIATION), 
			["Marsh"] = 3+math.random(SIZE_VARIATION), 
			["DeepForest"] = 2+math.random(SIZE_VARIATION), 
			["Sinkhole"] = 1,
			["SlightlyMermySwamp"]=1,
			["TallbirdNests"] = 1+math.random(SIZE_VARIATION), 
			["ChessForest"] = 1+math.random(SIZE_VARIATION),
			["ChessBarrens"] = 1+math.random(SIZE_VARIATION),
			["ChessMarsh"] = 1+math.random(SIZE_VARIATION),
			["Waspnests"] = 1+math.random(SIZE_VARIATION), 
		},
		room_bg=GROUND.FOREST,
		background_room="EXMG_StarterZone",
		colour={r=0.3,g=0.3,b=0.3,a=0.3},
	})

AddTask("EXMG_StarterArea", {
		locks=LOCKS.NONE,
		keys_given=KEYS.NONE,
		room_choices={
			["EXMG_StarterZone"] = 3, 
		},
		room_bg=GROUND.FOREST,
		background_room="BGGrass",
		colour={r=0.3,g=0.3,b=0.3,a=0.3},
	})

AddRoom("EXMG_StarterZone", {
					colour={r=.8,g=0.5,b=.6,a=.50},
					value = GROUND.FOREST,
					tags = {"ExitPiece", "Chester_Eyebone"},
					contents =  {
									countprefabs = {
    										spawnpoint_multiplayer = 1,
    									},
					                distributepercent = .1,
					                distributeprefabs=
					                {
                                        fireflies = 1,
					                    evergreen = 1.5,
					                    grass = .1,
					                    sapling =.9,
					                    berrybush=.1,
					                },
					            }
					})

---
--- Slurper Wilds
--- 
AddTask("EXMG_Wilds", {
		locks={LOCKS.BASIC_COMBAT, LOCKS.TIER4},
		keys_given={KEYS.TIER5},
	--	entrance_room="BGRocky",
		room_choices={
			["EXMG_SlurperWilds"] = 1 + math.random(SIZE_VARIATION), 
			["EXMG_LushWilds"] = 1 + math.random(SIZE_VARIATION), 
			["EXMG_LightWilds"] = 1 + math.random(SIZE_VARIATION),
		},
		room_bg=GROUND.FUNGUS,
		background_room="EXMG_LushWilds",
		colour={r=1,g=0,b=0.6,a=1},
	})
	
AddRoom("EXMG_SlurperWilds", {
					colour={r=0.3,g=0.2,b=0.1,a=0.3},
					value = GROUND.MUD, 
					contents =  {
									distributepercent = 0.15,
					                distributeprefabs= 
					                {
					                    blue_mushroom = .15,
					                   	lichen = .25,
					                	cave_fern = 1,
					                    pillar_algae = .01,
					                	slurper = .35,
										--bat = 0.15,
										--spiderden = .01,
					                }
					            }
					})

AddRoom("EXMG_LushWilds", {
					colour={r=0.3,g=0.2,b=0.1,a=0.3},
					value = GROUND.MUD, 
					contents =  {
									distributepercent = 0.25,
					                distributeprefabs= 
					                {
					                    blue_mushroom = .15,
					                   	lichen = .25,
					                	cave_fern = 1,
					                    pillar_algae = .05,	

					                    worm = 0.01,
										--spiderden = .01,
										--bat = 0.15,

					                    fissure_lower = 0.07,

					                    flower_cave = .1,
					                    flower_cave_double = .03,
					                    flower_cave_triple = .01,				                	
					                }
					            }
					})

AddRoom("EXMG_LightWilds", {
					colour={r=0.3,g=0.2,b=0.1,a=0.3},
					value = GROUND.MUD, 
					contents =  {
									distributepercent = 0.15,
					                distributeprefabs= 
					                {
					                    blue_mushroom = .1,
					                   	lichen = .1,
					                	cave_fern = .7,
					                    pillar_algae = .05,

					                    flower_cave = .75,
					                    flower_cave_double = .33,
					                    flower_cave_triple = .15,

					                    fissure_lower = 0.07,
					                }
					            }
					})

---
--- Mush Area
---
AddTask("EXMG_MushArea", {
		locks={LOCKS.BASIC_COMBAT, LOCKS.TIER4},
		keys_given={KEYS.TIER5},
	--	entrance_room="BGRocky",
		room_choices={
			["EXMG_GreenMush"] = 1 + math.random(SIZE_VARIATION), 
			["EXMG_RedMush"] = 1 + math.random(SIZE_VARIATION), 
			["EXMG_BlueMush"] = 1 + math.random(SIZE_VARIATION), 
			["EXMG_NoisyFungus"] = 1 + math.random(SIZE_VARIATION), 
			["EXMG_RabitFungusRoom"] = 1
		},
		room_bg=GROUND.FUNGUS,
		background_room="EXMG_NoisyFungus",
		colour={r=1,g=0,b=0.6,a=1},
	})
	
AddRoom("EXMG_RabitFungusRoom", {
					colour={r=0.3,g=0.2,b=0.1,a=0.3},
					value = GROUND.FUNGUS,
					--tags = {"ForceConnected"},
					contents =  {
					                distributepercent = .2,
					                distributeprefabs=
					                {
					                	flower_cave = 0.5,
					                	flower_cave_triple = 0.15,
					                	flower_cave_double = 0.1,
					                	carrot_planted = 1,

					                	green_mushroom = 0.5,
					                	blue_mushroom = 0.5,
					                	red_mushroom = 0.5,

					     --                mushtree_tall = 0.5,
										-- mushtree_medium = 0.5,
										-- mushtree_small = 0.5,

					                    rabbithouse = 0.51,
					                	cave_fern=0.5,
					                }
					            }
					})

AddRoom("EXMG_GreenMush", {
					colour={r=0.3,g=0.2,b=0.1,a=0.3},
					value = GROUND.FUNGUSGREEN, 
					--tags = {"ForceConnected"},
					contents =  {
					                distributepercent = .175,
					                distributeprefabs=
					                {
					                	slurtlehole = 0.05,
					                    worm = 0.05,
										--tallbirdnest=0.01,
										--spiderden=0.01,
										carrot_planted = 0.01,

					                	cave_fern=0.5,
					                	flower_cave = 0.5,
					                	flower_cave_triple = 0.15,
					                	flower_cave_double = 0.1,

					                	green_mushroom = 0.9,					                	
										mushtree_small = 0.5,
					                }
					            }
					})

AddRoom("EXMG_RedMush", {
					colour={r=0.3,g=0.2,b=0.1,a=0.3},
					value = GROUND.FUNGUSRED, 
					--tags = {"ForceConnected"},
					contents =  {
					                distributepercent = .175,
					                distributeprefabs=
					                {
					                	slurtlehole = 0.05,
					                    worm = 0.05,
										--tallbirdnest=0.01,
										--spiderden=0.01,
										carrot_planted = 0.01,

					                	cave_fern=0.5,
					                	flower_cave = 0.5,
					                	flower_cave_triple = 0.15,
					                	flower_cave_double = 0.1,

					                	red_mushroom = 0.9,					                	
										mushtree_medium = 0.5,

					                }
					            }
					})

AddRoom("EXMG_BlueMush", {
					colour={r=0.3,g=0.2,b=0.1,a=0.3},
					value = GROUND.FUNGUS, 
					--tags = {"ForceConnected"},
					contents =  {
					                distributepercent = .175,
					                distributeprefabs=
					                {
					                	slurtlehole = 0.05,
					                    worm = 0.05,
										--tallbirdnest=0.01,
										--spiderden=0.01,
										carrot_planted = 0.01,
					                	
					                	cave_fern=0.5,
					                	flower_cave = 0.5,
					                	flower_cave_triple = 0.15,
					                	flower_cave_double = 0.1,

					                	blue_mushroom = 0.9,					                	
										mushtree_tall = 0.5,

					                }
					            }
					})

AddRoom("EXMG_NoisyFungus", {
					colour={r=0.3,g=0.2,b=0.1,a=0.3},
					value = GROUND.MUD, 
					--tags = {"ForceConnected"},
					contents =  {
					                distributepercent = .2,
					                distributeprefabs=
					                {
					                    slurtlehole = 0.1,
					                    worm = 0.1,
										--tallbirdnest=0.01,
										--spiderden=0.01,
										
										carrot_planted = 0.01,

					                    flower_cave = 1,
					                    flower_cave_double = .6,
					                    flower_cave_triple = .4,

					                    mushtree_tall = 0.5,
										mushtree_medium = 0.5,
										mushtree_small = 0.5,
					                	
					                	cave_fern=0.02,
					                    goldnugget=.05,
					                }
					            }
					})
---
--- Bat Area
---
AddTask("EXMG_BatArea", {
		locks={LOCKS.BASIC_COMBAT, LOCKS.TIER4},
		keys_given={KEYS.TIER5},
		entrance_room="BGDeepForest",
		room_choices={
			["EXMG_BatCaveRoom"] = 1 + math.random(SIZE_VARIATION), 
		},
		room_bg=GROUND.CAVE,
		background_room="BGDeepForest",
		colour={r=0.3,g=0.3,b=0.3,a=0.3},
	})

AddRoom("EXMG_BatCaveRoom", {
					colour={r=0.3,g=0.2,b=0.1,a=0.3},
					value = GROUND.CAVE, 
					contents =  {
					                distributepercent = .15,
					                distributeprefabs=
					                {
										tallbirdnest=0.01,
					                    bat = 0.5,
					                    guano = 0.27,
										goldnugget=.05,
										flint=0.05,
										stalagmite_tall=0.4,
										stalagmite_tall_med=0.4,
										stalagmite_tall_low=0.4,
										pillar_cave = 0.08,
										fissure = 0.05,
					                }
					            }
					})
---
--- Cave Spider Area
---
AddTask("EXMG_CaveSpiderArea", {
		locks={LOCKS.BASIC_COMBAT, LOCKS.TIER4},
		keys_given={KEYS.TIER5},
		entrance_room="BGDeepForest",
		room_choices={
			["EXMG_CaveSpiderPlains"] = 1 + math.random(SIZE_VARIATION), 
		},
		room_bg=GROUND.CAVE,
		background_room="BGDeepForest",
		colour={r=0.3,g=0.3,b=0.3,a=0.3},
	})
	
AddRoom("EXMG_CaveSpiderPlains", {
					colour={r=0.3,g=0.2,b=0.1,a=0.3},
					value = GROUND.CAVE,
					contents =  {
					                distributepercent = .15,
					                distributeprefabs=
					                {
					                	stalagmite = 0.15,
					                	stalagmite_med = 0.15,
					                	stalagmite_low = 0.15,
					                
										--stalagmite_tall=0.5,
					                	--stalagmite_gold = 0.05,
					                    spiderhole= .125,
					                    slurtlehole = 0.01,
					                    pillar_cave = 0.08,
					                    fissure = 0.05,
					                }
					            }
					})

---
--- RockLobster Area
---
AddTask("EXMG_RockLobsterArea", {
		locks={LOCKS.BASIC_COMBAT, LOCKS.TIER4},
		keys_given={KEYS.TIER5},
		entrance_room="BGDeepForest",
		room_choices={
			["EXMG_RockLobsterPlains"] = 1 + math.random(SIZE_VARIATION), 
		},
		room_bg=GROUND.CAVE,
		background_room="BGDeepForest",
		colour={r=0.3,g=0.3,b=0.3,a=0.3},
	})
	
-- Rock Lobster Plains
AddRoom("EXMG_RockLobsterPlains", {
					colour={r=0.3,g=0.2,b=0.1,a=0.3},
					value = GROUND.CAVE, 
					contents =  {
					                distributepercent = .15,
					                distributeprefabs=
					                {
					                	rocky = .25,
										goldnugget=.05,
										rocks=.1,
										flint=0.05,
					                	rock_flintless = 0.2,
					                	rock_flintless_med = 0.2,
					                	rock_flintless_low = 0.2,										
										pillar_cave = 0.02,
										fissure = 0.02,
					                }
					            }
					})
					
-- MOnkey wilds
AddTask("EXMG_Residential", {
		locks={LOCKS.BASIC_COMBAT, LOCKS.TIER5},
		keys_given={KEYS.TIER6},
		entrance_room = "RuinedCityEntrance",
		room_choices =
		{
			["EXMG_Vacant"] = 1 + math.random(SIZE_VARIATION),
			["EXMG_BGMonkeyWilds"] = 4 + math.random(SIZE_VARIATION),
		},
		room_bg = GROUND.TILES,
		maze_tiles = {rooms = {"room_residential", "room_residential_two", "hallway_residential", "hallway_residential_two"}, bosses = {"room_residential"}},
		background_room="EXMG_BGMonkeyWilds",
		colour={r=1,g=0,b=0.6,a=1},
	})
	
AddRoom("EXMG_BGMonkeyWilds", {	
					colour={r=0.3,g=0.2,b=0.1,a=0.3},
					value = GROUND.MUD, 
					tags = {"Maze"},
					contents =  {
									distributepercent = 0.09,
					                distributeprefabs= 
					                {
					                	lichen = .3,
					                	cave_fern = 1,
					                    pillar_algae = .05,

					                    cave_banana_tree = 0.1,
					                    monkeybarrel = 0.06,
					                    slurper = 0.06,
					                    pond_cave = 0.07,
					                    fissure_lower = 0.04,
					                    worm = 0.04,
					                }
					            }
					})
AddRoom("EXMG_Vacant", {
					colour={r=0.3,g=0.2,b=0.1,a=0.3},
					value = GROUND.MUD, 
					contents =  {
									countstaticlayouts =
									{
										["CornerWall"] = math.random(1,3),
										["StraightWall"] = math.random(1,2),
										["CornerWall2"] = math.random(1,2),
										["StraightWall2"] = math.random(1,3),
									},
									distributepercent = 0.12,
					                distributeprefabs= 
					                {
					                	lichen = .4,
					                	cave_fern = .6,
					                    pillar_algae = .01,
					                    slurper = .15,
					                    cave_banana_tree = .1,
					                    monkeybarrel = .2,
					                    dropperweb = .1,
					                    ruins_rubble_table = 0.1,
					                    ruins_rubble_chair = 0.1,
					                    ruins_rubble_vase = 0.1,
					                }
					            }
					})

AddTask("EXMG_TentacledCave", {
		locks={LOCKS.BASIC_COMBAT, LOCKS.TIER5},
		keys_given={KEYS.TIER6},
		room_choices={
			["TentacleCave"] = 2+math.random(4),
		},
		room_bg=GROUND.MARSH,
		background_room="TentacleCave",--"BGFungusRoom",
		colour={r=0.5,g=0,b=1,a=1},
	})
-- AddTask("RuinsStart", {
		-- locks={LOCKS.BASIC_COMBAT, LOCKS.TIER6},
		-- keys_given= {KEYS.LABYRINTH, KEYS.RUINS},
		-- room_choices={
			-- ["PondWilds"] = math.random(1,3),
			-- ["SlurperWilds"] = math.random(1,3),
			-- ["LushWilds"] = math.random(1,2),
			-- ["LightWilds"] = math.random(1,3),
		-- },
		-- room_bg=GROUND.MUD,
		-- background_room="BGWilds",
		-- colour={r=1,g=0,b=0.6,a=1},
	-- })

AddTask("EXMG_TheLabyrinth", {
		locks={LOCKS.LABYRINTH, LOCKS.TIER6},
		keys_given= {KEYS.SACRED},
		entrance_room="LabyrinthEntrance",
		room_choices={
			--["BGLabyrinth"] = 3+math.random(SIZE_VARIATION), 
			["LabyrinthGuarden"] = 1, 
		},
		room_bg=GROUND.BRICK,
		background_room="LabyrinthEntrance",
		colour={r=0,g=0,b=0,a=0},
	})
	
AddTask("EXMG_Sacred", {
		locks = {LOCKS.SACRED},
		keys_given = {KEYS.SACRED},
		room_choices =
		{
			["Barracks"] = 1,
			["Bishops"] = 1,
			["Spiral"] = 1,
			["BrokenAltar"] = 1,
			["Altar"] = 1,
		},
		room_bg = GROUND.TILES,
		background_room="BGSacredGround",
		colour={r=1,g=0,b=0.6,a=1},
	})

-- AddTask("Military", {
		-- locks = {LOCKS.RUINS, LOCKS.TIER6},
		-- keys_given = KEYS.NONE,
		-- entrance_room = "MilitaryEntrance",
		-- room_choices =
		-- {
			-- ["BGMilitary"] = 4+math.random(SIZE_VARIATION),
		-- },
		-- room_bg = GROUND.TILES,
		-- maze_tiles = {rooms = {"room_armoury", "hallway_armoury", "room_armoury_two"}, bosses = {"room_armoury_two"}},
		-- background_room="BGMilitary",
		-- colour={r=1,g=0,b=0.6,a=1},
	-- })

-- AddTask("Sacred", {
		-- locks = {LOCKS.SACRED},
		-- keys_given = {KEYS.SACRED},
		-- room_choices =
		-- {
			-- ["Barracks"] = math.random(1,2),
			-- ["Bishops"] = math.random(1,2),
			-- ["Spiral"] = math.random(1,2),
			-- ["BrokenAltar"] = math.random(1,2),
			-- ["Altar"] = 1
		-- },
		-- room_bg = GROUND.TILES,
		-- background_room="BGSacredGround",
		-- colour={r=1,g=0,b=0.6,a=1},
	-- })
