local Assets =
{
	Asset("ANIM", "anim/walkie_talkie.zip"),
    Asset("ATLAS", "images/inventoryimages/walkie_talkie.xml"),
	Asset("IMAGE", "images/inventoryimages/walkie_talkie.tex"),		
}

local function fn(Sim)
	local inst = CreateEntity() 
	local minimap = inst.entity:AddMiniMapEntity()
	
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
	
    MakeInventoryPhysics(inst)
	
	
    inst:AddTag("irreplaceable")
	
    minimap:SetIcon("walkie_talkie.tex")
	
    if not TheWorld.ismastersim then
        return inst
    end
	
	
    inst.entity:SetPristine() -- I have no idea what this does.
	
    inst.AnimState:SetBank("moditem")
    inst.AnimState:SetBuild("walkie_talkie")
    inst.AnimState:PlayAnimation("idle")
    
    
    MakeHauntableLaunch(inst)
	
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/walkie_talkie.xml"
	
	inst:AddComponent("characterspecific")
    inst.components.characterspecific:SetOwner("clementine")

	inst:AddComponent("tradable")
    inst.components.tradable.goldvalue = TUNING.GOLD_VALUES.TRINKETS[9]
    
    return inst
end


return Prefab( "common/inventory/walkie_talkie", fn, Assets) 