local assets=
{
	Asset("ANIM", "anim/clem_hat.zip"),
	
	Asset("IMAGE", "images/inventoryimages/clem_hat.tex"),	
    Asset("ATLAS", "images/inventoryimages/clem_hat.xml"),
}

local function onequip(inst, owner) 
        owner.AnimState:OverrideSymbol("swap_hat", "clem_hat", "swap_hat")
        owner.AnimState:Show("HAT")
        owner.AnimState:Show("HAT_HAIR")
        owner.AnimState:Hide("HAIR_NOHAT")
        owner.AnimState:Hide("HAIR")
	inst.components.equippable.dapperness = TUNING.DAPPERNESS_SMALL			
        
        if owner:HasTag("player") then
			owner.AnimState:Hide("HEAD")
			owner.AnimState:Show("HEAD_HAIR")
		end
end

local function onunequip(inst, owner) 
        owner.AnimState:Hide("HAT")
        owner.AnimState:Hide("HAT_HAIR")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")

		if owner:HasTag("player") then
	        owner.AnimState:Show("HEAD")
			owner.AnimState:Hide("HEAD_HAIR")
		end
end


local function fn(Sim)
	local inst = CreateEntity() 
	local minimap = inst.entity:AddMiniMapEntity()
	
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
	
    MakeInventoryPhysics(inst)
	
	
    inst:AddTag("irreplaceable")
	
    minimap:SetIcon("clem_hat.tex")
	
    if not TheWorld.ismastersim then
        return inst
    end
	
	
    inst.entity:SetPristine() -- I have no idea what this does.
	
    inst.AnimState:SetBank("strawhat")
    inst.AnimState:SetBuild("clem_hat")
    inst.AnimState:PlayAnimation("anim")
    
    
    
    MakeHauntableLaunch(inst)
	
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/clem_hat.xml"
	
	inst:AddComponent("characterspecific")
    inst.components.characterspecific:SetOwner("clementine")
    
    inst:AddComponent("equippable")
	inst.components.equippable.equipslot = EQUIPSLOTS.HEAD

    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    
    return inst
end


return Prefab( "common/inventory/clem_hat", fn, assets) 
