
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/nightly.zip" ),
		Asset( "ANIM", "anim/ghost_nightly_build.zip" ),
}
local prefabs = 
{ 
	
}
local function FastFeet(inst)
    inst.components.locomotor.walkspeed = (5)
	inst.components.locomotor.runspeed = (9)
end
local start_inv = 
{
	
}
local function onkill(inst, data)
	-- Increase sanity when destroying a chess structure or structure
	if data.cause == inst.prefab and data.afflicter == inst then
		if data.inst:HasTag("chess") 
		or data.inst:HasTag("structure") 
		or data.inst:HasTag("smashable") 
		then
			inst.components.sanity:DoDelta(10)
			if math.random() < .5 then
				inst.components.talker:Say("Hah! Take that!")
			end
		end
	end
end
local common_postinit = function(inst) 
	
	-- choose which sounds this character will play
	inst.soundsname = "nightly"
		
	-- a minimap icon must be specified
	inst.MiniMapEntity:SetIcon( "nightly.png" )

	
end
local master_postinit = function(inst)
	--doesn't mind the night
	inst.components.sanity.night_drain_mult = 0
	
	--Nightly isn't the best fighter
	inst.components.combat.damagemultiplier = .75
	
	--Nightly has a weak stomach and delicate palate
    inst.components.eater.stale_hunger = 0.25
    inst.components.eater.stale_health = 0.25
    inst.components.eater.spoiled_hunger = 0.125
    inst.components.eater.spoiled_health = 0
	
	-- Stats	
	inst.components.health:SetMaxHealth(200)
	inst.components.hunger:SetMax(150)
	inst.components.sanity:SetMax(75)
	inst.components.locomotor.walkspeed = (5)
	inst.components.locomotor.runspeed = (9)
	
	-- Allow to eat fireflies
	local eater = inst.components.eater
    eater:SetCanEatFireflies()
	function eater:Eat(food)
		if eater:CanEat(food) then
			if eater.inst.components.health then
				local healthvalue = food.components.edible:GetHealth(eater.inst)
				if healthvalue > 0 or not eater.strongstomach then
					eater.inst.components.health:DoDelta(healthvalue, nil, food.prefab)
				end
			end

			if eater.inst.components.hunger then
				eater.inst.components.hunger:DoDelta(food.components.edible:GetHunger(eater.inst))
			end
			
			if eater.inst.components.sanity then
				eater.inst.components.sanity:DoDelta(food.components.edible:GetSanity(eater.inst))
			end
			
			eater.inst:PushEvent("oneat", {food = food})
			if eater.oneatfn then
				eater.oneatfn(eater.inst, food)
			end
			
			if food.components.edible then
				food.components.edible:OnEaten(eater.inst)
			end
			
			if food.components.stackable and food.components.stackable.stacksize > 1 then
				food.components.stackable:Get():Remove()
			else
				food:Remove()
			end
			
			eater.lasteattime = GetTime()
			
			eater.inst:PushEvent("oneatsomething", {food = food})
			
			return true
		end
	end
end


return MakePlayerCharacter("nightly", prefabs, assets, common_postinit, master_postinit, start_inv)