local require = GLOBAL.require
local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local STRINGS = GLOBAL.STRINGS
local ACTIONS = GLOBAL.ACTIONS
local Action = GLOBAL.Action
local TECH = GLOBAL.TECH

STRINGS.NAMES.BLOODSWORD = "Vampiric Blade"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.BLOODSWORD = ("A sword made of nightmares and blood.")
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SERAS = ("A creepy-looking girl.")
STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.SERAS = ("She suffers the Renfield syndrome. Probably.")
STRINGS.CHARACTERS.WAXWELL.DESCRIBE.SERAS = ("She is a little monster pretending to be a girl.")
STRINGS.CHARACTERS.WOODIE.DESCRIBE.SERAS = ("She has hungry animal-like eyes.")
STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.SERAS = ("Little girl almost strong like Wolfgang!")
STRINGS.CHARACTERS.WILLOW.DESCRIBE.SERAS = ("The corpse girl fears fire")
STRINGS.CHARACTERS.WENDY.DESCRIBE.SERAS = ("Hell had no room for her")
STRINGS.CHARACTERS.WX78.DESCRIBE.SERAS = ("IT WANTS TO EAT HUMANS.")


PrefabFiles = {
	"seras",
	"bloodsword",
}

Assets = {
	Asset( "IMAGE", "images/saveslot_portraits/seras.tex" ),
	Asset( "ATLAS", "images/saveslot_portraits/seras.xml" ),

	Asset( "IMAGE", "images/selectscreen_portraits/seras.tex" ),
	Asset( "ATLAS", "images/selectscreen_portraits/seras.xml" ),

	Asset( "IMAGE", "images/selectscreen_portraits/seras_silho.tex" ),
	Asset( "ATLAS", "images/selectscreen_portraits/seras_silho.xml" ),

	Asset( "IMAGE", "bigportraits/seras.tex" ),
	Asset( "ATLAS", "bigportraits/seras.xml" ),

  Asset( "IMAGE", "images/map_icons/seras.tex" ),
  Asset( "ATLAS", "images/map_icons/seras.xml" ),
  
  Asset( "IMAGE", "images/avatars/avatar_seras.tex" ),
  Asset( "ATLAS", "images/avatars/avatar_seras.xml" ),
  
  Asset( "IMAGE", "images/avatars/avatar_ghost_seras.tex" ),
  Asset( "ATLAS", "images/avatars/avatar_ghost_seras.xml" ),
  	
	--bloodsword--
	Asset("ANIM", "anim/bloodsword.zip"),
	Asset("ANIM", "anim/swap_bloodsword.zip"),
	Asset("ATLAS", "images/inventoryimages/bloodsword.xml"),
	
	
	--temporary testing
	Asset("ANIM", "anim/blood_rack_food.zip"),
	Asset("ATLAS", "images/inventoryimages/monsterblood.xml"),

}

AddModCharacter("seras")
AddMinimapAtlas("images/map_icons/seras.xml")
AddMinimapAtlas("images/seras.xml")

GLOBAL.STRINGS.CHARACTER_TITLES.seras = ",The Vampire Fledgling"
GLOBAL.STRINGS.CHARACTER_NAMES.seras = ",Seras Victoria"
GLOBAL.STRINGS.CHARACTER_DESCRIPTIONS.seras = ",*Vampire powers!\n*Severely weakened by starvation and daylight\n*Carnivore"
GLOBAL.STRINGS.CHARACTER_QUOTES.seras = ",\",I don't want to die.\","

GLOBAL.STRINGS.CHARACTERS.SERAS = require "speech_seras"

table.insert(GLOBAL.CHARACTER_GENDERS.FEMALE, "seras")

---- Change the effectiveness of meat food items
--AddComponentPostInit("edible", function(Edible, inst)
--local oldGetHunger = Edible.GetHunger
--function Edible:GetHunger(eater)
--    local multiplier = 1.5
--    if eater:HasTag("hellsingVamp") then     --When feeding pigman gives this error: [string "../mods/Seras/modmain.lua"]:77: attempt to index local 'eater' (a nil value)
--        if self.foodtype == "MEAT" then
--            multiplier = 1.5 --TESTING ONLY
--        else
--            multiplier = 1
--        end
--    end
--    return multiplier * oldGetHunger(self, eater)
--end
--end
--)

local bloodSword = GLOBAL.Recipe("bloodSword",
{
    Ingredient("nightmarefuel", 1),
    Ingredient("pigskin", 1),
},
    RECIPETABS.WAR, TECH.NONE

)
bloodSword.atlas = "images/inventoryimages/bloodsword.xml"

-- function serasPostInit(seras)			--FIX THIS. THIS WILL ADD THE RECCIPE TO EVERYONE IF SERAS IS IN THE GAME
	-- local bloodswordRecipe = GLOBAL.Recipe("bloodsword", {Ingredient("nightmarefuel", 1),Ingredient("pigskin", 1)}, RECIPETABS.WAR, {SCIENCE =0} )
	-- bloodswordRecipe.atlas = "images/inventoryimages/bloodsword.xml"
	
-- end

-- AddSimPostInit(function(inst)
	-- if inst.prefab == "seras" then		--CRASHES HERE PROBABLY A LOCAL=/=SERVER ISSUE
		-- serasPostInit(inst)
	-- end
-- end)
--[[
--Switch jerky out for bags of blood
local function serasJerkyToBlood(inst)
	local GetPlayer = GLOBAL.GetPlayer
	if GetPlayer().prefab == "seras" then
	
		inst.AnimState:SetBank("meat_rack_food")
		inst.AnimState:SetBuild("blood_rack_food")
		inst.AnimState:PlayAnimation("idle_dried_monster")
    
		inst.components.edible.healthvalue = -TUNING.HEALING_SMALL
		inst.components.edible.hungervalue = TUNING.CALORIES_MEDSMALL
		inst.components.edible.sanityvalue = -TUNING.SANITY_TINY

		inst.components.perishable:SetPerishTime(TUNING.PERISH_PRESERVED)
		
		--placeholder inventory
		inst.components.inventoryitem.atlasname = "images/inventoryimages/bloodsword.xml"
	else end
end
AddPrefabPostInit ('monstermeat_dried', serasJerkyToBlood)
--]]

--crookpot tweaks

-- Will this change the food value for everyone? FIX!



--local function serasCrookpotTweak(inst)
--	local GetPlayer = GLOBAL.GetPlayer
--	if GetPlayer().prefab == "seras" then
--	
--		local self = inst.components.edible
--		self.healthvalue = 14
--		self.hungervalue = 20
--		self.sanityvalue = 5
--
--		self.stale_hunger = TUNING.STALE_FOOD_HUNGER
--		self.stale_health = TUNING.STALE_FOOD_HEALTH
--		self.spoiled_hunger = TUNING.SPOILED_FOOD_HUNGER
--		self.spoiled_health = TUNING.SPOILED_FOOD_HEALTH
--	else end
--end
--AddPrefabPostInit ('frogglebunwich', serasCrookpotTweak)




