local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wendy.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),
		
		Asset( "ANIM", "anim/flash.zip" ),
		Asset( "ANIM", "anim/ghost_flash_build.zip" ),
}
local prefabs = { }

local function onbecamehuman(inst)

	inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.6)
	inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.6)
	
	inst.components.combat.damagemultiplier = 0.75
    inst.components.combat:SetAttackPeriod(0.1)
	
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE*1.5)	
	
    local statename = inst.sg.currentstate.name
    inst:SetStateGraph("SGflash")
    inst.sg:GoToState(statename)

	
end

local function common_postinit(inst)
	
	inst.MiniMapEntity:SetIcon( "flash.png" )
	
end

local function master_postinit(inst)

	
	inst.soundsname = "nosound"
	
		inst.talksoundoverride = "dontstarve/common/lightningrod"
		inst.hurtsoundoverride = "dontstarve/common/lightningrod"
		inst.deathsoundoverride = "dontstarve/common/lightningrod"
		

	inst.components.health:SetMaxHealth(100)
	inst.components.health.canheal = true
		
	inst.components.sanity.max = 200
	inst.components.sanity.ignore = false
	inst.components.sanity.night_drain_mult = 1
	inst.components.sanity.neg_aura_mult = 1
	
	inst.components.hunger.max = 150
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE*1.5)	
	
	inst.components.eater.strongstomach = false
	inst.components.eater.ignoresspoilage = false
	
	inst.components.combat.damagemultiplier = 0.75
    inst.components.combat:SetAttackPeriod(0.1)
	
	inst.components.temperature.hurtrate = 1
	
	inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.6)
	inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.6)
	
	inst:SetStateGraph("SGflash")
	
	inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
	
	onbecamehuman(inst)
	
end

STRINGS.CHARACTERS.FLASH = require "speech_flash"
return MakePlayerCharacter("flash", prefabs, assets, common_postinit, master_postinit)
