local assets=
{
	Asset("ANIM", "anim/tungsten_pickaxe.zip"),
	Asset("ANIM", "anim/swap_tungsten_pickaxe.zip"),
    Asset("ATLAS", "images/inventoryimages/tungsten_pickaxe.xml"),
}

local function onfinished(inst)
    inst:Remove()
end

local function sanityupfn(chop,owner)
	if owner and owner.components and owner.components.sanity then
		owner.components.sanity:DoDelta(3)
		print("Sanity Regain by Infiniminer")
	end
	print("sanityupfn ausgeführt")
end


local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_tungsten_pickaxe", "swap_pickaxe")
	owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
	inst:ListenForEvent("percentusedchange", sanityupfn,owner)
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
	inst:RemoveEventCallback("percentusedchange",sanityupfn,owner)
end

local function onattack(weapon, attacker, target)
    if target ~= nil then
        weapon.components.finiteuses:Use(-1.5)
    end
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("axe")
    anim:SetBuild("tungsten_pickaxe")
    anim:PlayAnimation("idle")
    
	inst.entity:AddNetwork()
	    if not TheWorld.ismastersim then
        return inst
    end
    MakeHauntableLaunchAndSmash(inst)	
    inst:AddTag("sharp")

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.TUNGSTEN_PICKAXE_DAMAGE)
    inst.components.weapon:SetAttackCallback(onattack)
    -------
    
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(TUNING.TUNGSTEN_PICKAXE_USES)
    inst.components.finiteuses:SetUses(TUNING.TUNGSTEN_PICKAXE_USES)
    
    inst.components.finiteuses:SetOnFinished( onfinished )

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/tungsten_pickaxe.xml"
	
	inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.MINE,4)
	inst.components.finiteuses:SetConsumption(ACTIONS.MINE, 1)

    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    
    return inst
end

return Prefab( "common/inventory/tungsten_pickaxe", fn, assets) 
