local assets=
{
	Asset("ANIM", "anim/tungsten_spear.zip"),
	Asset("ANIM", "anim/swap_tungsten_spear.zip"),
    Asset("ATLAS", "images/inventoryimages/tungsten.xml"),
}

local function onfinished(inst)
    inst:Remove()
end

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_tungsten_spear", "swap_spear")
	owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end


local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("spear")
    anim:SetBuild("tungsten_spear")
    anim:PlayAnimation("idle")
    
	inst.entity:AddNetwork()
	    if not TheWorld.ismastersim then
        return inst
    end
    MakeHauntableLaunchAndSmash(inst)	
    inst:AddTag("sharp")

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.TUNGSTEN_SPEAR_DAMAGE)
    
    -------
    
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(TUNING.TUNGSTEN_SPEAR_USES)
    inst.components.finiteuses:SetUses(TUNING.TUNGSTEN_SPEAR_USES)
    
    inst.components.finiteuses:SetOnFinished( onfinished )

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/tungsten.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    
    return inst
end

return Prefab( "common/inventory/tungsten", fn, assets) 
