
local MakePlayerCharacter = require "prefabs/player_common"

local assets = 
{
    Asset("ANIM", "anim/webber.zip"),
	Asset("SOUND", "sound/webber.fsb"),
	Asset("ANIM", "anim/beard_silk.zip"),
	Asset("ANIM", "anim/ghost_webber_build.zip"),
}

local prefabs = 
{
	"silk"
}

local start_inv = 
{
	"spidereggsack",
	"monstermeat",
	"monstermeat",
}
local function common_postinit(inst)
	inst.soundsname = "webber"
	inst.talker_path_override = "dontstarve_DLC001/characters/"
	inst.talker_ghost_override = "/talk_LP"
	
	local OldEnableMovementPrediction = inst.EnableMovementPrediction
	inst.EnableMovementPrediction = function(inst, enable)
		OldEnableMovementPrediction(inst, enable)
		DontTriggerCreep(inst)
	end

	-- local nest_recipe = Recipe("spidereggsack", {Ingredient("silk", 12), Ingredient("spidergland", 6), Ingredient("papyrus", 6)}, RECIPETABS.TOWN, TECH.NONE)
	-- nest_recipe.sortkey = -nest_recipe.sortkey
	-- STRINGS.RECIPE_DESC.SPIDEREGGSACK = "Get a little help from your friends."
	inst.ghostbuild = "ghost_webber_build"
end

local function DontTriggerCreep(inst)
	inst.components.locomotor.triggerscreep = false
	inst.components.locomotor:SetSlowMultiplier(1)
end

local function master_postinit(inst)
	inst:AddTag("spiderwhisperer")
	inst:AddTag("monster")
	inst:AddTag("spidereggsack_builder")
	
	inst:ListenForEvent("ms_respawnedfromghost", DontTriggerCreep)
	DontTriggerCreep(inst)
	
	inst.components.eater.monsterimmune = true

	inst.components.health:SetMaxHealth(175)--TUNING.WEBBER_HEALTH)
	inst.components.hunger:SetMax(175)--TUNING.WEBBER_HUNGER)
	inst.components.sanity:SetMax(100)--TUNING.WEBBER_SANITY)

    inst:AddComponent("beard")
    inst.components.beard.insulation_factor = 0.75--TUNING.WEBBER_BEARD_INSULATION_FACTOR
    inst.components.beard.onreset = function()
        inst.AnimState:ClearOverrideSymbol("beard")
    end
    inst.components.beard.prize = "silk"
    
	local beard_days = {3, 6, 9}
	local beard_bits = {1, 3, 6}
    
    inst.components.beard:AddCallback(beard_days[1], function()
        inst.AnimState:OverrideSymbol("beard", "beard_silk", "beardsilk_short")
        inst.components.beard.bits = beard_bits[1]
    end)
    
    inst.components.beard:AddCallback(beard_days[2], function()
        inst.AnimState:OverrideSymbol("beard", "beard_silk", "beardsilk_medium")
        inst.components.beard.bits = beard_bits[2]
    end)
    
    inst.components.beard:AddCallback(beard_days[3], function()
        inst.AnimState:OverrideSymbol("beard", "beard_silk", "beardsilk_long")
        inst.components.beard.bits = beard_bits[3]
    end)
end

return MakePlayerCharacter("webber", prefabs, assets, common_postinit, master_postinit, start_inv) 
-- return MakePlayerCharacter("webber", nil, nil, nil, nil, nil) 
