   postprocessbloom      SAMPLER    +         POST_PARAMS                            postprocess.vs}  #define ENABLE_BLOOM
attribute vec3 POSITION;
attribute vec2 TEXCOORD0;

varying vec2 PS_TEXCOORD0;
varying vec2 PS_TEXCOORD1;

uniform vec3 POST_PARAMS;
#if defined( ENABLE_DISTORTION )
	#define TIME POST_PARAMS.x
#endif 

void main()
{
	gl_Position = vec4( POSITION.xyz, 1.0 );
	PS_TEXCOORD0.xy = TEXCOORD0.xy;
	 
#if defined( ENABLE_DISTORTION )
	float range = 0.00625;
	float time_scale = 50.0;
	vec2 offset_vec = vec2( cos( TIME * time_scale + 0.25 ), sin( TIME * time_scale ) );
	vec2 small_uv = TEXCOORD0.xy * ( 1.0 - 2.0 * range ) + range;
	PS_TEXCOORD1.xy = small_uv + offset_vec * range;
#endif

}

    postprocess.psu  #define ENABLE_BLOOM
#if defined( GL_ES )
precision highp float;
#endif

#if defined( ENABLE_BLOOM )
// Angle is REALLY anal about this. You can't enable a sampler
// that you aren't going to use or it very quietly asserts in the
// dll with a spectacularly less than informative assert.
uniform sampler2D SAMPLER[3];
#else
uniform sampler2D SAMPLER[2];
#endif

uniform vec3 POST_PARAMS;

#define TIME                POST_PARAMS.x
#define INTENSITY_MODIFIER  POST_PARAMS.y

#define SRC_IMAGE        SAMPLER[0]
#define COLOUR_CUBE      SAMPLER[1]
#define BLOOM_BUFFER     SAMPLER[2]

varying vec2 PS_TEXCOORD0;
#if defined( ENABLE_DISTORTION )
varying vec2 PS_TEXCOORD1;
#endif

#define CUBE_DIMENSION 32.0
#define CUBE_WIDTH  ( CUBE_DIMENSION * CUBE_DIMENSION )
#define CUBE_HEIGHT ( CUBE_DIMENSION )

#define TEXEL_WIDTH   ( 1.0 / CUBE_WIDTH )
#define TEXEL_HEIGHT  ( 1.0 / CUBE_HEIGHT)
#define HALF_TEXEL_WIDTH  ( TEXEL_WIDTH  * 0.5 )
#define HALF_TEXEL_HEIGHT ( TEXEL_HEIGHT * 0.5 )

#if defined( ENABLE_DISTORTION )
	uniform vec3 DISTORTION_PARAMS;

	#define DISTORTION_FACTOR			DISTORTION_PARAMS.x
	#define DISTORTION_INNER_RADIUS		DISTORTION_PARAMS.y
	#define DISTORTION_OUTER_RADIUS		DISTORTION_PARAMS.z
#endif

vec2 GetCCUV( vec3 colour )
{
    vec3 intermediate = colour.rgb * vec3( CUBE_DIMENSION - 1.0, CUBE_DIMENSION, CUBE_DIMENSION - 1.0 / CUBE_WIDTH ); // rgb all 0:31 - cube space
	vec2 uv = vec2( ( min( intermediate.r + 0.5, 31.0 ) + floor( intermediate.b ) * CUBE_DIMENSION ) / CUBE_WIDTH,
                          1.0 - ( min( intermediate.g, 31.0 ) / CUBE_HEIGHT ) );

	return uv;
}

vec3 texture2DBilinear( sampler2D textureSampler, vec2 uv )
{
    // in vertex shaders you should use texture2DLod instead of texture2D
    vec3 tl = texture2D(textureSampler, uv).rgb;
    vec3 tr = texture2D(textureSampler, uv + vec2(TEXEL_WIDTH,	0			)).rgb;
    vec3 bl = texture2D(textureSampler, uv + vec2(0,			TEXEL_HEIGHT)).rgb;
    vec3 br = texture2D(textureSampler, uv + vec2(TEXEL_WIDTH , TEXEL_HEIGHT)).rgb;
    vec2 f = fract( uv.xy * vec2(CUBE_WIDTH,CUBE_HEIGHT) ); // get the decimal part
    vec3 tA = mix( tl, tr, f.x ); // will interpolate the red dot in the image
    vec3 tB = mix( bl, br, f.x ); // will interpolate the blue dot in the image
    return mix( tA, tB, f.y ); // will interpolate the green dot in the image
}

void main()
{
	vec3 base_colour = texture2D( SRC_IMAGE, PS_TEXCOORD0.xy ).rgb; // rgb all 0:1 - colour space

#if defined( ENABLE_BLOOM )
	vec3 bloom = texture2D( BLOOM_BUFFER, PS_TEXCOORD0.xy ).rgb;
	base_colour.rgb += bloom.rgb;
#endif

#if defined( ENABLE_DISTORTION )

	// Offset comes from vert shader
	vec2 offset_uv = PS_TEXCOORD1.xy;
	
	// rotation amount
	vec3 distorted_colour = texture2D( SRC_IMAGE, offset_uv ).xyz;

	#if defined( ENABLE_BLOOM ) 
		distorted_colour.rgb += texture2D( BLOOM_BUFFER, offset_uv ).rgb;
	#endif

	float distortion_mask = clamp( ( 1.0 - distance( PS_TEXCOORD0.xy, vec2( 0.5, 0.5 ) ) - DISTORTION_INNER_RADIUS ) / ( DISTORTION_OUTER_RADIUS - DISTORTION_INNER_RADIUS ), 0.0, 1.0 );
	distorted_colour.rgb = mix( distorted_colour, base_colour, DISTORTION_FACTOR );
	base_colour.rgb = mix( distorted_colour, base_colour, distortion_mask );
#endif
 
    // 0:1 - uv space
    vec2 base_cc_uv = GetCCUV( base_colour );
	
    //Manually apply bilinear filtering to the colour cube, to prevent anistropic "red outline" filtering bug
    vec3 cc = texture2DBilinear( COLOUR_CUBE, base_cc_uv.xy - vec2(HALF_TEXEL_WIDTH, HALF_TEXEL_HEIGHT)).rgb;
    
    cc *= INTENSITY_MODIFIER;

    gl_FragColor = vec4( cc, 1.0 );
}

               