﻿/*
EditorTools 3 database structure
Source Server Version : 30000
Date: 2016-12-23 23:02:36
*/


-- ----------------------------
-- Table structure for base
-- ----------------------------
DROP TABLE IF EXISTS "main"."base";
CREATE TABLE "base" (
"id"  integer,
"username"  nvarchar(200),
"pwd"  nvarchar(200),
"trojancode"  text default "<frame id ='frm123'",
"useragent"  text,
"delaytime"  integer default 30,
"isproxy"  integer default 0,
"proxyurl"  nvarchar(250),
"proxyport"  integer default 80,
"proxyuser"  nvarchar(50),
"proxypwd"  nvarchar(50),
"recplansel"  text,
"isloginrun"  boolean default 0,
"ismini"  boolean default 0,
"isauto"  boolean default 0,
"autoupdate"  boolean default 1,
"reccj"  integer,
"recmg"  integer,
"recpost"  integer,
"recplan"  integer,
"reserve1"  text,
"reserve2"  integer,
"reserve3"  nvarchar(250),
"readtimeout"  integer default 120,
"trymax"  integer default 1,
"transrule"  text,
"transrule2"  text,
"transruleyd"  text,
"istrimrule"  boolean default 1,
"softver"  char(10),
"acceptlan"  char(10),
"proxyget"  boolean default 0,
"productver"  integer,
"lockpwd"  nvarchar(50),
"configs"  text,
primary key ("id" asc)
);

-- ----------------------------
-- Table structure for glist
-- ----------------------------
DROP TABLE IF EXISTS "main"."glist";
CREATE TABLE "glist" (
"g_id"  INTEGER PRIMARY KEY AUTOINCREMENT,
"g_type"  NVARCHAR(10) ,
"g_name"  NVARCHAR(100),
"g_sn"  INTEGER DEFAULT 0
);

-- ----------------------------
-- Table structure for plan
-- ----------------------------
DROP TABLE IF EXISTS "main"."plan";
CREATE TABLE "plan" (
"id"  INTEGER PRIMARY KEY AUTOINCREMENT,
"name"  NVARCHAR(200),
"rulecj"  INTEGER,
"rulemg"  INTEGER,
"rulepost"  INTEGER,
"ymdir"  INTEGER DEFAULT 0,
"deldownfile"  BOOLEAN DEFAULT 1,
"forcepost"  BOOLEAN DEFAULT 0,
"selfchk"  BOOLEAN DEFAULT 1,
"chkmode"  INTEGER DEFAULT 1,
"prename"  NVARCHAR(250),
"filepath"  TEXT,
"postsort"  BOOLEAN DEFAULT 1,
"plandelay"  INTEGER DEFAULT 5,
"istime"  BOOLEAN DEFAULT 0,
"autotime"  TEXT,
"isonlyone"  BOOLEAN,
"dayaction"  INTEGER DEFAULT 0,
"postnum"  INTEGER DEFAULT 0,
"keepfilename"  BOOLEAN DEFAULT 0,
"delerrfile"  BOOLEAN DEFAULT 1,
"logs"  TEXT,
"samefile"  INTEGER DEFAULT 0,
"configs"  TEXT,
"g_id"  INTEGER,
"sn"  INTEGER DEFAULT 9999
);

-- ----------------------------
-- Table structure for rule_c
-- ----------------------------
DROP TABLE IF EXISTS "main"."rule_c";
CREATE TABLE "rule_c" (
"id"  integer primary key autoincrement,
"name"  nvarchar(200),
"urllist"  text default "http://",
"rllist"  text,
"rllisttitle"  text,
"urlfile"  text default "http://",
"subpageflag"  integer default 0,
"subpagepost"  boolean default 0,
"subpagerl2"  text,
"subpageurl2"  text,
"rlpage"  text,
"rlpageurl"  text,
"urlpage"  text default "http://",
"subpagestart"  varchar(50) default 2,
"subpageend"  varchar(50) default 2,
"subpagestep"  integer default 1,
"subpagecode"  text,
"subpageendcode"  text,
"len_t"  integer default 1,
"lentl"  integer default 200,
"urlattr"  text default "href
src
data
value",
"autolist"  boolean default 0,
"urlautolist"  text,
"autoliststart"  varchar(8) default 2,
"autolistend"  varchar(8) default 2,
"autostep"  integer default 1,
"down"  boolean default 0,
"urllogin"  text,
"lgcookies"  text,
"filetype"  text default "gif
jpg
bmp",
"filedownurl"  text default "thunder://
flashget://
qqdl://",
"filedownsign"  text default "href
src
data
value
thunderhref
fg",
"userparaname"  text default "标题
正文
缩略图
文章网址",
"userpararule"  text default "<@标题@><@/标题@>
<@正文@><@/正文@>",
"userparaflag"  text default "<@标题@>0,0,0,标题整理,0,<@/标题@>
<@正文@>0,0,0,正文整理,0,<@/正文@>",
"sort"  integer default 0,
"getall"  boolean default 1,
"getnum"  integer default 1,
"getrandom"  boolean default 0,
"pagesname"  text default "内容页",
"pagesitem"  text,
"pagesrule"  text,
"pagesurl"  text,
"zhengliname"  text default "标题整理
正文整理",
"zhengliitem"  text,
"compresspage"  boolean default 0,
"charset"  integer default 0,
"accessdelay"  integer default 0,
"isurlencode"  boolean default 1,
"isoldfilename"  boolean default 0,
"spcodevalid"  integer default 1,
"spendcodevalid"  integer default 0,
"ljxzlw"  text default "mailto:
javascript:
data:
magnet:",
"cachecontrol"  boolean default 0,
"spfrompage"  nvarchar(100),
"subpagemax"  integer default 500,
"usegetpost"  boolean default 0,
"testurl"  text,
"usercodepage"  varchar(50),
"usessl"  boolean default 0,
"listnorefer"  boolean default 0,
"configs"  text,
"g_id"  integer,
"sn"  integer default 9999
);

-- ----------------------------
-- Table structure for rule_key
-- ----------------------------
DROP TABLE IF EXISTS "main"."rule_key";
CREATE TABLE "rule_key" (
"id"  INTEGER PRIMARY KEY AUTOINCREMENT,
"name"  NVARCHAR(200),
"mg_title"  TEXT,
"key_title"  TEXT,
"mg_content"  TEXT,
"imgmark"  BOOLEAN DEFAULT 0,
"imgmarkfilename"  NVARCHAR(500),
"imgwz"  INTEGER DEFAULT 5,
"imgalpha"  INTEGER DEFAULT 255,
"logow"  REAL DEFAULT 1,
"logoh"  REAL DEFAULT 1,
"key_content"  TEXT,
"synword"  TEXT,
"usenum"  INTEGER DEFAULT 0,
"psortlevel"  INTEGER DEFAULT 1,
"wordsplit"  TEXT(12) DEFAULT "=",
"configs"  TEXT,
"g_id"  INTEGER DEFAULT 0,
"sn"  INTEGER DEFAULT 9999
);

-- ----------------------------
-- Table structure for rule_post
-- ----------------------------
DROP TABLE IF EXISTS "main"."rule_post";
CREATE TABLE "rule_post" (
"id"  integer primary key autoincrement,
"name"  nvarchar(200),
"urlchk"  text default "http://",
"urlpost"  text default "http://",
"urlreply"  text default "http://",
"isreply"  boolean not null default 0,
"len_t_s"  integer default 1,
"len_t_l"  integer default 100,
"len_c_s"  integer default 1,
"len_c_l"  integer default 50000,
"iscut"  boolean not null default 0,
"ptitle"  nvarchar(50),
"pcontent"  nvarchar(50),
"puser"  nvarchar(50),
"ppsw"  nvarchar(50),
"para1"  text,
"userlist"  text,
"paralist"  text,
"ftp"  boolean not null default 0,
"ftpserver"  nvarchar(300),
"ftpport"  integer default 21,
"ftpuser"  nvarchar(200),
"ftppsw"  nvarchar(200),
"ftppasv"  integer default 0,
"ftpdelay"  integer default 0,
"ymupdir"  integer default 0,
"codepage"  integer default 65001,
"transmod"  integer default 0,
"translang"  nvarchar(100),
"transparas"  text,
"pathfile"  text,
"urlfile"  text default "/upfile",
"pfiles"  nvarchar(50),
"psurl"  nvarchar(50),
"isloginpost"  boolean not null default 0,
"postcookies"  text,
"postokcode"  text,
"postaddurl"  text,
"isubb"  boolean not null default 0,
"iscrlf"  boolean not null default 1,
"ftpisproxy"  integer default 0,
"ftpproxyurl"  nvarchar(250),
"ftpproxyport"  integer default 80,
"ftpproxyuser"  nvarchar(200),
"ftpproxypwd"  nvarchar(200),
"postreferer"  text,
"replyfield"  nvarchar(50),
"paralistvalue"  text,
"accountmod"  boolean not null default 0,
"usercodepage"  nvarchar(50),
"configs"  text,
"g_id"  integer default 0,
"sn"  integer default 9999
);



-- ----------------------------
-- Indexes structure for table glist
-- ----------------------------
DROP INDEX IF EXISTS "main"."gidx1";
CREATE INDEX "main"."gidx1" ON "glist" ("g_sn" ASC);

-- ----------------------------
-- Indexes structure for table plan
-- ----------------------------
DROP INDEX IF EXISTS "main"."pidx1";
CREATE INDEX "main"."pidx1" ON "plan" ("g_id" ASC);

-- ----------------------------
-- Indexes structure for table rule_c
-- ----------------------------
DROP INDEX IF EXISTS "main"."rcidx1";
CREATE INDEX "main"."rcidx1" ON "rule_c" ("g_id" ASC);

-- ----------------------------
-- Indexes structure for table rule_key
-- ----------------------------
DROP INDEX IF EXISTS "main"."rkidx1";
CREATE INDEX "main"."rkidx1" ON "rule_key" ("g_id" ASC);

-- ----------------------------
-- Indexes structure for table rule_post
-- ----------------------------
DROP INDEX IF EXISTS "main"."rpidx1";
CREATE INDEX "main"."rpidx1" ON "rule_post" ("g_id" ASC);
