CONTAINER TurbulenceTexture
{
    NAME TurbulenceTexture;
    INCLUDE Mbase;

    GROUP TURB_SHADER_GRP
    {
        DEFAULT 1;
        //----------------------------------------------------------------
        GROUP TURB_POWER_GRP
        {
            COLUMNS 2;
            REAL    TURBULENCE_POWER_FLOAT     { SCALE_H; MIN 0; STEP 0.01;  MAX 1000.0; MINSLIDER 0; MAXSLIDER 1; CUSTOMGUI OCTNSLIDER; }
            BUTTON  TURBULENCE_POWER_BTN     {}
        }
        SHADERLINK  TURBULENCE_POWER_LNK     { SCALE_H; OPEN; OUTPORT; }

        //----------------------------------------------------------------
        GROUP TURB_OFFSET_GRP
        {
            COLUMNS 2;
            REAL    TURBULENCE_OFFSET_FLOAT    { SCALE_H; MIN 0; STEP 0.01; MAX 1000.0; MINSLIDER 0; MAXSLIDER 1; CUSTOMGUI OCTNSLIDER; }
            BUTTON  TURBULENCE_OFFSET_BTN    {}
        }
        SHADERLINK  TURBULENCE_OFFSET_LNK    { SCALE_H; OPEN; OUTPORT; }

        //----------------------------------------------------------------
        REAL TURBULENCE_OCTAVE1 {  MIN 1; STEP 1; MAX 16;  CUSTOMGUI OCTNSLIDER; }

        //----------------------------------------------------------------
        GROUP TURB_OMEGA_GRP
        {
            COLUMNS 2;
            REAL    TURBULENCE_OMEGA_FLOAT    { SCALE_H; MIN 0; STEP 0.01; MAX 1; CUSTOMGUI OCTNSLIDER; }
            BUTTON  TURBULENCE_OMEGA_BTN    {}
        }
        SHADERLINK  TURBULENCE_OMEGA_LNK     { SCALE_H; OPEN; OUTPORT; }

        BOOL 	TURBULENCE_USETURB  {}
        BOOL 	TURBULENCE_INVERT   {}
        REAL    TURBULENCE_GAMMA    { SCALE_H; MIN 0.01; STEP 0.01; MAX 100.0; MINSLIDER 0.01; MAXSLIDER 10;  CUSTOMGUI OCTNSLIDER; }

        BUTTON  TURBULENCE_TRANSFORM_BTN {}
        LINK    TURBULENCE_TRANSFORM_LINK { ACCEPT { Transform; }  OPEN; }

        BUTTON  TURBULENCE_PROJECTION_BTN {}
        LINK    TURBULENCE_PROJECTION_LINK { ACCEPT { TextureProjection; }  OPEN; }

    }
}
