CONTAINER octanecameraexp
{
	NAME octanecameraexp;
        INCLUDE Obaselist;

        GROUP
        {
            LONG OCT_CAMERA_TYPE_SELECT
            {
                CYCLE
                {
                    OCT_CAMERA_THINLENS;
                    OCT_CAMERA_PANO;
                    OCT_CAMERA_BAKE;
                    OCT_CAMERA_OSL;
                }
            }
        }

        GROUP OCTANECAMERA_MOBLUR_GROUP
        {
            BOOL    OCT_CAMERA_MOBLUR { }
            REAL    OCT_CAMERA_SHUTTER { CUSTOMGUI OCTNSLIDER; MIN 0.0001; MAX 100; MAXSLIDER 1; STEP 0.01; }
            REAL    OCT_CAMERA_TIME_SHIFT { CUSTOMGUI OCTNSLIDER; MIN -1; MAX 1; STEP 0.1; }
            LONG    OCT_CAMERA_MBLUR_CACHEAMOUNT { MIN 0; ANIM OFF; }

            LONG OCT_CAMERA_SHUTTER_ALIGN
            {
                CYCLE
                {
                    OCT_CAMERA_SHUTTER_ALIGN_BEFORE;
                    OCT_CAMERA_SHUTTER_ALIGN_CENTER;
                    OCT_CAMERA_SHUTTER_ALIGN_AFTER;
                }
            }
            BOOL    OCT_CAMERA_DISABLE_CAM_MOBLUR { }
        }

        GROUP OCTANECAMERA_PANORAMIC_GROUP
        {
            LONG OCT_CAMERA_PANORAMIC_MODE_SELECT
            {
                CYCLE
                {
                    OCT_CAMERA_PANO_MODE_SPHERE;
                    OCT_CAMERA_PANO_MODE_CYLINDER;
                    OCT_CAMERA_PANO_MODE_CUBE;
                }
            }
            REAL    OCT_CAMERA_PANORAMIC_FOVX { MIN 1; MAX 360; STEP 0.1; }
            REAL    OCT_CAMERA_PANORAMIC_FOVY { MIN 1; MAX 180; STEP 0.1; }
            BOOL    OCT_CAMERA_PANORAMIC_UPRIGHT {}
        }

        GROUP OCTANECAMERA_THINLENS_GROUP
        {
            OPEN;   DEFAULT 1;
            BOOL    OCTANECAMERA_AUTOFOCUS      {}
            REAL    OCTANECAMERA_FOCALDEPTH     { CUSTOMGUI OCTNSLIDER; UNIT METER;  STEP 0.1; MIN 0.0; MAXSLIDER 100.0; }
            REAL    OCTANECAMERA_APERTURE       { CUSTOMGUI OCTNSLIDER; UNIT METER; STEP 0.001; MIN 0.00; MAXSLIDER 4; }
            REAL    OCTANECAMERA_FSTOP          { CUSTOMGUI OCTNSLIDER; LOGARITMIC 1; UNIT REAL;  STEP 0.01; MIN 0.5; MAX 1000.0; MAXSLIDER 64; }

            REAL    OCTANECAMERA_APERTURE_ASPECTRATIO   { CUSTOMGUI OCTNSLIDER; UNIT REAL;  STEP 0.001; MIN 0.1; MAX 10.0; MAXSLIDER 4; }
            REAL    OCT_CAMERA_APERTUREEDGE     { CUSTOMGUI OCTNSLIDER; MIN 1.0; MAX 3.0; STEP 0.01; }

            REAL    OCT_CAMERA_BOKEH_SIDE_CNT   { CUSTOMGUI OCTNSLIDER; MIN 3.0; MAX 100.0; STEP 1; }
            REAL    OCT_CAMERA_BOKEH_ROT        { CUSTOMGUI OCTNSLIDER; MIN 0.0; MAX 1.0; STEP 0.01; }
            REAL    OCT_CAMERA_BOKEH_ROUNDNESS  { CUSTOMGUI OCTNSLIDER; MIN 0.0; MAX 1.0; STEP 0.01; }

            SEPARATOR { LINE; }
            REAL    OCTANECAMERA_PIXEL_ASPECTRATIO      { CUSTOMGUI OCTNSLIDER; UNIT REAL;  STEP 0.001; MIN 0.1; MAX 10.0; MAXSLIDER 4; }
            BOOL    OCT_CAMERA_PERSP_CORRECTION	{}

            REAL    OCTANECAMERA_NEARCLIPDEPTH  { UNIT METER; }
            REAL    OCTANECAMERA_FARCLIPDEPTH   { UNIT METER; }
            REAL    OCT_CAMERA_DISTORTION       { CUSTOMGUI OCTNSLIDER; MIN 0.0; MAX 1; STEP 0.01; }
            BOOL    OCT_CAMERA_ORTHOGRAPHIC     { }

            VECTOR	OCTANECAMERA_LENSSHIFT      {  STEP 0.01; }
        }

        GROUP OCTCAMERA_OSL_MAIN_GRP
        {
            OPEN; DEFAULT 1; SCALE_V; SCALE_H;

            GROUP OCTANECAM_OSL_SCRIPTS_GRP
            {
                COLUMNS 2;
            }

            GROUP OCTANECAMERA_OSL_EDITOR_GRP
            {
                OPEN;
                SCALE_V; SCALE_H;

                GROUP OCTANECAMERA_OSL_BUTTON_GRP
                {
                    COLUMNS 4;
                    BUTTON OCTCAMERA_OSL_OPEN_CODE_DLG {}
                    BUTTON OCTANECAM_OSL_COMPILE_BTN {}
                    BUTTON OCTANECAM_OSL_RESET_BTN {}
                    BOOL OCTANECAM_OSL_AUTO_COMPILE {}
                }
                STRING OCTANECAM_OSL_CODE_EDITOR { ANIM OFF; CUSTOMGUI MULTISTRING; SCALE_H; SCALE_V; WORDWRAP; PYTHON;}
                STRING OCTANECAM_OSL_LOG_OUTPUT  { ANIM OFF; CUSTOMGUI MULTISTRING; SCALE_H; WORDWRAP; }
            }

            GROUP OCTANECAM_OSL_PARAMS_GRP
            {
                OPEN; DEFAULT 1;
                //REAL   OCTANECAM_OSL_FLOAT1 {  }
            }
        }

        GROUP OCTANECAMERA_BAKING_GROUP
        {
            DEFAULT 1;
            LONG    OCT_BAKECAMERA_GROUP_ID     {  MIN 1; MAX 32768; }
            LONG    OCT_BAKECAMERA_UVSET        { MIN 1; MAX 3; }
            BOOL    OCT_BAKECAMERA_REVERT       {}

            GROUP OCTANECAMERA_PADDING_GROUP
            {
                LONG    OCT_BAKECAMERA_PADDING_SIZE     { MIN 0; MAX 16; }
                REAL    OCT_BAKECAMERA_EDGE_NOISE_TOL   { MIN 0; MAX 1; STEP 0.01; }
            }

            GROUP OCTANECAMERA_UVREGION_GRP
            {
                VECTOR  OCT_BAKECAMERA_UVMIN        { STEP 0.01; }
                VECTOR  OCT_BAKECAMERA_UVSIZE       { STEP 0.01; }
            }

            GROUP OCTANECAMERA_BAKINGPOS_GROUP
            {
                BOOL    OCT_BAKECAMERA_USE_BAKE_POS     {}
                VECTOR  OCT_BAKECAMERA_POSITION         { UNIT METER; }
                BOOL    OCT_BAKECAMERA_BACK_CULLING     {}
            }
        }

        GROUP OCTANECAMERA_IMAGERGRP
        {
            BOOL    OCTANECAMERA_ENABLE_IMAGER  { }

            SEPARATOR { LINE; }

            GROUP OCTANECAM_IMAGER_GRP1
            {

                GROUP OCTANECAM_DENOISER_GROUP
                {
                    BOOL    OCT_CAMIMAGER_EN_DENOISER       {}
                    BOOL    OCT_CAMIMAGER_DENOISE_VOLUMES   {}
                    BOOL    OCT_CAMIMAGER_DENOISE_ON_COMP   {}
                    LONG    OCT_CAMIMAGER_DENOISE_MINSAMPLES    { MIN 1; MAX 120; }
                    LONG    OCT_CAMIMAGER_DENOISE_INTERVAL      { MIN 1; MAX 500; }
                    REAL    OCT_CAMIMAGER_DENOISE_BLEND         { CUSTOMGUI OCTNSLIDER; UNIT REAL;  STEP 0.01; MIN 0.0; MAX 1.0; }
                }

                REAL    OCTANECAMERA_EXPOSURE       { CUSTOMGUI OCTNSLIDER; LOGARITMIC 1; MIN 0.001; STEP 0.01; MAX 4096; MAXSLIDER 32;}
                REAL    OCTANECAMERA_HCOMPRESSION   { CUSTOMGUI OCTNSLIDER;  UNIT REAL;  STEP 0.01; MIN 0; MAX 1.0; }

                LONG OCT_CAMERA_IMAGER_ORDER
                {
                    CYCLE
                    {
                        TM_ORDER_RESPONSE_GAMMA_LUT;
                        TM_ORDER_GAMMA_RESPONSE_LUT;
                        TM_ORDER_LUT_RESPONSE_GAMMA;
                        TM_ORDER_LUT_GAMMA_RESPONSE;
                        TM_ORDER_RESPONSE_LUT_GAMMA;
                        TM_ORDER_GAMMA_LUT_RESPONSE;
                    }
                }

                LONG OCTANECAMERA_RESPONSE
                {
                    CYCLE
                    {
                    _Agfacolor_Futura_100CD;
                    _Agfacolor_Futura_200CD;
                    _Agfacolor_Futura_400CD;
                    _Agfacolor_Futura_II_100CD;
                    _Agfacolor_Futura_II_200CD;
                    _Agfacolor_Futura_II_400CD;
                    _Agfacolor_HDC_100_plusCD;
                    _Agfacolor_HDC_200_plusCD;
                    _Agfacolor_HDC_400_plusCD;
                    _Agfacolor_Optima_II_100CD;
                    _Agfacolor_Optima_II_200CD;
                    _Agfacolor_ultra_050_CD;
                    _Agfacolor_Vista_100CD;
                    _Agfacolor_Vista_200CD;
                    _Agfacolor_Vista_400CD;
                    _Agfacolor_Vista_800CD;
                    _Agfachrome_CT_precisa_100CD;
                    _Agfachrome_CT_precisa_200CD;
                    _Agfachrome_RSX2_050CD;
                    _Agfachrome_RSX2_100CD;
                    _Agfachrome_RSX2_200CD;
                    _Advantix_100CD;
                    _Advantix_200CD;
                    _Advantix_400CD;
                    _Gold_100CD;
                    _Gold_200CD;
                    _Max_Zoom_800CD;
                    _Portra_100TCD;
                    _Portra_160NCCD;
                    _Portra_160VCCD;
                    _Portra_800CD;
                    _Portra_400VCCD;
                    _Portra_400NCCD;
                    _Ektachrome_100_plusCD;
                    _Ektachrome_320TCD;
                    _Ektachrome_400XCD;
                    _Ektachrome_64CD;
                    _Ektachrome_64TCD;
                    _Ektachrome_E100SCD;
                    _Ektachrome_100CD;
                    _Kodachrome_200CD;
                    _Kodachrome_25;
                    _Kodachrome_64CD;
                    _F125CD;
                    _F250CD;
                    _F400CD;
                    _FCICD;
                    _DSCS315_1;
                    _DSCS315_2;
                    _DSCS315_3;
                    _DSCS315_4;
                    _DSCS315_5;
                    _DSCS315_6;
                    _FP2900Z;
                    _Linear;
                    _sRGB;
                    _Gamma18;
                    _Gamma22;

                    }
                }

                BOOL    OCTANECAMERA_NAT_RESPONSE { }
                REAL    OCTANECAMERA_GAMMA          { CUSTOMGUI OCTNSLIDER; LOGARITMIC 1; UNIT REAL;  STEP 0.01; MIN 0.1; MAX 32.0; }

                GROUP OCTANECAM_CUSTOMLUT_GRP
                {
                    FILENAME OCT_CAMERA_IMAGER_CUSTOM_LUT   { OPEN; }
                    REAL    OCT_CAMERA_IMAGER_CUSTOMLUT_STRENGTH { CUSTOMGUI OCTNSLIDER; UNIT REAL;  STEP 0.01; MIN 0.0; MAX 1.0; }
                }

                COLOR   OCTANECAMERA_WHITEBALANCE {}
                REAL    OCTANECAMERA_VIGNETTING { CUSTOMGUI OCTNSLIDER; UNIT REAL;  STEP 0.01; MIN 0.0; MAX 1.0; }
                REAL    OCTANECAMERA_SATURATION { CUSTOMGUI OCTNSLIDER; UNIT REAL;  STEP 0.01; MIN 0.0; MAX 4.0; }
                REAL    OCTANECAMERA_HOTPIXEL { CUSTOMGUI OCTNSLIDER;   UNIT REAL;  STEP 0.01; MIN 0.0; MAX 1.0; }


                BOOL    OCTANECAMERA_PREMALPHA {}
                BOOL    OCTANECAMERA_DIS_PARALPHA {}
                BOOL    OCTANECAMERA_DITHERING {}
                REAL    OCTANECAMERA_SATURATETOWHITE  { CUSTOMGUI OCTNSLIDER; UNIT REAL;  STEP 0.01; MIN 0.0; MAX 1.0; }
                REAL    OCTANECAMERA_MDISP_SAMPLES { CUSTOMGUI OCTNSLIDER; UNIT REAL;  STEP 1; MIN 1.0; MAX 32.0; }
                LONG    OCTANECAMERA_MAX_TM_INTERVAL  { MIN 1; MAX 120; }
            }
        }

        GROUP OCTANECAMERA_POSTGRP
        {
            BOOL	CAM_POSTENABLED {}
            REAL	CAM_BOOMPOWER   { CUSTOMGUI OCTNSLIDER; LOGARITMIC 1; UNIT REAL;  STEP 0.1; MIN 0.001; MAX 100000.0; MAXSLIDER 1000;}
            REAL	CAM_GLAREPOWER  { CUSTOMGUI OCTNSLIDER; LOGARITMIC 1; UNIT REAL;  STEP 0.1; MIN 0.001; MAX 100000.0; MAXSLIDER 1000;}
            LONG	CAM_GLARE_RAY_AMOUNT {  }
            REAL	CAM_GLARE_ANGLE { CUSTOMGUI OCTNSLIDER; UNIT REAL;  STEP 0.01; MIN -90; MAX 90; }
            REAL	CAM_GLARE_BLUR {  CUSTOMGUI OCTNSLIDER; UNIT REAL;  STEP 0.01; MIN 0.001; MAX 0.20; }
            REAL	CAM_SPECTRAL_INT {  CUSTOMGUI OCTNSLIDER; UNIT REAL;  STEP 0.01; MIN 0.0; MAX 1; }
            REAL	CAM_SPECTRAL_SHIFT {  CUSTOMGUI OCTNSLIDER; UNIT REAL;  STEP 0.01; MIN 0.0; MAX 6; }
        }

        GROUP OCTANECAMERA_STEREOGRP
        {
            LONG OCT_CAMERA_STEREOMODE
            {
                CYCLE
                {
                    //OCT_CAMERA_STEREO_MODE_NONE;
                    OCT_CAMERA_STEREO_MODE_OFF_AXIS;
                    OCT_CAMERA_STEREO_MODE_PARALLEL;
                }
            }
            LONG OCT_CAMERA_STEREOOUT
            {
                CYCLE
                {
                    OCT_CAMERA_STEREO_OUTPUT_NOSTEREO;
                    OCT_CAMERA_STEREO_OUTPUT_LEFT_EYE;
                    OCT_CAMERA_STEREO_OUTPUT_RIGHT_EYE;
                    OCT_CAMERA_STEREO_OUTPUT_SIDE_BY_SIDE;
                    OCT_CAMERA_STEREO_OUTPUT_ANAGLYPHIC;
                    OCT_CAMERA_STEREO_OUTPUT_OVERUNDER;
                }
            }

            REAL	OCTANECAMERA_EYEDIST { CUSTOMGUI OCTNSLIDER; MIN 0.001; MAX 1; STEP 0.01; }
            REAL	OCTANECAMERA_EYEDIST_FALLOFF { CUSTOMGUI OCTNSLIDER; MIN 0.001; MAX 1; STEP 0.01; }
            REAL	OCTANECAMERA_STEREO_BLACKLATITUDE { CUSTOMGUI OCTNSLIDER; MIN 1; MAX 90; STEP 0.01; }
            BOOL	OCT_CAMERA_STEREO_SWAPEYE {}

            COLOR	OCTANECAMERA_LEFTFILTER	{}
            COLOR	OCTANECAMERA_RIGHTFILTER {}
        }

        GROUP OCT_CAMERA_BUTTONGRP
        {
            SEPARATOR { LINE; }
            BITMAPBUTTON  OCT_CAMERA_HELPBUTTON {ANIM OFF;}
        }
}
