#ifndef _C4D_SYMBOLS_H
#define _C4D_SYMBOLS_H

#define ID_OCTANE_LIVEPLUGIN				1029499
#define ID_OCTANE_MESSAGEPLUGIN				1029500
#define ID_OCTANE_DIFFUSE_MATERIAL			1029501
#define ID_OCTANE_MIX_MATERIAL              1029622
#define ID_OCTANE_PORTAL_MATERIAL			1029623
#define ID_OCTANE_VIDEOPOST_RENDERER		1029525
#define ID_OCTANE_OBJECTTAG                 1029603
#define ID_OCTANE_FALLOFFMAP				1029503
#define ID_VOLUMEOBJECT                     1035792
#define ID_SCATTER_OBJECT                   1035961
#define ID_SIMPLEMAT                        1401164
#define AO_EMITTER_OBJECT                   1041085
#define ID_OSL_OBJECT                       1050417
#define ID_ORBX_LOADER                      1050418

/// octane colour textures
#define ID_OCTANE_RGBSPECTRUM				1029504
#define ID_OCTANE_GAUSSIANSPECTRUM			1029507
#define ID_OCTANE_FLOAT_TEXTURE				1029506
#define ID_OCTANE_CAMERATAG					1029524
#define ID_OCTANE_LIGHT_TAG					1029526

/// image textures
#define ID_OCTANE_IMAGE_TEXTURE				1029508
//#define ID_OCTANE_ALPHAIMAGE_TEXTURE		1029509
//#define ID_OCTANE_FLOATIMAGE_TEXTURE		1029510

/// octane mapping textures
#define ID_OCTANE_MIXTEXTURE				1029505
#define ID_OCTANE_CLAMP_TEXTURE				1029511
#define ID_OCTANE_COLORCORRECTION			1029512
#define ID_OCTANE_GRADIENT_TEXTURE			1029513
#define ID_OCTANE_INVERT_TEXTURE			1029514
#define ID_OCTANE_COSINEMIX_TEXTURE			1029515
#define ID_OCTANE_MULTIPLY_TEXTURE			1029516
#define ID_OCTANE_ADD_TEXTURE               1038877
#define ID_OCTANE_SUBTRACT_TEXTURE			1038878
#define ID_OCTANE_COMPARE_TEXTURE			1038879
#define ID_OCTANE_MATH_TEXTURE              1038880
//#define ID_OCTANE_OSL_TEXTURE               1038881
#define ID_INSTANCE_RANGE_TEXTURE           1039376
#define ID_INSTANCE_COLOR_TEXTURE           1039377
#define ID_OCTANE_OSL_TEXTURE               1039813
#define ID_OCTANE_TOONRAMP_TEXTURE          1040143

#define ID_OCTANE_NODEGRAPH_TEXTURE			1038623

#define ID_OCTANE_VOLUME_RAMP               1036942

/// octane generator textures
#define ID_OCTANE_CHECKSMIX_TEXTURE			1029517
#define ID_OCTANE_RIDGEDFRACTAL_TEXTURE		1029518
#define ID_OCTANE_SAWWAVE_TEXTURE			1029519
#define ID_OCTANE_SINEWAVE_TEXTURE			1029520
#define ID_OCTANE_TRIANGLEWAVE_TEXTURE		1029521
#define ID_OCTANE_TURBULENCE_TEXTURE		1029522
#define ID_OCTANE_MARBLE_TEXTURE			1029523
#define ID_OCTANE_NOISE_TEXTURE             1033698
#define ID_OCTANE_BAKING_TEXTURE            1039681

#define ID_OCTANE_TRANSFORM                 1030961
#define ID_OCTANE_UVW_TRANSFORM             1039678
#define ID_OCTANE_TEXTURE_PROJECTION        1031460
#define ID_REFERANCE_SHADER                 1031605


#define OCTANE_CUSTOMGUI                1029527
#define OCTANE_COLORGUI                 1029945
#define OCTANE_FLOATSLIDER              1030680

#define ID_OCTANE_SCATTERING_MEDIUM		1029509
#define ID_OCTANE_ABSORPTION_MEDIUM		1029510
#define ID_OCTANE_VOLUME_MEDIUM         1036940

#define ID_OCTANE_NULL_EMISSION         1029640
#define ID_OCTANE_BLACKBODY_EMISSION	1029641
#define ID_OCTANE_TEXTURE_EMISSION      1029642
#define ID_OCTANE_ENVIRONMENT_TAG       1029643
#define ID_OCTANE_DAYLIGHT_TAG          1029754
#define ID_OCTANE_MATERIAL_CONVERT      1029770
#define ID_OCTANE_DIRT_TEXTURE			1029975
#define ID_OCTANE_SCENEHOOK             1030798
#define OCTANE_FLOAT3SLIDER             1030909
#define OCTANE_CUSTOMDATATYPE           1035643

#define ID_OPEN_OCTANE_DIALOG           1031193
#define ID_OCTANE_TEST                  1031194
#define ID_OCTANE_OPEN_SETTINGS         1031195
#define ID_OCTANE_LIVE_VIEWER           1031198
#define ID_OCTANE_BROWSER               1031267
#define ID_OCTANE_DISPLACEMENT          1031901
#define ID_OCTANE_RANDOMCOLOR           1032069
#define ID_OCTANE_POLYGONSIDE           1034143
#define ID_OCTANE_HELPDIALOG            1033750
#define ID_OCTANE_TEXTURE_DIALOG        1035275
#define ID_OCTANE_WCOORDINATE           1038090
#define ID_OCTANE_TRIPLANAR             1038882

#define ID_CREATE_DAYLIGHT_PLUGIN       1033863
#define ID_CREATE_AREALIGHT_PLUGIN      1033864
#define ID_CREATE_CAMERA_PLUGIN         1033865
#define ID_CREATE_ENV_PLUGIN            1033866
#define ID_CREATE_HDRIENV_PLUGIN        1033867
#define ID_CREATE_TAREALIGHT_PLUGIN     1033868
#define ID_CREATE_IESLIGHT_PLUGIN       1033869
#define ID_CREATE_SCATTER_PLUGIN        1036195
#define ID_OPEN_LIVEDB_PLUGIN           1033870
#define ID_CREATE_DIFFUSEMAT_PLUGIN     1033871
#define ID_OPEN_NODEEDITOR_PLUGIN       1033872
#define ID_STARTRENDER_PLUGIN           1033873
#define ID_CREATE_GLOSSYMAT_PLUGIN      1033893
#define ID_CREATE_SPECMAT_PLUGIN        1033894
#define ID_CREATE_MIXMAT_PLUGIN         1033895
#define ID_OPEN_HELP_WINDOW_PLUGIN      1033896
#define ID_PAUSERENDER_PLUGIN           1033954
#define ID_STOPRENDER_PLUGIN            1033955
#define ID_STOPRESET_PLUGIN             1033956
#define ID_REMOVE_UNUSED_MATERIALS      1035351
#define ID_REMOVE_DUPLICATED_MATERIALS  1036468
#define ID_CREATE_VOLUME_FOG_OBJECT     1036589
#define ID_CREATE_VOLUME_VDB_OBJECT     1037329
#define ID_EXPORT_ANIM_ORBX             1037665
#define ID_OCTANE_SDKBROWSER            1038839

#define ID_CREATE_METALMAT_PLUGIN       1040116
#define ID_CREATE_TOONMAT_PLUGIN        1040117
#define ID_CREATE_BLENDMAT_PLUGIN       1040118

#define OCTANEPREFS_ID                  1035356
#define OCTANE_PREFS_DIALOG_ID          1035357

#define ID_OCTANE_BLEND_MATERIAL        1040075
#define ID_OCTANE_SUB_MATERIAL          1040369
#define ID_CREATE_UNIVERSALMAT_PLUGIN   1041569

//#define ID_CONVERT_MATERIALS          1029995
//#define ID_OCTANE_LIGHT_TAG           1029979
//#define ID_OCTANE_VIDEOPOST           1005172

enum
{
	// string table definitions
	IDS_GRADIENTTITLE	= 10000,
    IDS_OCTANEMATERIAL = 10001,
    IDS_OCTANECAMERA = 10002,
    IDS_OCTANELIVERENDER = 10003,
    IDS_GL_TEST_OBJECT = 10004,
    IDS_OCTANE_VIDEOPOST = 10005,
    IDC_SERIALNUMBER = 10006,
    DLG_REGISTER = 10007,
    ID_OCTANE_DIALOG = 10008,
    NO_SKY_OR_FOREGROUND_LINK = 10009,
    IDS_RGBSPECTRUM = 10011,

    IDS_OCTANE_FALLOFFMAP = 10012,
    IDS_MIXTEXTURE = 10013,
    IDS_CHECKSMIXTEXTURE = 10014,
    IDS_ALPHAIMAGE = 10015,
    IDS_CLAMPTEXTURE = 10016,
    IDS_COLORCORRECTION = 10017,
    IDS_COSINEMIX = 10018,
    IDS_FLOATIMAGE = 10019,
    IDS_FLOATTEXTURE = 10020,
    IDS_GAUSSIANSPECTRUM = 10021,
    IDS_GRADIENT = 10022,
    IDS_FLOATIMAGETEXTURE = 10023,
    IDS_ALPHAIMAGETEXTURE = 10024,
    IDS_IMAGETEXTURE = 10025,
    IDS_INVERT = 10026,
    IDS_MARBLE = 10027,
    IDS_MULTIPLY = 10028,
    IDS_RIDGEDFRACTAL = 10029,
    IDS_SAWWAVE = 10030,
    IDS_SINEWAVE = 10031,
    IDS_TRIANGLEWAVE = 10032,
    IDS_TURBULENCE = 10033,

    IDS_OCTANE_PORTAL_MATERIAL = 10034,
    IDS_OCTANE_MIX_MATERIAL = 10035,

    IDS_ABSORPTION_MEDIUM = 10036,
    IDS_SCATTERING_MEDIUM = 10037,
    IDS_BLACKBODY_EMISSION = 10038,
    IDS_TEXTURE_EMISSION = 10039,
    IDS_ENVIRONMENT_TAG = 10040,
    ID_SETTINGS_DIALOG = 10041,
    IDS_CONVERT_MATERIALS = 10042,
    IDS_OCTANEDAYLIGHT_TAG = 10043,
    IDS_OCTANE_DIRTTEXTURE = 10044,
    IDS_LIGHT_TAG = 10045,
    IDS_INSTANCE_COLOR,
    IDS_OSL_TEXTURE,
    IDS_OBJECT_TAG,
    IDS_OCTANE_DISPLACEMENT,
    IDS_LISTVIEW,
    IDC_STATIC,
    IDS_VIDEOPOST,
    IDS_TRANSFORM,
    IDS_UVW_TRANSFORM,
    IDS_TEXTURE_PROJECTION,
    IDS_OPEN_OCTANE_DIALOG,
    IDS_OPEN_SETTINGS,
    IDS_OPEN_LIVEVIEWER,
    IDS_REFERANCE_SHADER,
    IDS_RANDOMCOLOR,
    IDS_POLYGONSIDE,
    IDS_WCOORDINATE,
    IDS_NOISE,
    IDS_BAKING_TEXTURE,
    IDS_OPEN_LIVEDB,
    IDS_OCTANEPREFS,
    IDS_VOLUMEMEDIUM,
    IDS_VOLUMEGRADIENT,
    IDS_NODEGRAPH_TEX,
    IDS_ADD_TEX,
    IDS_INST_RANGE_TEX,
    IDS_SUBTRACT_TEX,
    IDS_COMPARE_TEX,
    IDS_TRIPLANAR_TEX,
    IDS_OCT_BLEND_MATERIAL,
    IDS_TOONRAMP,

	// Dialog definitions of IDD_DIALOG1 start here
	IDD_DIALOG1,
	IDC_EDIT1,
	IDC_COMBO1,
	IDC_BUTTON1,
	IDC_STATIC1,
	TAB_ID,

	IDC_OCTANE_DIFFUSE,
	IDC_OCTANE_DIFFUSE_TAB,

	IDD_OCTANE_LIVEVIEW,
    IDC_ACTIVATE_BUTTON,
    IDC_DEACTIVATE_BUTTON,
    IDC_INFOTEXT,
    IDC_UPDATE_MATERIALS,
    IDC_OPEN_SETTINS_DIALOG,
    IDC_UPDATE_TRANSFORM,
    IDC_RENDER_ANIM,
    IDC_LV_RES_SCALE,
    //GROUP_SCROLL,
  //  GROUP_DYNAMIC,
    GROUP_PREVIEW,
    GROUP_SETTINGS,
    GROUP_UPDATE_SETTINGS,
    GROUP_ACCOUNT,
    GROUP_ADMIN,
    IDC_LOGOUT_TEXT,
    IDC_USERID_TEXT,
    IDC_USERPASS_TEXT,
    IDC_MEMORY_STAT_,
    IDC_USE_NEWGUI,
    IDC_LICENSE_TEXT,
	// Dialog definitions of IDD_OCTANELIVE_DIALOG start here

	IDC_BITMAP,
    IDC_MENU_ENABLE_MENUS,
    IDC_MENU_ENABLE_ICONS,
    IDC_MENU_SAVE_PNG8,
    IDC_MENU_SAVE_PNG16,
    IDC_MENU_SAVE_EXR,
    IDC_MENU_SAVE_EXRTONEMAPPED,
    IDC_MENU_SAVE_RENDERPASSES_EXR,
    IDC_MENU_SAVE_RENDERPASSES_PSD,
    IDC_MENU_SAVE_PROJECT,
    IDC_MENU_CREATE_COLORENV,
    IDC_MENU_CREATE_HDRIENV,
    IDC_MENU_CAMERA,
    IDC_MENU_AREALIGHT,
    IDC_MENU_IESLIGHT,
    IDC_MENU_TARGETED_AREALIGHT,
    IDC_MENU_DAYLIGHT,
    IDC_MENU_LIVEDBASE,
    IDC_MENU_ADD_DIFFUSEMAT,
    IDC_MENU_ADD_GLOSSYMAT,
    IDC_MENU_ADD_SPECULARMAT,
    IDC_MENU_ADD_MIXMAT,
    IDC_MENU_ADD_METAL,
    IDC_MENU_ADD_TOON,
    IDC_MENU_ADD_BLEND,
    IDC_MENU_ADD_PORTALMAT,
    IDC_MENU_REMOVE_DUPLICATED_MATS,
    IDC_MENU_CHECK_CAMERA,
    IDC_MENU_CHECK_MATERIALS,
    IDC_MENU_CHECK_LIGHTS,
    IDC_MENU_CHECK_GEOMETRY,
    IDC_MENU_ALL_MOVABLE,
    IDC_MENU_CHECK_INDRAG,
    IDC_MENU_CHECK_PAINTTEX,
    IDC_MENU_STORE_RENDERBUFFER,
    IDC_MENU_ENABLE_COMPARISON,
    IDC_MENU_ENABLE_ZOOM,
    IDC_MENU_ZOOM_CENTERED,
    IDC_MENU_ZOOM_ALIGNED,
    IDC_MENU_LV_CAMERA_MBLUR,
    IDC_MENU_LV_ALPHA_CHECKS,
    IDC_MENU_LV_ALPHA_BLACK,
    IDC_MENU_LV_OBJECT_MBLUR,
    IDC_MENU_LV_VERTEX_MBLUR,
    IDC_MENU_ENABLE_PREVIEWS,
    IDC_MENU_ENABLE_OPENGL,
    IDC_MENU_ENABLE_PARTICLES,
    IDC_MENU_ENABLE_NETRENDER,
    IDC_MENU_NETRENDER_SETTINGS,
    IDC_MENU_ENABLE_FULLSCREEN,
    IDC_MENU_VIEWPORT_RENDERING,
    IDC_MENU_SHOW_HELP_WINDOW,
    IDC_MENU_HELP_SHOWHELP,
    IDC_MENU_HELP_SHOWPDF,
    IDC_MENU_HELP_SHOWGPU,
    IDC_MENU_LICENSE,
    IDC_MENU_CHECK_LATEST_VERSION,
    IDC_MENU_HELP_TEST,
    IDC_MENU_HELP_SHOW_DEBUG,
    IDC_MENU_HELP_OCTANELOG,
    IDC_MENU_SUBSAMPLE_NONE,
    IDC_MENU_SUBSAMPLE_1,
    IDC_MENU_SUBSAMPLE_2,

    IDC_NODEMENU_APINODE_TO_C4D,
    IDC_NODEMENU_UPDATE_C4D_MATERIAL,
    IDC_NODEMENU_AUTOLOAD_MATERIAL,
    IDC_NODEMENU_PREVS_ONDRAG,
    IDC_NODEMENU_OBJECT_CONTROLS,
    IDC_NODEMENU_SETTINGS,
    IDC_NODEMENU_TOGGLE_SNAP,
    IDC_NODEMENU_GETC4D,
    IDC_NODEMENU_SELECTCHILDS,
    IDC_NODEMENU_AUTOARRANGE,
    IDC_NODEMENU_CONVERT_TO_SUBMATERIAL,
    IDC_NODEMENU_SUBSELECTION,
    IDC_NODEMENU_MINIMIZE_NODE,
    IDC_NODEMENU_FRAME_ALL,
    IDC_NODEMENU_FRAME_SELECTED,
    IDC_NODEMENU_ZOOM_0_5,
    IDC_NODEMENU_ZOOM_1_0,
    IDC_NODEMENU_ZOOM_1_5,
    IDC_NODEMENU_ZOOM_2_0,

    //---- START OF NE'S ADD COMMANDS ---
    IDC_NODEMENU_START_OF_ADDLIST,
    IDC_NODEMENU_ADD_MATERIAL,
    IDC_NODEMENU_ADD_MIXMATERIAL,
    IDC_NODEMENU_ADD_BLENDMATERIAL,
    IDC_NODEMENU_ADD_RGB,
    IDC_NODEMENU_ADD_GAUSSIAN,
    IDC_NODEMENU_ADD_FLOAT,
    IDC_NODEMENU_ADD_FLOATTEX,
    IDC_NODEMENU_ADD_BAKING_TEX,
    IDC_NODEMENU_ADD_OSL_TEX,
    IDC_NODEMENU_ADD_WCOORDINATE,
    IDC_NODEMENU_ADD_FALLOFF,
    IDC_NODEMENU_ADD_IMAGE,
    IDC_NODEMENU_ADD_OCTGRADIENT,
    IDC_NODEMENU_ADD_DISPLACEMENT,
    IDC_NODEMENU_ADD_MARBLE,
    IDC_NODEMENU_ADD_XNOISE,
    IDC_NODEMENU_ADD_NOISE,
    IDC_NODEMENU_ADD_RANDOMCOLOR,
    IDC_NODEMENU_ADD_DIRT,
    IDC_NODEMENU_ADD_INVERT,
    IDC_NODEMENU_ADD_MULTIPLY,
    IDC_NODEMENU_ADD_ADD,
    IDC_NODEMENU_ADD_SUB,
    IDC_NODEMENU_ADD_COMPARE,
    IDC_NODEMENU_ADD_TRIPLANAR,
    IDC_NODEMENU_ADD_UVW_TRANSFORM,
    IDC_NODEMENU_ADD_MIX,
    IDC_NODEMENU_ADD_CHECK,
    IDC_NODEMENU_ADD_COSINEMIX,
    IDC_NODEMENU_ADD_CLAMP,
    IDC_NODEMENU_ADD_CC,
    IDC_NODEMENU_ADD_GRADIENT,
    IDC_NODEMENU_ADD_BBEMISSION,
    IDC_NODEMENU_ADD_TXEMISSION,
    IDC_NODEMENU_ADD_ABSMEDIUM,
    IDC_NODEMENU_ADD_SCTMEDIUM,
    IDC_NODEMENU_ADD_SINEWAVE,
    IDC_NODEMENU_ADD_INSTANCE_COLOR,
    IDC_NODEMENU_ADD_TOONRAMP,
    IDC_NODEMENU_ADD_TRIWAVE,
    IDC_NODEMENU_ADD_SAWWAVE,
    IDC_NODEMENU_ADD_TURBULENCE,
    IDC_NODEMENU_ADD_RFRACTAL,
    IDC_NODEMENU_ADD_TRANSFORM,
    IDC_NODEMENU_ADD_TRANSFORM3D,
    IDC_NODEMENU_ADD_TRANSFORM_SCALE,
    IDC_NODEMENU_ADD_TRANSFORM_ROT,
    IDC_NODEMENU_ADD_TRANSFORMVALUE,
    IDC_NODEMENU_ADD_TEXTURE_PROJECTION,
    IDC_NODEMENU_ADD_PROJ_LINEAR,
    IDC_NODEMENU_ADD_PROJ_PERSP,
    IDC_NODEMENU_ADD_PROJ_SPHERICAL,
    IDC_NODEMENU_ADD_PROJ_UVW,
    IDC_NODEMENU_ADD_END_OF_ADDLIST,
    //---- END OF NE'S ADD COMMANDS ---

    IDC_NODEMENU_RENAME_NODE,
    IDC_NODEMENU_SWITCH_PREVIEWS,
    IDC_NODEMENU_DISABLE_NODE,
    IDC_NODEMENU_SOLO_NODE,
    IDC_NODEMENU_DISABLE_SOLO_NODE,
    IDC_NODEMENU_APPLY_NODE,
    IDC_NODEMENU_ENABLE_PREVIEW_MODE,
    IDC_NODEMENU_DISABLE_PREVIEW_MODE,
    IDC_NODEMENU_HELP,
    IDC_NODEMENU_COPY_NODE,
    IDC_NODEMENU_PASTE_NODE,
    IDC_NODEMENU_DELETE_NODE,
    IDC_NODEMENU_DETACH_NODE,
    IDC_NODEMENU_SELECT_MAT,
    IDC_NODEMENU_SELECT_TREE,
    IDC_NODEMENU_SHOW_NODEGRAPH,
    IDC_NODEMENU_SAVE_AS_ORBX,
    IDC_NODEMENU_GROUP_ITEMS,
    IDC_NODEMENU_UNGROUP_ITEMS,
    IDC_NODEMENU_SAVE_AS_PRESET,
    IDC_NODEMENU_EDIT_MENU,
    IDC_NODEMENU_MATTIP_MENU,
    IDC_NODEMENU_MATTIP_DIFFUSE,
    IDC_NODEMENU_MATTIP_GLOSSY,
    IDC_NODEMENU_MATTIP_SPECULAR,
    IDC_NODEMENU_MATTIP_METALLIC,
    IDC_NODEMENU_MATTIP_UNIVERSAL,
    IDC_NODEMENU_MATTIP_TOON,
    IDC_NODEMENU_PINS_MENU,
    IDC_NODEMENU_HIDE_ALLPINS,
    IDC_NODEMENU_SHOW_ALLPINS,
    IDC_NODEMENU_TOGGLE_PARAMS,
    IDC_NODEMENU_TOGGLE_GUI,
    IDC_NODEMENU_HIDE_PIN1,
    IDC_NODEMENU_HIDE_PIN2,
    IDC_NODEMENU_HIDE_PIN3,
    IDC_NODEMENU_HIDE_PIN4,
    IDC_NODEMENU_HIDE_PIN5,
    IDC_NODEMENU_HIDE_PIN6,
    IDC_NODEMENU_HIDE_PIN7,
    IDC_NODEMENU_HIDE_PIN8,
    IDC_NODEMENU_HIDE_PIN9,
    IDC_NODEMENU_HIDE_PIN10,
    IDC_NODEMENU_HIDE_PIN11,
    IDC_NODEMENU_HIDE_PIN12,
    IDC_NODEMENU_HIDE_PIN13,
    IDC_NODEMENU_HIDE_PIN14,
    IDC_NODEMENU_HIDE_PIN15,
    IDC_NODEMENU_HIDE_PIN16,
    IDC_NODEMENU_HIDE_PIN17,
    IDC_NODEMENU_HIDE_PIN18,
    IDC_NODEMENU_HIDE_PIN19,
    IDC_NODEMENU_HIDE_PIN20,
    IDC_NODEMENU_HIDE_PIN21,
    IDC_NODEMENU_HIDE_PIN22,
    IDC_NODEMENU_HIDE_PIN23,
    IDC_NODEMENU_HIDE_PIN24,
    IDC_NODEMENU_HIDE_PIN25,
    IDC_NODEMENU_HIDE_PIN26,
    IDC_NODEMENU_HIDE_PIN27,
    IDC_NODEMENU_HIDE_PIN28,
    IDC_NODEMENU_HIDE_PIN29,
    IDC_NODEMENU_HIDE_PIN30,
    IDC_NODEMENU_HIDE_PIN31,
    IDC_NODEMENU_HIDE_PIN32,

    IDC_NODE_BUTTON1=10400,
    IDC_NODE_SEARCH,

    IDC_MENU_RESET_SETTINGS,
    IDC_MENU_COPY_SETTINGS,
    IDC_MENU_PASTE_SETTINGS,
    IDC_MENU_COPY_TO_VPOST,
    IDC_MENU_EDIT_PRESETS,
    IDC_MENU_REPLACE_SELECTED_PRESET,
    IDC_MENU_ADD_PRESET,
    IDC_BUT_ADD_PRESET,
    IDC_BUT_CLOSE_PRESET,
    IDC_BUT_REMOVE_PRESET,
    IDC_TEXTNAME_PRESET,

	IDC_DGL_BUTTONS_GRP,
    IDC_OCTDGL_BUTTONS_GRP,
    IDC_OCTDGL_SUBDLG_GRP,
    IDC_SENDTO_RENDER,
    IDC_RESTART_RENDER,
    IDC_PAUSE_RENDER,
    IDC_STOP_RESET_RENDERER,
    IDC_STOP_RENDER,
    IDC_STOP_PREVIEW,
    IDC_UPDATE_LIGHTS,
	IDC_SAVE_IMAGE,
    IDC_LOAD_OCS,
    IDC_IMPORT_ORBX,
    IDC_EXPORT_TO_OCS,
    IDC_EXPORT_TO_ORBX,
    IDC_EXPORT_ANIM_ORBX,
    IDC_EDIT_IN_STANDALONE,
    IDC_CLOUD_LOGIN,
    IDC_CLOUD_LOGOUT,
    IDC_CLOUD_USER,
    IDC_CLOUD_SEND_CURRENT,
    IDC_CLOUD_RENDER,
    IDC_ADD_TOON_OMNI,
    IDC_ADD_TOON_DIRECT,
    IDC_PICK_FOCUS,
    IDC_PICK_MATERIAL,
    IDC_PAINT,
    IDC_SHOWGRAPH,
    IDC_SHOWGRAPH2,
    IDC_OPEN_NODEEDITOR,
    IDC_OPEN_LIVEDB,
    IDC_OPEN_LIVEDB_BROWSER,
	IDC_SMART_REFRESH,
    IDC_GEOMETRY_UPDATES,
    IDC_MATERIAL_UPDATES,
    IDC_CAMERA_UPDATES,
    IDC_LIGHT_UPDATES,
	IDC_LOGGING,
    IDC_COLOR_TYPE,
    IDC_SLIDER_TYPE,
    IDC_SLIDER_APPLY,
    IDC_TIMEOUT,
    IDC_CONVERT_MATERIALS,
    IDC_REMOVE_UNUSED_MATERIALS,
    IDC_REMOVE_DOUBLE_MATERIALS,
    IDC_CHECK_AND_FIX_MATERIAL,
    IDC_MAKE_PREVIEW,
    IDC_LOCK_RESOLUTION,
    IDC_ENABLE_CLAY,
    IDC_ENABLE_RENDREGION,
    IDC_ENABLE_FILMREGION,
    IDC_BITMAP_BUTTON,
	IDC_RENDER_GROUP,
	IDC_RENDERAREA,
	IDC_USERMSG_TEXT,
    IDC_RENDERPROGRESS_SLIDER,
    IDC_DEVICE_PRIORTY,
    IDC_DEVICE_USEPRIORTY,
    IDC_DISPLAY_CHANNEL,

    IDC_GPUDLG_TEXTURES,
    IDC_GPUDLG_RENDERINFO1,
    IDC_GPUDLG_RENDERINFO2,
    IDC_GPUDLG_TEXT2,
    IDC_GPUDLG_TEXT3,
    IDC_GPUDLG_STATS1,
    IDC_GPUDLG_STATS2,
    IDC_GPUDLG_RENDER_STATS,
    IDC_GPUDLG_DEVICE1,
    IDC_GPUDLG_DEVICE2,
    IDC_GPUDLG_DEVICE3,
    IDC_GPUDLG_DEVICE4,
    IDC_GPUDLG_DEVICE5,
    IDC_GPUDLG_DEVICE6,
    IDC_GPUDLG_DEVICE7,
    IDC_GPUDLG_DEVICE8,
    IDC_NODEEDITOR_BUTTONS_GRP,
    IDC_NODEEDITOR_VIEWPORT_GRP,
    IDC_NODEEDITOR_VIEWPORT,
    IDC_NODEEDITOR_NG_GROUP,
    IDC_NODEEDITOR_CTRLS_GRP,
    IDC_NODEEDITOR_SUBDIALOG,
    IDC_NODEEDITOR_INFOTEXT,
    IDC_NODEEDITOR_FLOATTEXTURE,
    IDC_NODEEDITOR_RGBSPECTRUM,
    IDC_NODEEDITOR_FILENAME,
    IDC_NODEEDITOR_EDIT_GRP,

    IDC_NODEEDITOR_CTRL_BEGIN,

    IDD_OCTANE_VERSION_DIALOG=11988,
    IDD_OCTANE_HELP_DIALOG=11989,
    IDD_OSL_CODE_DIALOG=11990,
    IDD_OCTANEEXPORT_DIALOG=11991,
    IDD_OCTANEICONS_DIALOG=11992,
    IDD_SETTINGS_DIALOG=11993,
    IDD_TEXTURE_DIALOG=11994,
    IDD_PRESET_DIALOG=11995,
    IDD_GPU_DIALOG=11996,
    IDD_DBMATERIAL_DIALOG=11997,
    IDD_NODEEDITOR_DIALOG=11998,
    IDD_OCTANELIVE_DIALOG=11999,

    IDC_DEVICE_GROUP=12000,
    IDC_DEVICE1_CHECK=12001,
    IDC_DEVICE2_CHECK=12002,
    IDC_DEVICE3_CHECK=12003,
    IDC_DEVICE4_CHECK=12004,
    IDC_DEVICE5_CHECK=12005,
    IDC_DEVICE6_CHECK=12006,
    IDC_DEVICE7_CHECK=12007,
    IDC_DEVICE8_CHECK=12008,
    IDC_DEVICE9_CHECK=12009,
    IDC_DEVICE10_CHECK=12010,
    IDC_DEVICE11_CHECK=12011,
    IDC_DEVICE12_CHECK=12012,
    IDC_DEVICE13_CHECK=12013,
    IDC_DEVICE14_CHECK=12014,
    IDC_DEVICE15_CHECK=12015,
    IDC_DEVICE16_CHECK=12016,

    IDC_DEVICE1_USEPRIORITY=12200,
    IDC_DEVICE2_USEPRIORITY,
    IDC_DEVICE3_USEPRIORITY,
    IDC_DEVICE4_USEPRIORITY,
    IDC_DEVICE5_USEPRIORITY,
    IDC_DEVICE6_USEPRIORITY,
    IDC_DEVICE7_USEPRIORITY,
    IDC_DEVICE8_USEPRIORITY,
    IDC_DEVICE9_USEPRIORITY,
    IDC_DEVICE10_USEPRIORITY,
    IDC_DEVICE11_USEPRIORITY,
    IDC_DEVICE12_USEPRIORITY,
    IDC_DEVICE13_USEPRIORITY,
    IDC_DEVICE14_USEPRIORITY,
    IDC_DEVICE15_USEPRIORITY,
    IDC_DEVICE16_USEPRIORITY,

    IDC_DEVICE1_USEFORTONEMAP=12400,
    IDC_DEVICE2_USEFORTONEMAP,
    IDC_DEVICE3_USEFORTONEMAP,
    IDC_DEVICE4_USEFORTONEMAP,
    IDC_DEVICE5_USEFORTONEMAP,
    IDC_DEVICE6_USEFORTONEMAP,
    IDC_DEVICE7_USEFORTONEMAP,
    IDC_DEVICE8_USEFORTONEMAP,
    IDC_DEVICE9_USEFORTONEMAP,
    IDC_DEVICE10_USEFORTONEMAP,
    IDC_DEVICE11_USEFORTONEMAP,
    IDC_DEVICE12_USEFORTONEMAP,
    IDC_DEVICE13_USEFORTONEMAP,
    IDC_DEVICE14_USEFORTONEMAP,
    IDC_DEVICE15_USEFORTONEMAP,
    IDC_DEVICE16_USEFORTONEMAP,

    IDC_DEVICE1_USEFORDENOISE=12600,
    IDC_DEVICE2_USEFORDENOISE,
    IDC_DEVICE3_USEFORDENOISE,
    IDC_DEVICE4_USEFORDENOISE,
    IDC_DEVICE5_USEFORDENOISE,
    IDC_DEVICE6_USEFORDENOISE,
    IDC_DEVICE7_USEFORDENOISE,
    IDC_DEVICE8_USEFORDENOISE,
    IDC_DEVICE9_USEFORDENOISE,
    IDC_DEVICE10_USEFORDENOISE,
    IDC_DEVICE11_USEFORDENOISE,
    IDC_DEVICE12_USEFORDENOISE,
    IDC_DEVICE13_USEFORDENOISE,
    IDC_DEVICE14_USEFORDENOISE,
    IDC_DEVICE15_USEFORDENOISE,
    IDC_DEVICE16_USEFORDENOISE,

    IDC_FIND_GPU_ORDER,

    //---- reserved 64 ID for PRESETS---//
    IDC_MENU_PRESET1=12800,
    IDC_MENU_PRESET2,
    IDC_MENU_PRESET3,
    IDC_MENU_PRESET4,
    IDC_MENU_PRESET5,
    IDC_MENU_PRESET6,
    IDC_MENU_PRESET7,
    IDC_MENU_PRESET8,
    //---- reserved 64 ID for PRESETS. Don't ADD another Id until 12200 ---//

    IDC_ACCOUNT_GROUP=13000,
    IDC_OTHER_SETTINGS_GRP,
    IDC_OTHER_SET1,
    IDC_OTHER_SET2,
    IDC_OTHER_SET3,
    IDC_OTHER_SET4,
    IDC_OTHER_SET5,
    IDC_ENV_SETTINGS_GRP,
    IDC_OUTOFCORE_SETTINGS_GRP,
    IDC_NODEGRAPH_GRP,
    IDC_NODEGRAPH_COLOR1_GRP,
    IDC_NODEGRAPH_COLOR2_GRP,
    IDC_LOG_GROUP,
    IDC_LOGEDIT,
    IDC_LOGLIST,
    IDC_MAIN_TAB_GROUP,
    IDC_RENDERVIEW_GROUP,
    IDC_SETTINGS_GROUP,
    IDC_KERNEL_GROUP,
    IDC_KERNEL_TABGROUP,
    IDC_DIRECTLIGHTING_GROUP,
    IDC_DL_SAMPLING_GROUP,
    IDC_DEEPCHANNEL_GROUP,
    IDC_PATHTRACING_GROUP,
    IDC_PT_SAMPLING_GROUP,
    IDC_PMC_GROUP,
    IDC_CAMERAIMAGER_GROUP,
    IDC_CUSTOMLUT_GRP,
    IDC_POSTPROC_GROUP,
    IDC_DENOISER_GROUP,
    IDC_MAINSETTINGS_GROUP,
    IDC_RENDERPASSES_GROUP,
    IDC_RENDERPASS_TABGROUP,
    IDC_RENDERPASS_GROUP1,
    IDC_RENDERPASS_GROUP2,
    IDC_RENDERLAYER_GROUP1,
    IDC_RENDERPASS_ZGROUP,
    IDC_RENDERPASS_UVGROUP,
    IDC_RENDERPASS_AOGROUP,
    IDC_LIGHTPASSES_GROUP,

    IDC_INFO_BUTTON,
    IDC_OPEN_OCTANELOG_BUTTON,
    IDC_INFO_RESET,
    IDC_INFO_LEVEL_SLIDER,
    IDC_SHADER_RENDER_GRP,
    IDC_SHD2TX_PATH,
    IDC_SHD2TX_PATH_SELECT,
    IDC_SHD2TX_SIZE_SELECT,
    IDC_SHD2TX_USE_HDR_FORSTANDART,
    IDC_SHD2TX_USE_HDR_FORDISPLACEMENT,
    IDC_SHADERTORENDER_ENABLE,
    IDC_LUMINANCE_MULT,
    IDC_DEF_ENVIRON,

    IDC_PREVIEW_SAMPLES,
    IDC_OPENGL_SAMPLES,
    IDC_TEXTURE_POWER,
    IDC_OVERLAY_POWER,
    IDC_CPU_COUNT,
    IDC_OCTMAT_PREVIEWS2,
    IDC_OCTMAT_PREVIEWS,
    IDC_USE_TEX_CACHING,
    IDC_ALTERNATE_UPDATES,
    IDC_DISPLAY_MAINSTATS,
    IDC_DISPLAY_GPUSTATS,
    IDC_DISPLAY_TEXTURESTATS,
    IDC_DISPLAY_KEEP_STATS,
//    IDC_MULTICPUFORLV,
    IDC_ERROR_POPUP,
    IDC_MATPREVIEW_SIZE,
    IDC_AUTO_BACKUP_IMAGE,
    IDC_AUTO_BACKUP_TIMER,
    IDC_LV_REFRESH_TIMER,
    IDC_LV_DEGRADE_TIMER,
    IDC_XBITMAP_GAMMA,
    IDC_MAX_MESHES,
    IDC_OCTANE_EXE_TEXT,
    IDC_OCTANE_EXE_BTN,
    IDC_OCTANE_LOCALDB,
    IDC_OCTANE_LOCALDB_BTN,
    IDC_USE_SOLO,
    IDC_SINGLE_MESH,
    IDC_OGL_ALPHA,
    IDC_OCTANE_CUSTOMLUT_BTN,

    IDC_NG_SIDE_MENU,
    IDC_NG_AUTOHIDE_MENU,
    IDC_NG_EMBED_GUI,
    IDC_NG_AUTOLOAD_MATS,
    IDC_NG_DEBUG,
    IDC_NG_PREVS_ONDRAG,
    IDC_NG_GESTURE,
    IDC_NG_ENABLE_PREVIEWS,
    IDC_NG_RESET_COLORS,
    IDC_NG_BACKCOLOR,
    IDC_NG_GRID_VISIBILITY,
    IDC_NG_BTN_FONT_SIZE,
    IDC_NG_BTN_SIZE,
    IDC_NG_NODE_BACKCOLOR,
    IDC_NG_NODE_TEXTCOLOR,
    IDC_NG_BTN_BACKCOLOR,
    IDC_NG_BTN_TEXTCOLOR,

    IDC_NG_CAT_MAT_COLOR,
    IDC_NG_CAT_TEX_COLOR,
    IDC_NG_CAT_GEN_COLOR,
    IDC_NG_CAT_MAP_COLOR,
    IDC_NG_CAT_TRPROJ_COLOR,
    IDC_NG_CAT_EMIS_COLOR,
    IDC_NG_CAT_MED_COLOR,
    IDC_NG_CAT_DISP_COLOR,
    IDC_NG_CAT_C4D_COLOR,
    IDC_NG_CAT_OTHER_COLOR,

    IDC_OUTOFCORE_ENABLE,
    IDC_OUTOFCORE_RAMUSAGE,
    IDC_OUTOFCORE_GPU_HEADROOM,

    IDC_OTOYSENDSTATS,

    IDC_TEXMNGR_CALCULATE_BTN,
    IDC_TEXMNGR_REMOVE_UNUSEDMATS_BTN,
    IDC_TEXMNGR_FINDMATS_BTN,
    IDC_TEXMNGR_REPLACE_BTN,
    IDC_TEXMNGR_REPLACE_EDIT,
    IDC_TEXMNGR_WITH_EDIT,
    IDC_TEXMNGR_REPLACE_COMBO,
    IDC_TEXMNGR_MAINGROUP,
    IDC_TEXMNGR_GROUP1,
    IDC_TEXMNGR_GROUP2,
    IDC_TEXMNGR_GROUP3,
    IDC_TEXMNGR_GROUP4,
    IDC_TEXMNGR_GROUP5,
    IDC_TEXMNGR_LISTVIEW,
    IDC_TEXMNGR_CUSTOMGUI,
    IDC_TEXMNGR_TEXTURE_IMAGE,
    IDC_TEXMNGR_FNAME_EDIT,
    IDC_TEXMNGR_TEXT1,
    IDC_TEXMNGR_VRAMUSAGE_TEXT,
    IDC_TEXMNGR_USEDTEXTURE_TEXT,

    IDC_TEXMNGR_MENU_SHOW_IN_MANAGER,
    IDC_TEXMNGR_MENU_SHOW_PROPERTIES,
    IDC_TEXMNGR_MENU_AUTO_REFRESH,


    //---- CAMERA IMAGER IDS ----
    IDC_CAMERAIMAGER_BEGIN,
    IDC_CAMERAIMAGER_EXPOSURE,
    IDC_CAMERAIMAGER_FSTOP,
    IDC_CAMERAIMAGER_ISO,
    IDC_CAMERAIMAGER_GAMMA,
    IDC_CAMERAIMAGER_GAMMA_BEFORE,
    IDC_CAMERAIMAGER_ORDER,
    IDC_CAMERAIMAGER_HCOMPRESSION,
    IDC_CAMERAIMAGER_RESPONSE,
    IDC_CAMERAIMAGER_NATURAL_RESPONSE,
    IDC_CAMERAIMAGER_VIGNETTING,
    IDC_CAMERAIMAGER_SATURATION,
    IDC_CAMERAIMAGER_HOTPIXEL,
    IDC_CAMERAIMAGER_PREMULTIALPHA,
    IDC_CAMERAIMAGER_DIS_PARTALPHA,
    IDC_CAMERAIMAGER_MINDISPLAYSAMPLES,
    IDC_CAMERAIMAGER_MAX_TM_INTERVAL,
    IDC_CAMERAIMAGER_DITHER,
    IDC_CAMERAIMAGER_WHITESATURATION,
    IDC_CAMERAIMAGER_WHITEBALANCE,
    IDC_CAMERAIMAGER_CUSTOMLUT,
    IDC_CAMERAIMAGER_CUSTOMLUT_STR,
    IDC_CAMERAIMAGER_CUSTOMLUT_BTN,
    IDC_CAMERAIMAGER_ENABLE_DENOISING,
    IDC_CAMERAIMAGER_DENOISE_MINSAMP,
    IDC_CAMERAIMAGER_DENOISE_ON_COMP,
    IDC_CAMERAIMAGER_DENOISE_VOLUMES,
    IDC_CAMERAIMAGER_DENOISE_INTERVAL,
    IDC_CAMERAIMAGER_DENOISE_BLEND,
    IDC_CAMERAIMAGER_END,

    IDC_TOON_SHADOW_BEGIN,
    IDC_TOON_SHADOW_AMBIENT,
    IDC_PT_TOON_SHADOW_AMBIENT,
    IDC_PMC_TOON_SHADOW_AMBIENT,
    IDC_TOON_SHADOW_END,

    IDC_POSTPROC_BEGIN,
    IDC_POSTPROC_ENABLE,
    IDC_POSTPROC_BLOOMPOWER,
    IDC_POSTPROC_GLAREPOWER,
    IDC_POSTPROC_RAYAMOUNT,
    IDC_POSTPROC_GLAREANGLE,
    IDC_POSTPROC_GLAREBLUR,
    IDC_POSTPROC_SPECTRAL_INTENSITY,
    IDC_POSTPROC_SPECTRAL_SHIFT,
    IDC_POSTPROC_END,

    //---- DIRECTLIGHTING IDS ----
    IDC_DIRECTLIGHT_BEGIN,
    IDC_DIRECTLIGHT_DIFFUSEDEPTH,
	IDC_DIRECTLIGHT_SPECDEPTH, 
	IDC_DIRECTLIGHT_GLOSDEPTH,
	IDC_DIRECTLIGHT_AODIST,
    IDC_DIRECTLIGHT_AO_TEXTURE,
	IDC_DIRECTLIGHT_RAYEPSILON, 
	IDC_DIRECTLIGHT_MAXSAMPLES, 
	IDC_DIRECTLIGHT_FILTERSIZE, 
	IDC_DIRECTLIGHT_ALPHACHAN, 
	IDC_DIRECTLIGHT_KEEPENV,
	IDC_DIRECTLIGHT_ALPHASHADOW, 
    IDC_DIRECTLIGHT_IRRADIANCE_MODE,
    IDC_DIRECTLIGHT_PTERMPOWER,
	IDC_DIRECTLIGHT_GIMODE, 
    IDC_DIRECTLIGHT_COHERENT,
    IDC_DIRECTLIGHT_VOL_STEP_LEN,
    IDC_DIRECTLIGHT_STAT_NOISE,
    IDC_DIRECTLIGHT_PARALLEL_SAMPLES,
    IDC_DIRECTLIGHT_MAX_TILE_SAMPLES,
    IDC_DIRECTLIGHT_MIN_NET_TRAFFIC,

    IDC_DIRECTLIGHT_LIGHTS_GRP,
    IDC_DIRECTLIGHT_AI_LIGHTS,
    IDC_DIRECTLIGHT_AI_LIGHT_UPDATE,
    IDC_DIRECTLIGHT_AI_LIGHT_STRENGTH,
    IDC_DIRECTLIGHT_LIGHT_IDs_ACTION,
    IDC_DIRECTLIGHT_LIGHT_ID_S,
    IDC_DIRECTLIGHT_LIGHT_ID_E,
    IDC_DIRECTLIGHT_LIGHT_ID_1,
    IDC_DIRECTLIGHT_LIGHT_ID_2,
    IDC_DIRECTLIGHT_LIGHT_ID_3,
    IDC_DIRECTLIGHT_LIGHT_ID_4,
    IDC_DIRECTLIGHT_LIGHT_ID_5,
    IDC_DIRECTLIGHT_LIGHT_ID_6,
    IDC_DIRECTLIGHT_LIGHT_ID_7,
    IDC_DIRECTLIGHT_LIGHT_ID_8,
    IDC_DIRECTLIGHT_LIGHTLINK_INVERT_S,
    IDC_DIRECTLIGHT_LIGHTLINK_INVERT_E,
    IDC_DIRECTLIGHT_LIGHTLINK_INVERT_1,
    IDC_DIRECTLIGHT_LIGHTLINK_INVERT_2,
    IDC_DIRECTLIGHT_LIGHTLINK_INVERT_3,
    IDC_DIRECTLIGHT_LIGHTLINK_INVERT_4,
    IDC_DIRECTLIGHT_LIGHTLINK_INVERT_5,
    IDC_DIRECTLIGHT_LIGHTLINK_INVERT_6,
    IDC_DIRECTLIGHT_LIGHTLINK_INVERT_7,
    IDC_DIRECTLIGHT_LIGHTLINK_INVERT_8,
    IDC_DIRECTLIGHT_ADAPTIVE_SAMPLING,
    IDC_DIRECTLIGHT_ASAMP_NOISE_THRESH,
    IDC_DIRECTLIGHT_ASAMP_EXPOSURE,
    IDC_DIRECTLIGHT_ASAMP_MIN_SAMPLES,
    IDC_DIRECTLIGHT_ASAMP_GRP_PIXELS,
    IDC_DIRECTLIGHT_END,

    //---- PATHTRACING KERNEL IDS ----
    IDC_PATHTRACE_BEGIN,
    IDC_PATHTRACE_DIFFUSEDEPTH,
    IDC_PATHTRACE_GLOSSYDEPTH,
    IDC_PATHTRACE_SPECDEPTH,
    IDC_PATHTRACE_PTERMPOWER,
    IDC_PATHTRACE_RAYEPSILON,
    IDC_PATHTRACE_MAXSAMPLES,
    IDC_PATHTRACE_FILTERSIZE,
    IDC_PATHTRACE_ALPHASHADOW,
    IDC_PATHTRACE_ALPHACHAN,
    IDC_PATHTRACE_KEEPENV,
    IDC_PATHTRACE_CAUSTICBLUR,
    IDC_PATHTRACE_GICLAMP,
    IDC_PATHTRACE_IRRADIANCE_MODE,
    IDC_PATHTRACE_COHERENT,
    IDC_PATHTRACE_STAT_NOISE,
    IDC_PATHTRACE_VOL_STEP_LEN,
    IDC_PATHTRACE_PARALLEL_SAMPLES,
    IDC_PATHTRACE_MAX_TILE_SAMPLES,
    IDC_PATHTRACE_MIN_NET_TRAFFIC,

    IDC_PATHTRACE_LIGHTS_GRP,
    IDC_PATHTRACE_AI_LIGHTS,
    IDC_PATHTRACE_AI_LIGHT_UPDATE,
    IDC_PATHTRACE_AI_LIGHT_STRENGTH,
    IDC_PATHTRACE_LIGHT_IDs_ACTION,
    IDC_PATHTRACE_LIGHT_ID_S,
    IDC_PATHTRACE_LIGHT_ID_E,
    IDC_PATHTRACE_LIGHT_ID_1,
    IDC_PATHTRACE_LIGHT_ID_2,
    IDC_PATHTRACE_LIGHT_ID_3,
    IDC_PATHTRACE_LIGHT_ID_4,
    IDC_PATHTRACE_LIGHT_ID_5,
    IDC_PATHTRACE_LIGHT_ID_6,
    IDC_PATHTRACE_LIGHT_ID_7,
    IDC_PATHTRACE_LIGHT_ID_8,
    IDC_PATHTRACE_LIGHTLINK_INVERT_S,
    IDC_PATHTRACE_LIGHTLINK_INVERT_E,
    IDC_PATHTRACE_LIGHTLINK_INVERT_1,
    IDC_PATHTRACE_LIGHTLINK_INVERT_2,
    IDC_PATHTRACE_LIGHTLINK_INVERT_3,
    IDC_PATHTRACE_LIGHTLINK_INVERT_4,
    IDC_PATHTRACE_LIGHTLINK_INVERT_5,
    IDC_PATHTRACE_LIGHTLINK_INVERT_6,
    IDC_PATHTRACE_LIGHTLINK_INVERT_7,
    IDC_PATHTRACE_LIGHTLINK_INVERT_8,
    IDC_PATHTRACE_ADAPTIVE_SAMPLING,
    IDC_PATHTRACE_ASAMP_NOISE_THRESH,
    IDC_PATHTRACE_ASAMP_EXPOSURE,
    IDC_PATHTRACE_ASAMP_MIN_SAMPLES,
    IDC_PATHTRACE_ASAMP_GRP_PIXELS,
    IDC_PATHTRACE_END,

    //---- PMC KERNEL IDS ----
    IDC_PMC_BEGIN,
    IDC_PMC_DIFDEPTH,
    IDC_PMC_GLOSSY_DEPTH,
    IDC_PMC_PTERMPOWER,
    IDC_PMC_RAYEPSILON,
    IDC_PMC_EXPLOSTRENGTH,
    IDC_PMC_DLIMPORTANCE,
    IDC_PMC_MAXREJECTS,
    IDC_PMC_MAXSAMPLES,
    IDC_PMC_FILTERSIZE,
    IDC_PMC_ALPHASHADOW,
    IDC_PMC_ALPHACHAN,
    IDC_PMC_KEEPENV,
    IDC_PMC_CAUSTICBLUR,
    IDC_PMC_PARALELISM,
    IDC_PMC_PARALLEL_SAMPLES,
    IDC_PMC_WORK_CHUNK_SIZE,
    IDC_PMC_VOL_STEP_LEN,
    IDC_PMC_GICLAMP,
    IDC_PMC_IRRADIANCE_MODE,
    IDC_PMC_LIGHTS_GRP,
    IDC_PMC_AI_LIGHTS,
    IDC_PMC_AI_LIGHT_UPDATE,
    IDC_PMC_AI_LIGHT_STRENGTH,
    IDC_PMC_LIGHT_IDs_ACTION,
    IDC_PMC_LIGHT_ID_S,
    IDC_PMC_LIGHT_ID_E,
    IDC_PMC_LIGHT_ID_1,
    IDC_PMC_LIGHT_ID_2,
    IDC_PMC_LIGHT_ID_3,
    IDC_PMC_LIGHT_ID_4,
    IDC_PMC_LIGHT_ID_5,
    IDC_PMC_LIGHT_ID_6,
    IDC_PMC_LIGHT_ID_7,
    IDC_PMC_LIGHT_ID_8,
    IDC_PMC_LIGHTLINK_INVERT_S,
    IDC_PMC_LIGHTLINK_INVERT_E,
    IDC_PMC_LIGHTLINK_INVERT_1,
    IDC_PMC_LIGHTLINK_INVERT_2,
    IDC_PMC_LIGHTLINK_INVERT_3,
    IDC_PMC_LIGHTLINK_INVERT_4,
    IDC_PMC_LIGHTLINK_INVERT_5,
    IDC_PMC_LIGHTLINK_INVERT_6,
    IDC_PMC_LIGHTLINK_INVERT_7,
    IDC_PMC_LIGHTLINK_INVERT_8,

    IDC_PMC_END,

    //---- DEEP CHANNEL IDS ----
    IDC_INFOCHAN_BEGIN,
    IDC_INFOCHAN_TYPE,
    IDC_INFOCHAN_ENABLE_DRAYTRACE,
    IDC_INFOCHAN_MAXSAMPLES,
    IDC_INFOCHAN_FILTERSIZE,
    IDC_INFOCHAN_ZDEPTHMAX,
    IDC_INFOCHAN_ALPHACHANNEL,
    IDC_INFOCHAN_RAYEPSILON,
    IDC_INFOCHAN_OPACITY_THRESH,
    IDC_INFOCHAN_UVMAX,
    IDC_INFOCHAN_UV_SET,
    IDC_INFOCHAN_MAXSPEED,
    IDC_INFOCHAN_WIRE,
    IDC_INFOCHAN_ENABLE_BUMPNORMAL,
    IDC_INFOCHAN_ENABLE_WIRE_BACKLGHT,
    IDC_INFOCHAN_AODIST,
    IDC_INFOCHAN_AO_ALPHASHD,
    IDC_INFOCHAN_PARALLEL_SAMPLES,
    IDC_INFOCHAN_MAX_TILE_SAMPLES,
    IDC_INFOCHAN_MIN_NET_TRAFFIC,
    IDC_INFOCHAN_END,



    IDC_PASS_BEGIN,
    IDC_PASS_RAW,
    IDC_PASS_EMITTERS,
    IDC_PASS_ENV,
    IDC_PASS_SHADOW,
    IDC_PASS_IRRADIANCE,
    IDC_PASS_LIGHT_DIRECTION,
    IDC_PASS_VOLUME,
    IDC_PASS_VOLUME_MASK,
    IDC_PASS_VOLUME_EMISSION,
    IDC_PASS_VOLUME_Z_DEPTH_FRONT,
    IDC_PASS_VOLUME_Z_DEPTH_BACK,
    IDC_PASS_DIFFUSE,
    IDC_PASS_DIF_FILTER,
    IDC_PASS_DIFFUSE_D,
    IDC_PASS_DIFFUSE_I,

    IDC_PASS_REFLECT,
    IDC_PASS_REFLECT_D,
    IDC_PASS_REFLECT_I,
    IDC_PASS_REFLECT_FILT,
    IDC_PASS_REFRACT,
    IDC_PASS_REFRACT_FILT,
    IDC_PASS_TRANS,
    IDC_PASS_TRANS_FILT,
    IDC_PASS_SSS,
    //IDC_RENDERPASS_ROUGHNESS_TRSH,
    IDC_PASS_CAUSTIC,
    IDC_PASS_POSTPRO,
    IDC_PASS_NOISE,
    IDC_PASS_BEAUTY_DENOISER,
    IDC_PASS_DENOISED_DIFFUSE_D,
    IDC_PASS_DENOISED_DIFFUSE_I,
    IDC_PASS_DENOISED_REFLECT_D,
    IDC_PASS_DENOISED_REFLECT_I,
    IDC_PASS_DENOISED_REFRACT,
    IDC_PASS_DENOISED_REMAINDER,
    IDC_PASS_DENOISED_EMISSION,
    IDC_PASS_DENOISED_VOL_EMIS,
    IDC_PASS_DENOISED_VOLUME,
    IDC_PASS_INCLUDE_ENV,
    IDC_PASS_RL_SHADOW,
    IDC_PASS_BLACKSHD,
    IDC_PASS_COLORSHD,
    IDC_PASS_LAYERREFL,

    IDC_PASS_ENABLE_RENDERLAYER,
    IDC_PASS_DISPLAY_RENDERLAYER_ID,
    IDC_PASS_DISPLAY_RENDERLAYER_MODE,
    IDC_PASS_INVERT_RENDERLAYER,

    IDC_RENDERPASS_MININFO_STARTSMP,
    IDC_RENDERPASS_INFO_MAXSAMPLES,
    IDC_PASS_GEONORM,
    IDC_PASS_SHDNORM,
    IDC_PASS_VTXNORM,
    IDC_PASS_POSITION,
    IDC_PASS_ZDEPTH,
    IDC_PASS_MATERIALID,
    IDC_PASS_TEXTCOORD,
    IDC_RENDERPASS_UVMAX,
    IDC_RENDERPASS_MOTIONMAX,
    IDC_PASS_TANGENT,
    IDC_PASS_WIREFRAME,
    IDC_PASS_OBJECTID,
    IDC_PASS_LIGHT_PASS_ID,
    IDC_OBJ_LAYERCOLOR_ID,
    IDC_BAKEGROUP_ID,
    IDC_PASS_AO,
    IDC_PASS_MOTION,
    IDC_PASS_OPACITY,
    IDC_PASS_INFO_DIFFUSE,
    IDC_PASS_INFO_ROUGHNES,
    IDC_PASS_INFO_IOR,
    IDC_PASS_INFO_REFLECT,
    IDC_PASS_INFO_REFRACT,
    IDC_PASS_INFO_TRANSMIS,
    IDC_PASS_RENDER_LAYER_ID,
    IDC_PASS_RENDER_LAYER_MASK,
    IDC_RENDERPASS_ZDEPTHMAX,
    IDC_RENDERPASS_START_AFTERBEAUTY,
    IDC_RENDERPASS_FILTERSIZE,
    IDC_RENDERPASS_DISTPATHTRACE,
    IDC_RENDERPASS_AO_MAXSAMPLES,
    IDC_RENDERPASS_AO_DISTANCE,
    IDC_RENDERPASS_AO_ALPHASHDW,
    IDC_RENDPASS_INFO_TONEMAP,
    IDC_RENDERPASS_SHOWPASS,
    IDC_RENDERPASS_SELECT_ALLBEAUTY,
    IDC_RENDERPASS_UNSELECT_ALLBEAUTY,
    IDC_RENDERPASS_SELECT_ALLINFO,
    IDC_RENDERPASS_UNSELECT_ALLINFO,

    IDC_LIGHTPASS_AMBIENT,
    IDC_LIGHTPASS_SUNLIGHT,
    IDC_LIGHTPASS_1,
    IDC_LIGHTPASS_2,
    IDC_LIGHTPASS_3,
    IDC_LIGHTPASS_4,
    IDC_LIGHTPASS_5,
    IDC_LIGHTPASS_6,
    IDC_LIGHTPASS_7,
    IDC_LIGHTPASS_8,


    /// CAMERA IMAGER IDS
    IDC_PREVIEW_FULL_UPDATE,
    IDC_PREVIEW_MAT_UPDATE,
    IDC_PREVIEW_MESH_UPDATE,
    IDC_PREVIEW_START_FRAME,
    IDC_PREVIEW_END_FRAME,
    IDC_PREVIEW_STEP_FRAME,
    IDC_PREVIEW_FROMRENDER,
    IDC_PREVIEW_FILENAME,
    IDC_PREVIEW_FILESELECT,
    IDC_PREVIEW_SIZEW,
    IDC_PREVIEW_SIZEH,

    IDC_EXPERIMENTAL_FEATURES,

    IDC_DB_MENU_OPEN_LIVEDB_FOLDER,
    IDC_DB_MENU_OPEN_LOCALDB_FOLDER,
    IDC_DB_MENU_SELECT_LOCALDB_FOLDER,

    IDC_DB_BUTTONS_GRP,
    IDC_DB_MAIN_GRP,
    IDC_DB_ICONSIZE_GRP,
    IDC_DB_ICONSIZE_COMBO,
    IDC_DB_MATERIAL_LIST,
    IDC_DB_REFRESHLIST_BUTTON,
    IDC_DB_DOWNLOAD_BUTTON,
    IDC_DB_MAKEOFFLINE_BUTTON,
    IDC_DB_SEARCH_TEXT,
    IDC_DB_INFO_TEXT,
    IDC_DB_STATUS_TEXT,
    IDC_AO_TREEVIEW,
    IDC_LAYER_BROWSER_TREE,
    IDC_LAYER_BROWSER_LINK,
    IDC_MATERIAL_LIST,
    IDC_MATERIAL_LIST2,
    IP_SET_RUNTIMELIST,
    COL_CHECK,
    COL_NAME,

    IDC_TEXMNGR_BUTTON1,

    POPUP_RESET_OFFLINE_PREVS,
    POPUP_CREATE_NEW_CATEGORY,
    POPUP_DOWNLOAD,
    POPUP_BREAK_DOWNLOAD,
    POPUP_MAKE_OFFLINE,
    POPUP_REMOVE_OFFLINEMAT,
    POPUP_CREATE_USERCAT,
    POPUP_RENAME_USERCAT,
    POPUP_DELETE_USERCAT,
    POPUP_RENAME_USERMATERIAL,
    POPUP_DELETE_USERMATERIAL,
    POPUP_SELECTALL,
    POPUP_REPLACE_ACTIVE_MATERIAL,
    POPUP_SHOWPATH,
    IDS_CUSTOMGUISTRING,

	IDC_CUSTOM1,
	IDC_CUSTOM2,
    DLG_LISTVIEW,
    GADGET_INSERT,
    GADGET_REMOVE,
    GADGET_LISTVIEW1,
    GADGET_LISTVIEW2,
	// Dialog definitions of IDD_OCTANELIVE_DIALOG end here


  // Dialog definitions of IDD_device_dialog start here
  IDD_DEVICE_DIALOG,
  IDC_DEVICEGRP,
  IDC_DEVICE_LIST,
  IDC_DEVICE_CHECK,
  // Dialog definitions of IDD_device_dialog end here


// End of symbol definition

};

#endif
