
$( document ).ready(function() {
	
	// Wir überprüfen, ob schon registriert ist, Testzeit usw.
	var bantData = bant.resources.get('licenses');
	var bantLicense = bantData.licenses.main;
	var bExpired = bantLicense.is_expired;
	var bExtended = bantLicense.is_extended;
	var bPurchased = bantLicense.is_purchased;	
	var currentUserKey = bantLicense.key;	


	// bei clipboard
	bant.callback.clipboard.onLicenseKey = function(licenseKey){
		// console.log(licenseKey);
		$('#status-trial input').val( licenseKey );
		$('#status-trial ash-input').attr('class', 'serial-ok');			
	}

	// Bei Serialeingabe: Statusicons ändern
	$('#serial').on('input', function() {
		var myKey = document.getElementById('serial').value;
		bantLicense.key = myKey;
		var myStatus = 'serial-idle';
		
//		var lic = {key: myKey};

		if (bant.license.isValid(bantLicense)) {
			myStatus = 'serial-ok';
		}
		else {
			if ( myKey.length > 5) {
				myStatus = 'serial-wrong';
			}
		}

		$('#status-trial ash-input').attr('class', myStatus);

	});
	
	
	
	// Ein Klick auf den "Aktivieren"-Button
	$('#status-trial a.hero').click(function() {
		if (bPurchased) {
			// Das Programm ist schon gekauft
			// Einfach den Dialog schließen
			bant.dialog.close(this, 'cancel');
		} 
		else {
			// Lizenzkey abfragen und auf Gültigkeit testen
			bantLicense.key = document.getElementById("serial").value;
					
			console.log( document.getElementById("serial").value );
			console.log( bantLicense.key );

			
			if (bantLicense.key == currentUserKey){
				console.log( "Anmerkung: Der eingegebene Key entspricht einem bereits eingegebenen Key, z.B. Trialkey = Trialkey." );
				bant.dialog.close(this, 'cancel');
				return;
			}
			
			// Lizenzkey Screibweise gültig?
			if (bant.license.isValid(bantLicense)) {
				console.log( bantLicense );
				var newLicense = bant.license.update( bantLicense );
				console.log( newLicense );
				
				// Kein Schlüssel zurückgeliefert, falsches Programm
				if (!newLicense.key){
					console.log('Anmerkung: Nicht näher definierter Fehler mit dem Schlüssel. Höchstwahrscheinlich Key für ein anderes Programm.');
					bant.dialog.close(this, 'cancel');
					return;
				}

				if (newLicense.error.code != 0){
					document.body.className = 'status-' + newLicense.error.code;
				}
				else{
					
					if (newLicense.is_purchased){
						document.body.className = 'status-thx';
					}
					else{
						if (newLicense.is_extended){
							document.body.className = 'status-extended-thx';
							console.log("whee");
						}
						else{
							console.log('verdammt');
						}
					}	
				}
			}

			//			
/*				
			bant.callback.license.onError = function(code, reason){
				document.body.className = 'status-' + code;
			}

			// Programm updaten
			if (bant.license.update( bantLicense ) == true){
				// Weiter zum Abschluss-Screen
				document.body.className = 'status-thx';
			}
			*/
		}
	});
	
	

		

	
	// Wenn der User bereits aktiviert hat	
	if (bPurchased){
		// Serial in Inputfeld einfügen und Eingabe verhindern
		$('#status-purchased input').val( bantLicense.key );

		// Zur Bereits-Aktiviert-Seite wechseln
		document.body.className = 'status-purchased';
	}
	
	
});