// app 模块是为了控制整个应用的生命周期设计的。
// BrowserWindow 类让你有创建一个浏览器窗口的权力。
const {app, BrowserWindow, Menu, MenuItem, ipcMain} = require('electron');
const nativeImage = require('electron').nativeImage;
var overlay = nativeImage.createFromPath('icon.png');

const mainWindowURL = 'https://class.acagrid.com/pc/comment?win_app=1&from=exe_office';

let mainWindow;
let mainMenu;

//api:https://wizardforcel.gitbooks.io/electron-doc/content/api/browser-window.html
function createWindow () {
    // console.log("createWindow......"); 

    mainWindow = new BrowserWindow({
      // fullscreen: true,
      width: 1300,
      height: 1000,
      maximizable: true, //支持最大化
      show: false,   //为了让初始化窗口显示无闪烁，先关闭显示，等待加载完成后再显示。
      // icon: "https://medical.3vyd.com/alk/prod/pc/icon/icon.ico"
      webPreferences: {
        nodeIntegration: true
      },
    })

    // Emitted when the window is closed.
    mainWindow.on('closed', function () {
      // console.log("closed......"); 
      mainWindow = null;
    })
    // mainWindow.once('ready-to-show', () => {    //开启这个以后点击了图片虽然没有白屏，但是会感觉不到点了没点
    mainWindow.maximize();    //打开时最大化打开，不是全屏，保留状态栏
    // })

  // mainWindow.setOverlayIcon(overlay, "医敏")
  mainWindow.setTitle("AA班级助手");
  // mainWindow.setAutoHideMenuBar(true);//自动隐藏菜单
  mainWindow.loadURL(mainWindowURL);
  // app.commandLine.appendSwitch("--disable-http-cache")   禁用缓存
  // mainWindow.webContents.openDevTools({mode:'bottom'});

  mainMenu = new Menu()
  mainMenu.append(new MenuItem({
    label: '后退',
    click: () => { 
      // console.log('go back') 
      if (mainWindow.webContents.canGoBack()) {
        mainWindow.webContents.goBack()
      }
    }
  }))
  mainMenu.append(new MenuItem({
    label: '前进',
    click: () => { 
      // console.log('go forward') 
      if (mainWindow.webContents.canGoForward()) {
        mainWindow.webContents.goForward()
      }
    }
  }))
  
  Menu.setApplicationMenu(mainMenu)

  mainWindow.show();
}

app.on('ready', function() {
  // console.log("ready......");
  createWindow();
});

// Quit when all windows are closed.
app.on('window-all-closed', function () {
  // On OS X it is common for applications and their menu bar
  // to stay active until the user quits explicitly with Cmd + Q
  if (process.platform !== 'darwin') {
    app.quit();
  }
})
