#!/usr/bin/python2.7
# -*- coding: utf-8 -*-

"""
**Project Name:**      MakeHuman

**Product Home Page:** http://www.makehuman.org/

**Code Home Page:**    https://bitbucket.org/MakeHuman/makehuman/

**Authors:**           Thomas Larsson

**Copyright(c):**      MakeHuman Team 2001-2014

**Licensing:**         AGPL3 (http://www.makehuman.org/doc/node/the_makehuman_application.html)

    This file is part of MakeHuman (www.makehuman.org).

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

**Coding Standards:**  See http://www.makehuman.org/node/165

Abstract
--------
Fbx headers
"""

from . import fbx_skeleton
from . import fbx_mesh
from . import fbx_deformer
from . import fbx_material
from . import fbx_anim


def writeHeader(fp, filepath):
    import datetime
    today = datetime.datetime.now()

    fp.write("""; FBX 7.3.0 project file
; Exported from MakeHuman TM (www.makehuman.org)
; ----------------------------------------------------

FBXHeaderExtension:  {
    FBXHeaderVersion: 1003
    FBXVersion: 7300
""" +
"""
    CreationTimeStamp:  {
        Version: 1000
        Year: %d
        Month: %d
        Day: %d
        Hour: %d
        Minute: %d
        Second: %d
        Millisecond: %d
    }
""" % (int(today.strftime('%Y')), int(today.strftime('%m')), int(today.strftime('%d')), int(today.strftime('%H')), int(today.strftime('%M')), int(today.strftime('%S')), int(float(today.strftime('%f'))/1000)) +
"""
    Creator: "FBX SDK/FBX Plugins version 2013.3"
    SceneInfo: "SceneInfo::GlobalInfo", "UserData" {
        Type: "UserData"
        Version: 100
        MetaData:  {
            Version: 100
            Title: ""
            Subject: ""
            Author: "www.makehuman.org"
            Keywords: ""
            Revision: ""
            Comment: ""
        }
        Properties70:  {
""" +
'           P: "DocumentUrl", "KString", "Url", "", "%s"\n' % filepath +
'           P: "SrcDocumentUrl", "KString", "Url", "", "%s"\n' % filepath +
"""
            P: "Original", "Compound", "", ""
            P: "Original|ApplicationVendor", "KString", "", "", ""
            P: "Original|ApplicationName", "KString", "", "", ""
            P: "Original|ApplicationVersion", "KString", "", "", ""
            P: "Original|DateTime_GMT", "DateTime", "", "", ""
            P: "Original|FileName", "KString", "", "", ""
            P: "LastSaved", "Compound", "", ""
            P: "LastSaved|ApplicationVendor", "KString", "", "", ""
            P: "LastSaved|ApplicationName", "KString", "", "", ""
            P: "LastSaved|ApplicationVersion", "KString", "", "", ""
            P: "LastSaved|DateTime_GMT", "DateTime", "", "", ""
        }
    }
}
GlobalSettings:  {
    Version: 1000
    Properties70:  {
        P: "UpAxis", "int", "Integer", "",1
        P: "UpAxisSign", "int", "Integer", "",1
        P: "FrontAxis", "int", "Integer", "",2
        P: "FrontAxisSign", "int", "Integer", "",1
        P: "CoordAxis", "int", "Integer", "",0
        P: "CoordAxisSign", "int", "Integer", "",1
        P: "OriginalUpAxis", "int", "Integer", "",-1
        P: "OriginalUpAxisSign", "int", "Integer", "",1
        P: "UnitScaleFactor", "double", "Number", "",10
        P: "OriginalUnitScaleFactor", "double", "Number", "",1
        P: "AmbientColor", "ColorRGB", "Color", "",0,0,0
        P: "DefaultCamera", "KString", "", "", "Producer Perspective"
        P: "TimeMode", "enum", "", "",0
        P: "TimeSpanStart", "KTime", "Time", "",0
        P: "TimeSpanStop", "KTime", "Time", "",46186158000
        P: "CustomFrameRate", "double", "Number", "",-1
    }
}

; Documents Description
;------------------------------------------------------------------

Documents:  {
    Count: 1
    Document: 39112896, "Scene", "Scene" {
        Properties70:  {
            P: "SourceObject", "object", "", ""
            P: "ActiveAnimStackName", "KString", "", "", ""
            P: "COLLADA_ID", "KString", "", "", "Scene"
        }
        RootNode: 0
    }
}

; Document References
;------------------------------------------------------------------

References:  {
}
""")


def writeObjectDefs(fp, meshes, skel, config):
    count = (
              fbx_skeleton.countObjects(skel) +
              fbx_mesh.countObjects(meshes) +
              fbx_deformer.countObjects(meshes, skel) +
              #fbx_anim.countObjects() +
              1
            )
    if config.useMaterials:
        count += fbx_material.countObjects(meshes)

    fp.write(
"""
; Object definitions
;------------------------------------------------------------------

Definitions:  {

    Version: 100
""" +
'    Count: %d' % count +
"""
    ObjectType: "GlobalSettings" {
        Count: 1
    }
""")


def writeObjectProps(fp):
    fp.write(
"""
; Object properties
;------------------------------------------------------------------

Objects:  {
""")


def writeLinks(fp):
    fp.write(
"""
; Object connections
;------------------------------------------------------------------

Connections:  {
""")


def writeTakes(fp):
    fp.write(
"""
;Takes section
;----------------------------------------------------

Takes:  {
    Current: ""
}
""")
