#pragma once

#ifndef ZHL_SDK
#define ZHL_SDK

//údllĿڲʹ__declspec(dllexport)
//dllĿⲿʹʱ__declspec(dllimport)
//DLL_IMPLEMENTsimpledll.cppж
//#ifdef DLL_IMPLEMENT  
#define DLL_API EXTERN_C __declspec(dllexport)  
//#else  
//#define DLL_API EXTERN_C __declspec(dllimport)  
//#endif  

#include <windows.h>

#define MAX_PATH_LEN	1024

typedef void (*pRIPReadFun)(byte* ripData, int ripDataLen, int lineByteWidth, int imageWidth, int imageHeight, int pageIndex, char* cnt, int effectPts);
typedef void(*pRGBReadFun)(byte* ripData, int ripDataLen, int imageWidth, int imageHeight, int pageIndex, char* cnt);

typedef enum
{
	RET_OK = 0,	//޴
	RET_ERROR = -1,	//д
	RET_BUSY = -2,	//æԺ

}eRET;

DLL_API eRET WINAPI ZL_Initialization(char* programDir);
DLL_API eRET WINAPI ZL_Release();
DLL_API eRET WINAPI ZL_OpenDoc(char* filePath, char* password);
DLL_API eRET WINAPI ZL_CreateDoc(double paperWidth, double paperHeight);
DLL_API eRET WINAPI ZL_CloseDoc();
DLL_API eRET WINAPI ZL_SaveDoc(char* filePath);
DLL_API eRET WINAPI ZL_SetLayout(double marginTop, double marginRight, double marginBottom, double marginLeft, int numberOfRows, int numberOfColumns, double labelWidth, double labelHeight, double labelSpanH, double labelSpanV, int feedDirection);
DLL_API eRET WINAPI ZL_SaveLabelImage(char* savePath);
DLL_API eRET WINAPI ZL_OutputToPrinter(char* printer, char* txtFile, int startPage, int endPage, bool isCustomOutput);
DLL_API eRET WINAPI ZL_OutputToPDF(char* savePath, bool useCMYK, char* txtFile, int zipLevel, int startPage, int endPage, bool isCustomOutput);
DLL_API eRET WINAPI ZL_outputToTIFF(char* savePath, char* txtFile, int zipLevel, int dpi, int startPage, int endPage, bool isCustomOutput);
DLL_API eRET WINAPI ZL_OutputToImage(char* saveDir, int extType, int dpi, char* txtFile, int startPage, int endPage, bool isCustomOutput);
DLL_API eRET WINAPI ZL_StopOutput();
DLL_API bool WINAPI ZL_IsOutputing();
DLL_API int WINAPI ZL_InsertLine(double* pointXs, double* pointYs, int pointCount, double lineWidth, int lineStyle, int lineColor, int lineType);
DLL_API int WINAPI ZL_InsertPolygon(double* pointXs, double* pointYs, int pointCount, double lineWidth, int lineStyle, int lineColor, int fillColor, double angle);
DLL_API int WINAPI ZL_InsertText(double x, double y, double width, double height, char* text, int textMode, bool isMirror, char* fontName, double fontSize, int fontStyle, int fontColor, int alignment, double wordSpacing, double rowSpacing, double angle);
DLL_API int WINAPI ZL_InsertBarcode(double x, double y, double width, double height, char* data, char* textFormat, int barcodeType, int codePage, double moduleWidth, bool optimize, bool isMirror, int barColor, int backgroundColor, char* fontName, double fontSize, int fontStyle, int fontColor, int alignment, double wordSpacing, double angle);
DLL_API int WINAPI ZL_InsertImage(double x, double y, double width, double height, char* imagePath, int scaleType, double angle);
DLL_API eRET WINAPI ZL_DeleteShape(int shapeId);
DLL_API eRET WINAPI ZL_SetDataCustom(int shapeId, char* data);
DLL_API eRET WINAPI ZL_StartOutputCustom();
DLL_API eRET WINAPI ZL_PdfTool(char* saveDirOrPath, char* file1, char* file2, int actionType, bool maximumPages, bool pagePad, int pagesPerBatch);

//add by lyz 20180912
DLL_API int WINAPI ZL_GetTotalPages();
DLL_API eRET WINAPI ZL_GetPageSize(int xDPI, int yDPI, int& width, int& height);
DLL_API eRET WINAPI ZL_SetRIPReadCallback(pRIPReadFun RIPReadFun);
DLL_API eRET WINAPI ZL_SetRGBReadCallback(pRGBReadFun RIPReadFun);
DLL_API eRET WINAPI ZL_OutputToRIP(int startPage, int endPage, int xDPI, int yDPI, double printUnitWidth, int colorCount, int colorDepth, int threshold, bool isCustomOutput);
DLL_API eRET WINAPI ZL_OutputToRGB(int startPage, int endPage, int xDPI, int yDPI, bool isCustomOutput);
DLL_API eRET WINAPI ZL_Test();
#endif