unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    Function setShapeData(shapeId:Integer;data:String): Boolean;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  zlDir:String = 'C:\\Program Files (x86)\\ǩӡ\\';
  docFile:String = 'd:\\demo.zhl';
  labelImg:String = 'd:\\demo.png';
  outputPdf:String = 'd:\\outputDemo.pdf';
  outputPdfCustom:String = 'd:\\outputCustomDemo.pdf';
  overlayPdf:String = 'd:\\overlayDemo.pdf';
  demoText:String = '   ǩӡ(LabelPainter)һǿרҵõɹߡάǩӡߡڣαǩǩƷǩмǩҽҩǩ鱦ǩ֤ȵӡ\n' + '   ֧ͨӡīӡӡָ֧ӡˢ豸֧RGBCMYK(רɫ)HSLHSVɫģʽPDFʸͼ롢һPDFĵȡ';
  barcode1d, barcode2d, singleLineText, multiLineText, rect:Integer;
  pageCount:Integer = 10;
  pointXs:array[0..3] of Double = (0.8, 18.5, 18.5, 0.8);
  pointYs:array[0..3] of Double = (19.3, 19.3, 22.2, 22.2);

implementation

{$R *.dfm}

uses LabelPainterSDK;
Function TForm1.setShapeData(shapeId:Integer;data:String): Boolean;
var
  rt:eRET;
begin
  rt := ZL_SetDataCustom(shapeId, data);
  While RET_BUSY = rt do
  begin
    rt := ZL_SetDataCustom(shapeId, data);
  end;
  result:=(RET_OK = rt)
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  rt:eRET;
  i:Integer;
begin
  /////////////////////////////////////////////////////////////////
  ///                        ʾ                   ///////
  /////////////////////////////////////////////////////////////////
  //ʼ
  rt := ZL_Initialization(zlDir);
  if (rt <> RET_OK) then
  begin
    ShowMessage('ʼʧ');
  end;

  //½ĵ
  rt := ZL_CreateDoc(60, 30);
  if (rt <> RET_OK) then
  begin
    ShowMessage('ĵʧ');
  end;

  //ò
  rt := ZL_SetLayout(0, 0, 0, 0, 1, 1, -1, -1, -1, -1, 1);
  if (rt <> RET_OK) then
  begin
    ShowMessage('òʧ');
  end;

  //ά
  barcode2d := ZL_InsertBarcode(1.6, 1.9, 16.1, 16.1, 'http://www.tiaomaruanjian.com/', '', 58, 6, 0, false, false, RGB(0, 0, 0), RGB(255, 255, 255), '', 0, 0, 0, 0, 0, 0);
  if (barcode2d < 1) then
  begin
    ShowMessage('ͼβʧ');
  end;

  //
  rect := ZL_InsertPolygon(@pointXs[0], @pointYs[0], 4, 0.2, 1, RGB(128, 128, 128), RGB(255, 255, 255), 0);
  if (rect < 1) then
  begin
    ShowMessage('ͼβʧ');
  end;
  //SetLength(@pointXs, 0);
  //SetLength(@pointYs, 0);

  //뵥ı
  singleLineText := ZL_InsertText(1.2, 18.9, 16.7, 3.3, 'ǩӡ', 0, false, '΢ź', 6, 0, RGB(255, 0, 0), 0, 0.1, 0, 0);
  if (singleLineText < 1) then
  begin
    ShowMessage('ͼβʧ');
  end;

  //ı
  multiLineText := ZL_InsertText(19.8, 1.0, 38.9, 28.2, demoText, 1, false, '', 5, 0, RGB(0, 0, 0), 0, 0.1, 0.6, 0);
  if (multiLineText < 1) then
  begin
    ShowMessage('ͼβʧ');
  end;

  //ǩͼƬ
  rt := ZL_SaveLabelImage(labelImg);
  if (rt <> RET_OK) then
  begin
    ShowMessage('ǩͼƬʧ');
  end;

  //ֱ
  ZL_OutputToPDF(outputPdf, false, '', 0, 1, 10, false);
  if (rt <> RET_OK) then
  begin
    ShowMessage('ĵʧ');
  end;

  //ĵ
  rt := ZL_SaveDoc(docFile);
  if (rt <> RET_OK) then
  begin
    ShowMessage('ĵʧ');
  end;

  //رĵ
  rt := ZL_CloseDoc();
  if (rt <> RET_OK) then
  begin
    ShowMessage('رĵʧ');
  end;


  /////////////////////////////////////////////////////////////////
  ///                        Զʾ                 ///////
  /////////////////////////////////////////////////////////////////
  //ĵ
  rt := ZL_OpenDoc(docFile, '');
  if (rt <> RET_OK) then
  begin
    ShowMessage('ĵʧ');
  end;

  //
  barcode1d := ZL_InsertBarcode(1.0, 23.3, 17, 5.3, '123456', '??? ???', 20, 6, 0, false, false, RGB(0, 0, 0), RGB(255, 255, 255), '΢ź', 6, 0, RGB(0, 0, 255), 1, 0, 0);
  if (barcode1d < 1) then
  begin
    ShowMessage('ͼβʧ');
  end;

  //ɾͼ
  rt := ZL_DeleteShape(rect);
  if (rt <> RET_OK) then
  begin
    ShowMessage('ɾͼʧ');
  end;
  rt := ZL_DeleteShape(multiLineText);
  if (rt <> RET_OK) then
  begin
    ShowMessage('ɾͼʧ');
  end;
  rt := ZL_DeleteShape(singleLineText);
  if (rt <> RET_OK) then
  begin
    ShowMessage('ɾͼʧ');
  end;
  rt := ZL_DeleteShape(barcode2d);
  if (rt <> RET_OK) then
  begin
    ShowMessage('ɾͼʧ');
  end;

  //Զ
  rt := ZL_OutputToPDF(outputPdfCustom, false, '', 0, 1, 10, true);
  if (rt <> RET_OK) then
  begin
    ShowMessage('Զʧ');
  end
  else
  begin
    //ҳֵ
    for i:= 1 to pageCount do
    begin
      //ͼθֵ
      if (false = setShapeData(barcode1d, Format('%.6d', [i]))) then
      begin
        ShowMessage('ͼθֵʧ');
        break;
      end;

      //ǰҳ
      rt := ZL_StartOutputCustom();
      if (rt <> RET_OK) then
      begin
        ShowMessage('ǰҳʧ');
        break;
      end;
    end;

    //ֹͣ
    rt := ZL_StopOutput();
    if (rt <> RET_OK) then
    begin
      ShowMessage('ֹͣʧ');
    end;
  end;

  //رĵ
  rt := ZL_CloseDoc();
  if (rt <> RET_OK) then
  begin
    ShowMessage('رĵʧ');
  end;


  /////////////////////////////////////////////////////////////////
  ///                        PDFʾ                  ///////
  /////////////////////////////////////////////////////////////////
  rt := ZL_PdfTool(overlayPdf, outputPdfCustom, outputPdf, 3, true, false, 1);
  if (rt <> RET_OK) then
  begin
    ShowMessage('PDFĵʧ');
  end;


  //ͷԴ
  rt := ZL_Release();
  if (rt <> RET_OK) then
  begin
    ShowMessage('ͷԴʧ');
  end;
end;

end.
