unit LabelPainterSDK;



interface
type eRET = (RET_OK = 0, RET_ERROR = -1, RET_BUSY = -2);

function ZL_Initialization(programDir:String): eRET; stdcall;
function ZL_Release(): eRET; stdcall;
function ZL_OpenDoc(filePath:String; password:String): eRET; stdcall;
function ZL_CreateDoc(paperWidth:Double; paperHeight:Double): eRET; stdcall;
function ZL_CloseDoc(): eRET; stdcall;
function ZL_SaveDoc(filePath:String): eRET; stdcall;
function ZL_SetLayout(marginTop:Double; marginRight:Double; marginBottom:Double; marginLeft:Double; numberOfRows:Integer; numberOfColumns:Integer; labelWidth:Double; labelHeight:Double; labelSpanH:Double; labelSpanV:Double; feedDirection:Integer): eRET; stdcall;
function ZL_SaveLabelImage(savePath:String): eRET; stdcall;
function ZL_OutputToPrinter(printer:String; txtFile:String; startPage:Integer; endPage:Integer; isCustomOutput:Boolean): eRET; stdcall;
function ZL_OutputToPDF(savePath:String; useCMYK:Boolean; txtFile:String; zipLevel:Integer; startPage:Integer; endPage:Integer; isCustomOutput:Boolean): eRET; stdcall;
function ZL_outputToTIFF(savePath:String; txtFile:String; zipLevel:Integer; dpi:Integer; startPage:Integer; endPage:Integer; isCustomOutput:Boolean): eRET; stdcall;
function ZL_OutputToImage(saveDir:String; extType:Integer; dpi:Integer; txtFile:String; startPage:Integer; endPage:Integer; isCustomOutput:Boolean): eRET; stdcall;
function ZL_StopOutput(): eRET; stdcall;
function ZL_IsOutputing(): Boolean; stdcall;
function ZL_InsertLine(pointXs:PDouble; pointYs:PDouble; pointCount:Integer; lineWidth:Double; lineStyle:Integer; lineColor:Integer; lineType:Integer): Integer; stdcall;
function ZL_InsertPolygon(pointXs:PDouble; pointYs:PDouble; pointCount:Integer; lineWidth:Double; lineStyle:Integer; lineColor:Integer; fillColor:Integer; angle:Double): Integer; stdcall;
function ZL_InsertText(x:Double; y:Double; width:Double; height:Double; text:String; textMode:Integer; isMirror:Boolean; fontName:String; fontSize:Double; fontStyle:Integer; fontColor:Integer; alignment:Integer; wordSpacing:Double; rowSpacing:Double; angle:Double): Integer; stdcall;
function ZL_InsertBarcode(x:Double; y:Double; width:Double; height:Double; data:String; textFormat:String; barcodeType:Integer; codePage:Integer; moduleWidth:Double; optimize:Boolean; isMirror:Boolean; barColor:Integer; backgroundColor:Integer; fontName:String; fontSize:Double; fontStyle:Integer; fontColor:Integer; alignment:Integer; wordSpacing:Double; angle:Double): Integer; stdcall;
function ZL_InsertImage(x:Double; y:Double; width:Double; height:Double; imagePath:String; scaleType:Integer; angle:Double): Integer; stdcall;
function ZL_DeleteShape(shapeId:Integer): eRET; stdcall;
function ZL_SetDataCustom(shapeId:Integer; data:String): eRET; stdcall;
function ZL_StartOutputCustom(): eRET; stdcall;
function ZL_PdfTool(saveDirOrPath:String; file1:String; file2:String; actionType:Integer; maximumPages:Boolean; pagePad:Boolean; pagesPerBatch:Integer): eRET; stdcall;

implementation
function  ZL_Initialization; external '../../Bin/LabelPainter_SDK.dll';
function  ZL_Release; external '../../Bin/LabelPainter_SDK.dll';
function  ZL_OpenDoc; external '../../Bin/LabelPainter_SDK.dll';
function  ZL_CreateDoc; external '../../Bin/LabelPainter_SDK.dll';
function  ZL_CloseDoc; external '../../Bin/LabelPainter_SDK.dll';
function  ZL_SaveDoc; external '../../Bin/LabelPainter_SDK.dll';
function  ZL_SetLayout; external '../../Bin/LabelPainter_SDK.dll';
function  ZL_SaveLabelImage; external '../../Bin/LabelPainter_SDK.dll'; 
function  ZL_OutputToPrinter; external '../../Bin/LabelPainter_SDK.dll';
function  ZL_OutputToPDF; external '../../Bin/LabelPainter_SDK.dll';
function  ZL_outputToTIFF; external '../../Bin/LabelPainter_SDK.dll';
function  ZL_OutputToImage; external '../../Bin/LabelPainter_SDK.dll';
function  ZL_StopOutput; external '../../Bin/LabelPainter_SDK.dll';
function  ZL_IsOutputing; external '../../Bin/LabelPainter_SDK.dll';
function  ZL_InsertLine; external '../../Bin/LabelPainter_SDK.dll';
function  ZL_InsertPolygon; external '../../Bin/LabelPainter_SDK.dll';
function  ZL_InsertText; external '../../Bin/LabelPainter_SDK.dll';
function  ZL_InsertBarcode; external '../../Bin/LabelPainter_SDK.dll'; 
function  ZL_InsertImage; external '../../Bin/LabelPainter_SDK.dll';
function  ZL_DeleteShape; external '../../Bin/LabelPainter_SDK.dll';
function  ZL_SetDataCustom; external '../../Bin/LabelPainter_SDK.dll';
function  ZL_StartOutputCustom; external '../../Bin/LabelPainter_SDK.dll';
function  ZL_PdfTool; external '../../Bin/LabelPainter_SDK.dll';

end.
 