﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Text;

namespace CSharp
{
    class Program
    {
        static void Main(string[] args)
        {
            string zlDir = "C:\\Program Files (x86)\\中琅条码标签打印软件\\";
            string docFile = "d:\\demo.zhl";
            string labelImg = "d:\\demo.png";
            string outputPdf = "d:\\outputDemo.pdf";
            string outputPdfCustom = "d:\\outputCustomDemo.pdf";
            string overlayPdf = "d:\\overlayDemo.pdf";
            string demoText = "   中琅条码标签打印软件(LabelPainter)是一款强大、专业、易用的条码生成工具、二维码生成器、标签制作软件、批量打印工具。她适用于：防伪标签、物流标签、商品标签、超市价签、医药标签、珠宝标签、吊牌证卡等的设计制作及批量打印工作。\n   中琅条码生成软件不仅仅支持普通的条码打印机、喷墨打印机、激光打印机，还支持各类数码印刷设备。软件支持RGB、CMYK(含专色)、HSL、HSV等颜色模式，及PDF矢量图导入、一键输出PDF文档等。";
            int barcode1d, barcode2d, singleLineText, multiLineText, rect;
            int pageCount = 10;
            eRET rt;

            /////////////////////////////////////////////////////////////////
            ///                        常规操作示例                    ///////
            ///////////////////////////////////////////////////////////////// 
            //初始化
            rt = LabelPainter_SDK_Wrapper.ZL_Initialization(zlDir);
            if (rt != eRET.RET_OK)
                Console.WriteLine("初始化失败");

            //新建文档
            rt = LabelPainter_SDK_Wrapper.ZL_CreateDoc(60, 30);
            if (rt != eRET.RET_OK)
                Console.WriteLine("创建文档失败");

            //设置布局
            rt = LabelPainter_SDK_Wrapper.ZL_SetLayout(0, 0, 0, 0, 1, 1, -1, -1, -1, -1, 1);
            if (rt != eRET.RET_OK)
                Console.WriteLine("设置布局失败");

            //插入二维码
            barcode2d = LabelPainter_SDK_Wrapper.ZL_InsertBarcode(1.6, 1.9, 16.1, 16.1, "http://www.tiaomaruanjian.com/", "", 58, 6, 0, false, false, Color.Black.ToArgb(), Color.White.ToArgb(), "", 0, 0, 0, 0, 0, 0);
            if (barcode2d < 1)
                Console.WriteLine("图形插入失败");

            //插入多边形
            rect = LabelPainter_SDK_Wrapper.ZL_InsertPolygon(new double[] { 0.8, 18.5, 18.5, 0.8 }, new double[] { 19.3, 19.3, 22.2, 22.2 }, 4, 0.2, 1, Color.Gray.ToArgb(), Color.White.ToArgb(), 0);
            if (rect < 1)
                Console.WriteLine("图形插入失败");

            //插入单行文本
            singleLineText = LabelPainter_SDK_Wrapper.ZL_InsertText(1.2, 18.9, 16.7, 3.3, "中琅条码标签打印软件", 0, false, "微软雅黑", 6, 0, Color.Red.ToArgb(), 0, 0.1, 0, 0);
            if (singleLineText < 1)
                Console.WriteLine("图形插入失败");            

            //插入多行文本
            multiLineText = LabelPainter_SDK_Wrapper.ZL_InsertText(19.8, 1.0, 38.9, 28.2, demoText, 1, false, "宋体", 5, 0, Color.Black.ToArgb(), 0, 0.1, 0.6, 0);
            if (multiLineText < 1)
                Console.WriteLine("图形插入失败");

            //保存标签图片
            rt = LabelPainter_SDK_Wrapper.ZL_SaveLabelImage(labelImg);
            if (rt != eRET.RET_OK)
                Console.WriteLine("标签图片生成失败");

            //直接输出
            LabelPainter_SDK_Wrapper.ZL_OutputToPDF(outputPdf, false, "", 0, 1, 10, false);
            if (rt != eRET.RET_OK)
                Console.WriteLine("输出文档失败");

            //保存文档
            rt = LabelPainter_SDK_Wrapper.ZL_SaveDoc(docFile);
            if (rt != eRET.RET_OK)
                Console.WriteLine("保存文档失败");

            //关闭文档
            rt = LabelPainter_SDK_Wrapper.ZL_CloseDoc();
            if (rt != eRET.RET_OK)
                Console.WriteLine("关闭文档失败");


            /////////////////////////////////////////////////////////////////
            ///                        自定义输出示例                  ///////
            ///////////////////////////////////////////////////////////////// 
            //打开文档
            rt = LabelPainter_SDK_Wrapper.ZL_OpenDoc(docFile, "");
            if (rt != eRET.RET_OK)
                Console.WriteLine("打开文档失败");

            //插入条形码
            barcode1d = LabelPainter_SDK_Wrapper.ZL_InsertBarcode(1.0, 23.3, 17, 5.3, "123456", "??? ???", 20, 6, 0, false, false, Color.Black.ToArgb(), Color.White.ToArgb(), "微软雅黑", 6, 0, Color.Blue.ToArgb(), 1, 0, 0);
            if (barcode1d < 1)
                Console.WriteLine("图形插入失败");

            //删除图形
            rt = LabelPainter_SDK_Wrapper.ZL_DeleteShape(rect);
            if (rt != eRET.RET_OK)
                Console.WriteLine("删除图形失败");
            rt = LabelPainter_SDK_Wrapper.ZL_DeleteShape(multiLineText);
            if (rt != eRET.RET_OK)
                Console.WriteLine("删除图形失败");
            rt = LabelPainter_SDK_Wrapper.ZL_DeleteShape(singleLineText);
            if (rt != eRET.RET_OK)
                Console.WriteLine("删除图形失败");
            rt = LabelPainter_SDK_Wrapper.ZL_DeleteShape(barcode2d);
            if (rt != eRET.RET_OK)
                Console.WriteLine("删除图形失败");

            //自定义输出
            rt = LabelPainter_SDK_Wrapper.ZL_OutputToPDF(outputPdfCustom, false, "", 0, 1, 10, true);
            if (rt != eRET.RET_OK)
                Console.WriteLine("自定义输出失败");
            else
            {
                //单页赋值并输出
                for (int i = 1; i <= pageCount; i++)
                {
                    //图形赋值
                    if (!setShapeData(barcode1d, string.Format("{0:D6}", i)))
                    {
                        Console.WriteLine("图形赋值失败");
                        break;
                    }

                    //输出当前页
                    rt = LabelPainter_SDK_Wrapper.ZL_StartOutputCustom();
                    if (rt != eRET.RET_OK)
                    {
                        Console.WriteLine("输出当前页失败");
                        break;
                    }                        
                }

                //停止输出
                rt = LabelPainter_SDK_Wrapper.ZL_StopOutput();
                if (rt != eRET.RET_OK)
                    Console.WriteLine("停止输出失败");
            }            

            //关闭文档
            rt = LabelPainter_SDK_Wrapper.ZL_CloseDoc();
            if (rt != eRET.RET_OK)
                Console.WriteLine("关闭文档失败");


            /////////////////////////////////////////////////////////////////
            ///                        PDF工具箱示例                   ///////
            /////////////////////////////////////////////////////////////////
            rt = LabelPainter_SDK_Wrapper.ZL_PdfTool(overlayPdf, outputPdfCustom, outputPdf, 3, true, false, 1);
            if (rt != eRET.RET_OK)
                Console.WriteLine("PDF文档处理失败");


            //释放资源
            rt = LabelPainter_SDK_Wrapper.ZL_Release();
            if (rt != eRET.RET_OK)
                Console.WriteLine("释放资源失败");            
        }

        private static bool setShapeData(int shapeId, string data)
        {
            eRET rt = LabelPainter_SDK_Wrapper.ZL_SetDataCustom(shapeId, data);
            while (rt == eRET.RET_BUSY)
            {
                rt = LabelPainter_SDK_Wrapper.ZL_SetDataCustom(shapeId, data);
            }
            return rt == eRET.RET_OK;
        }
    }
}
