/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.axml;

import com.googlecode.dex2jar.reader.io.DataOut;
import com.googlecode.dex2jar.reader.io.LeDataOut;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import pxb.android.axml.AxmlVisitor;
import pxb.android.axml.NodeVisitor;
import pxb.android.axml.StringItem;
import pxb.android.axml.StringItems;

public class AxmlWriter
extends AxmlVisitor {
    private List<NodeImpl> firsts = new ArrayList<NodeImpl>(3);
    private Map<String, Ns> nses = new HashMap<String, Ns>();
    private List<StringItem> otherString = new ArrayList<StringItem>();
    private Map<Integer, StringItem> resourceId2Str = new HashMap<Integer, StringItem>();
    private List<Integer> resourceIds = new ArrayList<Integer>();
    private List<StringItem> resourceString = new ArrayList<StringItem>();
    private StringItems stringItems = new StringItems();

    @Override
    public void visitEnd() {
    }

    @Override
    public NodeVisitor visitFirst(String ns, String name) {
        NodeImpl first = new NodeImpl(ns, name);
        this.firsts.add(first);
        return first;
    }

    @Override
    public void visitNamespace(String prefix, String uri, int ln) {
        this.nses.put(uri, new Ns(new StringItem(prefix), new StringItem(uri), ln));
    }

    private int prepare() throws IOException {
        int size = this.nses.size() * 24 * 2;
        for (NodeImpl first : this.firsts) {
            size += first.prepare(this);
        }
        int a = 0;
        for (Map.Entry<String, Ns> e : this.nses.entrySet()) {
            Ns ns = e.getValue();
            if (ns == null) {
                ns = new Ns(new StringItem(String.format("axml_auto_%02d", a++)), new StringItem(e.getKey()), 0);
                e.setValue(ns);
            }
            ns.prefix = this.update(ns.prefix);
            ns.uri = this.update(ns.uri);
        }
        this.stringItems.addAll(this.resourceString);
        this.resourceString = null;
        this.stringItems.addAll(this.otherString);
        this.otherString = null;
        this.stringItems.prepare();
        int stringSize = this.stringItems.getSize();
        if (stringSize % 4 != 0) {
            stringSize += 4 - stringSize % 4;
        }
        size += 8 + stringSize;
        return size += 8 + this.resourceIds.size() * 4;
    }

    public void writeTo(OutputStream os) throws IOException {
        LeDataOut out = new LeDataOut(os);
        int size = this.prepare();
        out.writeInt(524291);
        out.writeInt(size + 8);
        int stringSize = this.stringItems.getSize();
        int padding = 0;
        if (stringSize % 4 != 0) {
            padding = 4 - stringSize % 4;
        }
        out.writeInt(0x1C0001);
        out.writeInt(stringSize + padding + 8);
        this.stringItems.write(out);
        out.writeBytes(new byte[padding]);
        out.writeInt(524672);
        out.writeInt(8 + this.resourceIds.size() * 4);
        for (Integer n : this.resourceIds) {
            out.writeInt(n);
        }
        Stack<Ns> stack = new Stack<Ns>();
        for (Map.Entry<String, Ns> entry : this.nses.entrySet()) {
            Ns ns = entry.getValue();
            stack.push(ns);
            out.writeInt(0x100100);
            out.writeInt(24);
            out.writeInt(-1);
            out.writeInt(-1);
            out.writeInt(ns.prefix.index);
            out.writeInt(ns.uri.index);
        }
        for (NodeImpl nodeImpl : this.firsts) {
            nodeImpl.write(out);
        }
        while (stack.size() > 0) {
            Ns ns = (Ns)stack.pop();
            out.writeInt(0x100101);
            out.writeInt(24);
            out.writeInt(ns.ln);
            out.writeInt(-1);
            out.writeInt(ns.prefix.index);
            out.writeInt(ns.uri.index);
        }
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.writeTo(os);
        return os.toByteArray();
    }

    StringItem update(StringItem item) {
        if (item == null) {
            return null;
        }
        int i = this.otherString.indexOf(item);
        if (i < 0) {
            StringItem copy = new StringItem(item.data);
            this.otherString.add(copy);
            return copy;
        }
        return this.otherString.get(i);
    }

    StringItem updateNs(StringItem item) {
        if (item == null) {
            return null;
        }
        String ns = item.data;
        if (!this.nses.containsKey(ns)) {
            this.nses.put(ns, null);
        }
        return this.update(item);
    }

    StringItem updateWithResourceId(StringItem name, int resourceId) {
        StringItem item = this.resourceId2Str.get(resourceId);
        if (item != null) {
            return item;
        }
        StringItem copy = new StringItem(name.data);
        this.resourceIds.add(resourceId);
        this.resourceString.add(copy);
        this.resourceId2Str.put(resourceId, copy);
        return copy;
    }

    static class Ns {
        int ln;
        StringItem prefix;
        StringItem uri;

        public Ns(StringItem prefix, StringItem uri, int ln) {
            this.prefix = prefix;
            this.uri = uri;
            this.ln = ln;
        }
    }

    static class NodeImpl
    extends NodeVisitor {
        private Map<String, Attr> attrs = new HashMap<String, Attr>();
        private List<NodeImpl> children = new ArrayList<NodeImpl>();
        private int line;
        private StringItem name;
        private StringItem ns;
        private StringItem text;
        private int textLineNumber;

        public NodeImpl(String ns, String name) {
            super(null);
            this.ns = ns == null ? null : new StringItem(ns);
            this.name = name == null ? null : new StringItem(name);
        }

        @Override
        public void visitContentAttr(String ns, String name, int resourceId, int type, Object value) {
            if (name == null) {
                throw new RuntimeException("name can't be null");
            }
            this.attrs.put((ns == null ? "zzz" : ns) + "." + name, new Attr(ns == null ? null : new StringItem(ns), new StringItem(name), resourceId, type, type == 3 ? new StringItem((String)value) : value));
        }

        @Override
        public NodeVisitor visitChild(String ns, String name) {
            NodeImpl child = new NodeImpl(ns, name);
            this.children.add(child);
            return child;
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void visitLineNumber(int ln) {
            this.line = ln;
        }

        public int prepare(AxmlWriter axmlWriter) {
            this.ns = axmlWriter.updateNs(this.ns);
            this.name = axmlWriter.update(this.name);
            for (Attr attr : this.sortedAttrs()) {
                attr.prepare(axmlWriter);
            }
            this.text = axmlWriter.update(this.text);
            int size = 60 + this.attrs.size() * 20;
            for (NodeImpl child : this.children) {
                size += child.prepare(axmlWriter);
            }
            if (this.text != null) {
                size += 28;
            }
            return size;
        }

        List<Attr> sortedAttrs() {
            ArrayList<Attr> lAttrs = new ArrayList<Attr>(this.attrs.values());
            Collections.sort(lAttrs, new Comparator<Attr>(){

                @Override
                public int compare(Attr a, Attr b) {
                    if (a.ns == null) {
                        if (b.ns == null) {
                            return b.name.data.compareTo(a.name.data);
                        }
                        return 1;
                    }
                    if (b.ns == null) {
                        return -1;
                    }
                    int x = a.ns.data.compareTo(b.ns.data);
                    if (x == 0 && (x = a.resourceId - b.resourceId) == 0) {
                        return a.name.data.compareTo(b.name.data);
                    }
                    return x;
                }
            });
            return lAttrs;
        }

        @Override
        public void visitContentText(int ln, String value) {
            this.text = new StringItem(value);
            this.textLineNumber = ln;
        }

        void write(DataOut out) throws IOException {
            out.writeInt(0x100102);
            out.writeInt(36 + this.attrs.size() * 20);
            out.writeInt(this.line);
            out.writeInt(-1);
            out.writeInt(this.ns != null ? this.ns.index : -1);
            out.writeInt(this.name.index);
            out.writeInt(0x140014);
            out.writeShort(this.attrs.size());
            out.writeShort(0);
            out.writeShort(0);
            out.writeShort(0);
            for (Attr attr : this.sortedAttrs()) {
                out.writeInt(attr.ns == null ? -1 : attr.ns.index);
                out.writeInt(attr.name.index);
                out.writeInt(attr.value instanceof StringItem ? ((StringItem)attr.value).index : -1);
                out.writeInt(attr.type << 24 | 8);
                Object v = attr.value;
                if (v instanceof StringItem) {
                    out.writeInt(((StringItem)attr.value).index);
                    continue;
                }
                if (v instanceof Boolean) {
                    out.writeInt(Boolean.TRUE.equals(v) ? -1 : 0);
                    continue;
                }
                out.writeInt((Integer)attr.value);
            }
            if (this.text != null) {
                out.writeInt(0x100104);
                out.writeInt(28);
                out.writeInt(this.textLineNumber);
                out.writeInt(-1);
                out.writeInt(this.text.index);
                out.writeInt(8);
                out.writeInt(0);
            }
            for (NodeImpl child : this.children) {
                child.write(out);
            }
            out.writeInt(0x100103);
            out.writeInt(24);
            out.writeInt(-1);
            out.writeInt(-1);
            out.writeInt(this.ns != null ? this.ns.index : -1);
            out.writeInt(this.name.index);
        }
    }

    static class Attr {
        public StringItem name;
        public StringItem ns;
        public int resourceId;
        public int type;
        public Object value;

        public Attr(StringItem ns, StringItem name, int resourceId, int type, Object value) {
            this.ns = ns;
            this.name = name;
            this.resourceId = resourceId;
            this.type = type;
            this.value = value;
        }

        public void prepare(AxmlWriter axmlWriter) {
            this.ns = axmlWriter.updateNs(this.ns);
            if (this.name != null) {
                this.name = this.resourceId != -1 ? axmlWriter.updateWithResourceId(this.name, this.resourceId) : axmlWriter.update(this.name);
            }
            if (this.value instanceof StringItem) {
                this.value = axmlWriter.update((StringItem)this.value);
            }
        }
    }
}

