/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.axml;

import com.googlecode.dex2jar.reader.io.ArrayDataIn;
import com.googlecode.dex2jar.reader.io.DataIn;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import pxb.android.axml.AxmlVisitor;
import pxb.android.axml.NodeVisitor;
import pxb.android.axml.StringItem;
import pxb.android.axml.StringItems;

public class AxmlReader {
    static final int CHUNK_AXML_FILE = 524291;
    static final int CHUNK_RESOURCEIDS = 524672;
    static final int CHUNK_STRINGS = 0x1C0001;
    static final int CHUNK_XML_END_NAMESPACE = 0x100101;
    static final int CHUNK_XML_END_TAG = 0x100103;
    static final int CHUNK_XML_START_NAMESPACE = 0x100100;
    static final int CHUNK_XML_START_TAG = 0x100102;
    static final int CHUNK_XML_TEXT = 0x100104;
    public static final NodeVisitor EMPTY_VISITOR = new NodeVisitor(){

        @Override
        public NodeVisitor visitChild(String namespace, String name) {
            return EMPTY_VISITOR;
        }
    };
    static final int UTF8_FLAG = 256;
    private DataIn input;
    private List<Integer> resourceIds = new ArrayList<Integer>();
    private StringItems stringItems = new StringItems();

    public AxmlReader(byte[] data) {
        this(ArrayDataIn.le(data));
    }

    public AxmlReader(DataIn input) {
        this.input = input;
    }

    public static AxmlReader create(InputStream is) {
        try {
            int available = is.available();
            byte[] buffer = new byte[available];
            int len = is.read(buffer);
            if (len == available) {
                return new AxmlReader(buffer);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void accept(final AxmlVisitor documentVisitor) throws IOException {
        DataIn input = this.input;
        int type = input.readIntx();
        if (type != 524291) {
            throw new RuntimeException();
        }
        int fileSize = input.readIntx();
        NodeVisitor rootVisitor = documentVisitor == null ? EMPTY_VISITOR : new NodeVisitor(){

            @Override
            public NodeVisitor visitChild(String namespace, String name) {
                return documentVisitor.visitFirst(namespace, name);
            }
        };
        Stack<NodeVisitor> nodeVisitorStack = new Stack<NodeVisitor>();
        Stack<Boolean> nodeVisitorContentsHandled = new Stack<Boolean>();
        NodeVisitor stackTop = rootVisitor;
        nodeVisitorStack.push(rootVisitor);
        nodeVisitorContentsHandled.push(false);
        documentVisitor.visitBegin();
        int position = input.getCurrentPosition();
        while (position < fileSize) {
            int type2 = input.readIntx();
            int size = input.readIntx();
            switch (type2) {
                case 0x100102: {
                    int i;
                    String namespace;
                    int lineNumber = input.readIntx();
                    input.skip(4);
                    int namespaceIdx = input.readIntx();
                    int nameIdx = input.readIntx();
                    int flag = input.readIntx();
                    if (flag != 0x140014) {
                        throw new RuntimeException();
                    }
                    String name = ((StringItem)this.stringItems.get((int)nameIdx)).data;
                    String string = namespace = namespaceIdx >= 0 ? ((StringItem)this.stringItems.get((int)namespaceIdx)).data : null;
                    if (!((Boolean)nodeVisitorContentsHandled.peek()).booleanValue()) {
                        nodeVisitorContentsHandled.pop();
                        nodeVisitorContentsHandled.push(true);
                        stackTop.visitContentEnd();
                    }
                    if ((stackTop = stackTop.visitChild(namespace, name)) == null) {
                        stackTop = EMPTY_VISITOR;
                    }
                    nodeVisitorStack.push(stackTop);
                    nodeVisitorContentsHandled.push(false);
                    stackTop.visitBegin();
                    stackTop.visitLineNumber(lineNumber);
                    int attributeCount = input.readUShortx();
                    input.skip(6);
                    if (stackTop != EMPTY_VISITOR) {
                        for (i = 0; i < attributeCount; ++i) {
                            namespaceIdx = input.readIntx();
                            nameIdx = input.readIntx();
                            input.skip(4);
                            int aValueType = input.readIntx() >>> 24;
                            int aValue = input.readIntx();
                            name = ((StringItem)this.stringItems.get((int)nameIdx)).data;
                            namespace = namespaceIdx >= 0 ? ((StringItem)this.stringItems.get((int)namespaceIdx)).data : null;
                            Object value = null;
                            switch (aValueType) {
                                case 3: {
                                    value = ((StringItem)this.stringItems.get((int)aValue)).data;
                                    break;
                                }
                                case 18: {
                                    value = aValue != 0;
                                    break;
                                }
                                default: {
                                    value = aValue;
                                }
                            }
                            int resourceId = nameIdx < this.resourceIds.size() ? this.resourceIds.get(nameIdx) : -1;
                            stackTop.visitContentAttr(namespace, name, resourceId, aValueType, value);
                        }
                        break;
                    }
                    input.skip(20);
                    break;
                }
                case 0x100103: {
                    input.skip(size - 8);
                    if (!((Boolean)nodeVisitorContentsHandled.peek()).booleanValue()) {
                        stackTop.visitContentEnd();
                        nodeVisitorContentsHandled.pop();
                        nodeVisitorContentsHandled.push(true);
                    }
                    stackTop.visitEnd();
                    nodeVisitorStack.pop();
                    stackTop = (NodeVisitor)nodeVisitorStack.peek();
                    break;
                }
                case 0x100100: {
                    if (documentVisitor == null) {
                        input.skip(16);
                        break;
                    }
                    int lineNumber = input.readIntx();
                    input.skip(4);
                    int prefixIdx = input.readIntx();
                    int namespaceIdx = input.readIntx();
                    documentVisitor.visitNamespace(((StringItem)this.stringItems.get((int)prefixIdx)).data, ((StringItem)this.stringItems.get((int)namespaceIdx)).data, lineNumber);
                    break;
                }
                case 0x100101: {
                    input.skip(size - 8);
                    break;
                }
                case 0x1C0001: {
                    this.stringItems.read(input, size);
                    break;
                }
                case 524672: {
                    int i;
                    int count = size / 4 - 2;
                    for (i = 0; i < count; ++i) {
                        this.resourceIds.add(input.readIntx());
                    }
                    break;
                }
                case 0x100104: {
                    if (stackTop == EMPTY_VISITOR) {
                        input.skip(20);
                        break;
                    }
                    int lineNumber = input.readIntx();
                    input.skip(4);
                    int nameIdx = input.readIntx();
                    input.skip(8);
                    String name = ((StringItem)this.stringItems.get((int)nameIdx)).data;
                    stackTop.visitContentText(lineNumber, name);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            input.move(position + size);
            position = input.getCurrentPosition();
        }
        documentVisitor.visitEnd();
    }
}

