/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.axml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pxb.android.axml.AxmlVisitor;
import pxb.android.axml.NodeVisitor;

public class AxmlEditor
extends AxmlVisitor {
    private Map<String, String> nses = new HashMap<String, String>();
    public static ArrayList<String> mNameStack = null;
    public static ArrayList<String> mSelector = null;
    public static String mAttr = null;
    public static int mType;
    public static Object mValue;
    public static int mState;
    private String mJqStr;

    public AxmlEditor(AxmlVisitor av, String jqString) {
        super(av);
        this.mJqStr = jqString;
    }

    public boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("^-?[0-9a-f]+");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    @Override
    public void visitBegin() {
        mNameStack = new ArrayList();
        mSelector = new ArrayList();
        mAttr = "";
        Pattern pattern = Pattern.compile("\\$\\('([^']*)'\\)\\.attr\\('([^']+)',([^\\)]+)\\)");
        Matcher matcher = pattern.matcher(this.mJqStr);
        if (matcher.find()) {
            String[] strArr;
            for (String s : strArr = matcher.group(1).split("\\s+")) {
                mSelector.add(s);
            }
            mAttr = matcher.group(2);
            String strVal = matcher.group(3);
            if (strVal.equals("true")) {
                mType = 18;
                mValue = -1;
            } else if (strVal.equals("false")) {
                mType = 18;
                mValue = 0;
            } else if (this.isNumeric(strVal)) {
                mType = 16;
                mValue = Integer.parseInt(strVal);
            } else {
                mType = 3;
                int beginIdx = 0;
                int endIdx = strVal.length();
                if (strVal.startsWith("'")) {
                    ++beginIdx;
                }
                if (strVal.endsWith("'")) {
                    --endIdx;
                }
                mValue = strVal.substring(beginIdx, endIdx);
            }
        }
        mState = 0;
        super.visitBegin();
    }

    @Override
    public NodeVisitor visitFirst(String namespace, String name) {
        NodeVisitor nv = super.visitFirst(namespace, name);
        DumpNodeAdapter x = new DumpNodeAdapter(nv, 1, this.nses, namespace, name);
        return x;
    }

    @Override
    public void visitNamespace(String prefix, String uri, int ln) {
        this.nses.put(uri, prefix);
        super.visitNamespace(prefix, uri, ln);
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
    }

    public static class DumpNodeAdapter
    extends NodeVisitor {
        protected final int depth;
        protected Map<String, String> nses;
        protected String namespace;
        protected String name;

        public DumpNodeAdapter(NodeVisitor nv, String namespace, String name) {
            super(nv);
            this.depth = 0;
            this.nses = null;
            this.namespace = namespace;
            this.name = name;
        }

        public DumpNodeAdapter(NodeVisitor nv, int x, Map<String, String> nses, String namespace, String name) {
            super(nv);
            this.depth = x;
            this.nses = nses;
            this.namespace = namespace;
            this.name = name;
        }

        @Override
        public void visitBegin() {
            mNameStack.add(this.name);
            if (mSelector.size() <= mNameStack.size()) {
                int i;
                int b = mNameStack.size() - mSelector.size();
                for (i = 0; i < mSelector.size() && mNameStack.get(b + i).equals(mSelector.get(i)); ++i) {
                }
                if (i != 0 && i == mSelector.size()) {
                    ++mState;
                }
            }
            super.visitBegin();
        }

        @Override
        public void visitContentAttr(String ns, String name, int resourceId, int type, Object obj) {
            String attrName = "";
            if (ns != null) {
                attrName = attrName + String.format("%s:", this.getPrefix(ns));
            }
            attrName = attrName + name;
            if (mState == 1 && mAttr.equals(attrName)) {
                super.visitContentAttr(ns, name, resourceId, type, mValue);
                ++mState;
                return;
            }
            super.visitContentAttr(ns, name, resourceId, type, obj);
        }

        @Override
        public void visitContentEnd() {
            super.visitContentEnd();
        }

        @Override
        public NodeVisitor visitChild(String namespace, String name) {
            NodeVisitor nv = super.visitChild(namespace, name);
            return new DumpNodeAdapter(nv, this.depth + 1, this.nses, namespace, name);
        }

        protected String getPrefix(String uri) {
            String prefix;
            if (this.nses != null && (prefix = this.nses.get(uri)) != null) {
                return prefix;
            }
            return uri;
        }

        @Override
        public void visitContentText(int ln, String value) {
            super.visitContentText(ln, value);
        }

        @Override
        public void visitLineNumber(int n) {
            super.visitLineNumber(n);
        }

        @Override
        public void visitEnd() {
            if (mState == 1) {
                super.visitContentAttr(null, mAttr, -1, mType, mValue);
                ++mState;
            }
            if (!mNameStack.isEmpty()) {
                mNameStack.remove(mNameStack.size() - 1);
            }
            super.visitEnd();
        }
    }
}

