(function(){var e=0;"use strict";var t=require("util");var n=require("events");var s=require("./warn3");var a=require("./Logger").getLogger("warnDb3.js");var i=require("./jsUtil");var r=require("moment");function c(e,t){n.EventEmitter.call(this);if(false===this instanceof c){return new c}var a="CREATE TABLE IF NOT EXISTS warn_table(id INTEGER PRIMARY KEY AUTOINCREMENT,deviceName VARCHAR(32), dev VARCHAR(32), time DATETIME, level VARCHAR(32), type VARCHAR(72), subtype VARCHAR(72), desc VARCHAR(132), advice VARCHAR(132));";this.setUpDb(e,a);this.warnInstance=new s;this.dbMgr=t;this.ignores=[];this.end=0;this.initAllcheckItems()}t.inherits(c,n.EventEmitter);c.prototype.initAllcheckItems=function(){var e=this;this.allCheckItems=[{type:"配置变化体检",subtype:"配置变化体检"},{type:"死机信息体检",subtype:"死机信息体检"},{type:"日志告警体检",subtype:"内存申请失败告警"},{type:"日志告警体检",subtype:"mac地址冲突告警"},{type:"日志告警体检",subtype:"arp地址冲突告警"},{type:"日志告警体检",subtype:"可信arp超过容量告警"},{type:"日志告警体检",subtype:"dhcp地址冲突告警"},{type:"日志告警体检",subtype:"dhcp-snooping表项告警"},{type:"日志告警体检",subtype:"环路体检预警"},{type:"容量体检",subtype:"MAC表项数量体检"},{type:"容量体检",subtype:"dhcp-snooping数量检测"},{type:"容量体检",subtype:"sta数量检测"},{type:"容量体检",subtype:"ARP表项数量体检"},{type:"网络基础保护策略体检",subtype:"NFPP配置体检"},{type:"端口体检",subtype:"异常端口体检"},{type:"端口体检",subtype:"端口报文坏包丢包错误体检"},{type:"端口体检",subtype:"聚合口成员状态体检"},{type:"高可用体检",subtype:"VSU双主机体检配置 - bfd"},{type:"高可用体检",subtype:"VSU双主机体检配置 - 聚合口"},{type:"高可用体检",subtype:"体检是否是双上联线路"},{type:"高可用体检",subtype:"体检组成聚合口的成员口是否跨机箱"},{type:"高可用体检",subtype:"体检VSL链路是否跨线卡"},{type:"高可用体检",subtype:"体检VSL是否与双主机体检使用同一块线卡口"},{type:"高可用体检",subtype:"语音QosVoiceVlan体检"},{type:"高可用体检",subtype:"接入dot1x认证体检"}]};c.prototype.setUpDb=function(e,t){var n=this;this.db=e;var s="CREATE TABLE IF NOT EXISTS warnchecked_item_table(deviceName VARCHAR(32), dev VARCHAR(32), time DATETIME, level VARCHAR(32), type VARCHAR(72), subtype VARCHAR(72), desc VARCHAR(132), advice VARCHAR(132),score integer,end_item VARCHAR(32), why VARCHAR(72));";var a="CREATE TABLE IF NOT EXISTS last_checked_data(last_start_time DATETIME, score double,problem integer, manged_dev_length integer, itemNum integer,  oneItem integer, complentNum integer);";var i="CREATE TABLE IF NOT EXISTS last_inspected_data(deviceName VARCHAR(32), dev VARCHAR(32), time DATETIME, end_item VARCHAR(32), why VARCHAR(72),type VARCHAR(10),success integer,failed integer);";this.db.serialize(function(){n.db.run(t);n.db.run(s);n.db.run(a);n.db.run(i)})};c.prototype.setUpSystem=function(e,t){this.end=0;var n=this;this.warnInstance.setUpSystem(e);this.instance=e;this.sn=e.getDeviceSn();if(this.sn==""){this.sn="123456789"}var s=function(e,t){n.end++;var s={deviceName:this.deviceName,dev:this.sn,type:e.type,subtype:e.subtype,score:t};n.emit("check_end",s)};var r=function(e){var s=t;for(var r=0;r<n.ignores.length;r++){if(e.dev==n.ignores[r].dev&&e.type==n.ignores[r].type&&e.subtype==n.ignores[r].subtype){e.level="ignore";break}}var c=e;c.time=s;n.emit("check_result",c);var o=i.strFormat("INSERT INTO warn_table(deviceName ,dev, time, level, type, subtype, desc, advice)"+" VALUES ('{0}', '{1}', '{2}', '{3}','{4}','{5}','{6}','{7}');\n",this.deviceName,e.dev,s,e.level,e.type,e.subtype,e.desc,e.advice);n.dbMgr.insertSqlIntoList(o,"warn_table",function(e){if(e){a.debug("[Error: insertIntoDb] "+e)}})};this.warnInstance.removeAllListeners("check_result");this.warnInstance.removeAllListeners("check_end");this.warnInstance.on("check_result",r);this.warnInstance.on("check_end",s)};c.prototype.setIgnores=function(e){this.ignores=e};c.prototype.insertLastCheckedData=function(e){var t=this;var n="delete from last_checked_data";var s=e;this.db.all(n,function(n,s){if(n){return}t.db.run("INSERT INTO last_checked_data(last_start_time ,score, problem, manged_dev_length, itemNum, oneItem, complentNum) "+"VALUES (?,?, ?, ?, ?, ?,?);",[e.last_start_time,e.score,e.problem,e.length,e.itemNum,e.oneItem,e.complentNum])})};c.prototype.queryLastCheckedData=function(e){var t="select * from last_checked_data";this.db.all(t,function(t,n){e(t,n)})};c.prototype.insertLastInspectedData=function(e,t){var n=this;if(e.on=="complete_end"){e.success=1;e.failed=0}else{e.success=0;e.failed=1}var s=i.strFormat("INSERT INTO last_inspected_data(deviceName ,dev, time, end_item, why,type,success,failed)"+" VALUES ('{0}','{1}', '{2}', '{3}','{4}','{5}',{6},{7});\n",e.deviceName,e.sn,t,e.on,e.why,e.type,e.success,e.failed);n.dbMgr.insertSqlIntoList(s,"last_inspected_data",function(e){if(e){a.debug("[Error: insertLastInspectedData] "+e)}})};c.prototype.queryLastInspectedData=function(e){var t="select * from last_inspected_data";this.db.all(t,function(t,n){e(t,n)})};c.prototype.insertLastInspecteItemdData=function(e,t){var n=this;for(var s=0;s<e.item.length;s++){var r=i.strFormat("INSERT INTO warnchecked_item_table(deviceName ,dev, time, score, type, subtype, desc, advice,end_item,why)"+" VALUES ('{0}', '{1}', '{2}', {3},'{4}','{5}','{6}','{7}','{8}','{9}');\n",e.deviceName,e.sn,t,e.item[s].score,e.item[s].type,e.item[s].subtype,e.desc,e.device,e.on,e.why);n.dbMgr.insertSqlIntoList(r,"warnchecked_item_table",function(e){if(e){a.debug("[Error: insertLastInspecteItemdData] "+e)}})}};c.prototype.queryLastInspecteItemdData=function(e){var t="select * from warnchecked_item_table";this.db.all(t,function(t,n){e(t,n)})};c.prototype.queryFromDb=function(e,t){var n=this;var s=n.sn;var a="select * from warn_table";var i=0;if(e!=null&&e.subtype=="全部"&&e.keyword==""&&e.start_time==""&&e.end_time==""){e=null}if(e!=null){a+=" where ";if(e.subtype!=""&&e.subtype!="全部"){a+="(subtype="+"'"+e.subtype+"')";i++}if(e.keyword!=""){if(i!=0){a+=" and (subtype like "+"'%"+e.keyword+"%'"+" or desc like "+"'%"+e.keyword+"%')"}else{a+="(subtype like "+"'%"+e.keyword+"%'"+" or desc like "+"'%"+e.keyword+"%')"}i++}if(e.start_time!=""&&e.end_time!=""){if(i!=0){a+=" and (time between "+"'"+e.start_time+"'"+" and "+"'"+e.end_time+"')"}else{a+="time between "+"'"+e.start_time+"'"+" and "+"'"+e.end_time+"'"}}if(s!=""&&s!=undefined){}}a+=" order by time desc";this.db.all(a,function(e,n){t(e,n)})};c.prototype.queryTypeFromWarnAndDev=function(e,t){this.db.all("select warn_table.dev as dev, warn_table.time as time, warn_table.level as level,warn_table.type as type,"+"warn_table.subtype as subtype,warn_table.desc as desc,warn_table.advice as advice, device_link.deviceName as deviceName,"+" device_link.protocal as protocal,device_link.comNum as comNum,device_link.baudrate as baudrate,"+"device_link.username as username, device_link.password as password, device_link.host as host, device_link.enablePassword as enablePassword,"+" device_link.status as status,device_link.port as port,ignore_table.level as ignore "+"FROM warn_table LEFT JOIN device_link ON warn_table.dev = device_link.seriaNo and warn_table.deviceName = device_link.deviceName LEFT JOIN ignore_table ON  warn_table.dev = ignore_table.dev and warn_table.type = ignore_table.type and warn_table.subtype = ignore_table.subtype where warn_table.type=? and (warn_table.level='warning' or warn_table.level='error')",[e],function(e,n){console.log(e);t(e,n)})};c.prototype.queryTypeFromDb=function(e,t){var n=self.sn;var s="select * from warn_table";var a=0;if(e!=null&&e.type=="全部"&&e.keyword==""&&e.start_time==""&&e.end_time==""){e=null}if(e!=null){s+=" where ";if(e.type!=""&&e.type!="全部"){s+="(type="+"'"+e.type+"')";a++}if(e.keyword!=""){if(a!=0){s+=" and (type like "+"'%"+e.keyword+"%'"+" or desc like "+"'%"+e.keyword+"%')"}else{s+="(type like "+"'%"+e.keyword+"%'"+" or desc like "+"'%"+e.keyword+"%')"}a++}if(e.start_time!=""&&e.end_time!=""){if(a!=0){s+=" and (time between "+"'"+e.start_time+"'"+" and "+"'"+e.end_time+"')"}else{s+="time between "+"'"+e.start_time+"'"+" and "+"'"+e.end_time+"'"}}if(n!=""&&n!=undefined){}}s+=" order by time desc";this.db.all(s,function(e,n){t(e,n)})};c.prototype.readTypesFromDb=function(e){var t="select distinct subtype from warn_table";this.db.all(t,function(t,n){e(t,n)})};c.prototype.deltewarnDb=function(e){var t=this;var n="delete from warn_table";this.db.all(n,function(n,s){if(n){e(n,s);return}t.db.all("delete from warnchecked_item_table",function(t,n){if(t){e(t,n);return}e(t,n)})})};c.prototype.getwarnItemNum=function(e){var t="select type, count(level) as num from warn_table where level= 'error' or level = 'warning' group by type";console.log(t);this.db.all(t,function(t,n){console.log(t);e(t,n)})};c.prototype.getDeviceOnlinePercent=function(e,t){if(e.interval=="hour"){this.db.all("SELECT strftime('%Y-%m-%d %H:00:00', time) as timeIntervals,total(success)/count(*) as percent,count (*) as count From last_inspected_data where type = 'get_back_data' AND  (time BETWEEN ? AND ?) GROUP BY timeIntervals;",[e.startTime,e.endTime],function(e,n){t(e,n)})}else if(e.interval=="day"){this.db.all("SELECT strftime('%Y-%m-%d', time) as timeIntervals,total(success)/count(*) as percent,count (*) as count From last_inspected_data where type = 'get_back_data' AND  (time BETWEEN ? AND ?) GROUP BY timeIntervals;",[e.startTime,e.endTime],function(e,n){t(e,n)})}};c.prototype.getReguarlyOfflineDevices=function(e,t){this.db.all("select deviceName,dev,sum(failed) as faileds , sum(failed)*5 as offline_time from last_inspected_data where failed != 0 AND type = 'get_back_data' AND (time BETWEEN ? AND ?)  group by deviceName,dev order by sum(failed) desc limit 10",[e.startTime,e.endTime],function(e,n){t(e,n)})};c.prototype.ignorecheckDualActive=function(){var e=this;var t={type:"高可用体检",subtype:"VSU双主机体检配置 - bfd"};var n=0;this.warnInstance.emit("check_start",t);var s={dev:e.sn,type:"高可用体检",subtype:"VSU双主机体检配置 - bfd",level:"success",desc:"",advice:""};this.warnInstance.emit("check_result",s);this.warnInstance.emit("check_end",t,n);var a={type:"高可用体检",subtype:"VSU双主机体检配置 - 聚合口"};var i=0;this.warnInstance.emit("check_start",a);var s={dev:e.sn,type:"高可用体检",subtype:"VSU双主机体检配置 - 聚合口",level:"success",desc:"",advice:""};this.warnInstance.emit("check_result",s);this.warnInstance.emit("check_end",a,i)};c.prototype.ignorecheckRouteDoubleUplink=function(){var e=this;var t={type:"高可用体检",subtype:"体检是否是双上联线路"};var n=0;e.warnInstance.emit("check_start",t);var s={dev:e.sn,type:"高可用体检",subtype:"体检是否是双上联线路",level:"success",desc:"",advice:""};e.warnInstance.emit("check_result",s);e.warnInstance.emit("check_end",t,n)};c.prototype.ignorecheckApCrossDevice=function(){var e=this;var t={type:"高可用体检",subtype:"体检组成聚合口的成员口是否跨机箱"};var n=0;e.warnInstance.emit("check_start",t);var s={dev:e.sn,type:"高可用体检",subtype:"体检组成聚合口的成员口是否跨机箱",level:"success",desc:"",advice:""};e.warnInstance.emit("check_result",s);e.warnInstance.emit("check_end",t,n)};c.prototype.ignorecheckVslAndBfdDiff=function(){var e=this;var t={type:"高可用体检",subtype:"体检VSL是否与双主机体检使用同一块线卡口"};var n=0;e.warnInstance.emit("check_start",t);var s={dev:e.sn,type:"高可用体检",subtype:"体检VSL是否与双主机体检使用同一块线卡口",level:"success",desc:"",advice:""};e.warnInstance.emit("check_result",s);e.warnInstance.emit("check_end",t,n)};c.prototype.ignorecheckCrossLine=function(){var e=this;var t={type:"高可用体检",subtype:"体检VSL链路是否跨线卡"};var n=0;e.emit("check_start",t);var s={dev:e.sn,type:"高可用体检",subtype:"体检VSL链路是否跨线卡",level:"success",desc:"",advice:""};e.warnInstance.emit("check_result",s);e.warnInstance.emit("check_end",t,n)};c.prototype.checkFunctions=function(){this.warnInstance.configChangeCheck();this.warnInstance.deviceExceptionCheck();this.warnInstance.exceptionLoggingCheck();this.warnInstance.macNumCheck();this.warnInstance.arpNumCheck();this.warnInstance.dhcpSnoopingCheck();this.warnInstance.nfppCheck();this.warnInstance.packageCheck();this.warnInstance.errPortCheck();this.warnInstance.aggMemberCheck();this.warnInstance.staNumCheck();if(this.warnInstance.instance.checkIfVsuDevice()){this.warnInstance.checkDualActive();this.warnInstance.checkRouteDoubleUplink();this.warnInstance.checkApCrossDevice();this.warnInstance.checkVslAndBfdDiff();this.warnInstance.checkCrossLine()}else{this.ignorecheckDualActive();this.ignorecheckRouteDoubleUplink();this.ignorecheckApCrossDevice();this.ignorecheckVslAndBfdDiff();this.ignorecheckCrossLine()}this.warnInstance.checkDot1xAuth();this.warnInstance.checkVoiceQosVlan()};module.exports=c})();