(function(){var t=0;var e=0;var r=0;"use strict";var s=require("util");var i=require("events");var d=require("moment");var n=require("./jsUtil");var a=require("./Logger").getLogger("rtpsMgr.js");var o=60;if(e){o=5}function m(){var t=this;t.srcAddr="";t.dstAddr="";t.srcPort=0;t.dstPort=0;t.ssrc=0;t.setAddr=function(t,e){var r=this;r.srcAddr=t;r.dstAddr=e;return r};t.setPort=function(t,e){var r=this;r.srcPort=t;r.dstPort=e;return r};t.setRtp=function(t){var e=this;e.ssrc=t;return e};t.toString=function(){return t.srcAddr+":"+t.srcPort+":"+t.dstAddr+":"+t.dstPort+":"+t.ssrc}}exports.RtpKey=m;function u(e){var r=this;i.EventEmitter.call(r);r.rtpKey=e;r._timer=setTimeout(function(){r.emit("end",r)},o*1e3);r.resetTimer=function(){if(r._timer!=null){clearTimeout(r._timer)}r._timer=setTimeout(function(){r.emit("end",r)},o*1e3)};r._pktInfos=[];r.addPktInfo=function(e,s,i){var d={seq:e,timestamp:s,capTime:i};if(r._pktInfos.length>0){var n=r._pktInfos[r._pktInfos.length-1];if(d.seq<=n.seq||d.timestamp<=n.timestamp||d.capTime<n.capTime){if(t)a.debug("packet out of sequence",n,d);return false}}r._pktInfos.push(d);r.resetTimer();return true};r.getStartTime=function(){return r._pktInfos[0].capTime};r.getLastTime=function(){return r._pktInfos[r._pktInfos.length-1].capTime};r.compute=function(){var t=r._pktInfos.length;if(t<2){return null}var e=0,s=1,i=0;var d=r._pktInfos[0];for(var n=1;n<r._pktInfos.length;++n){var a=r._pktInfos[n];e+=a.seq-d.seq-1<0?0:a.seq-d.seq-1;s+=a.seq-d.seq<0?0:a.seq-d.seq;i+=a.capTime-d.capTime;d=a}var o=e/s;var m=i/(t-1);var u=0,c=null,l=null;var d=r._pktInfos[0];for(var n=1;n<r._pktInfos.length;++n){var a=r._pktInfos[n];var T=a.capTime-d.capTime-m;if(T<0)T=0-T;u+=T;c=c===null?T:c<T?T:c;l=l===null?T:l>T?T:l;d=a}u=u/(t-1);var f=r.getLastTime()-r.getStartTime();return{lossRate:o,delayTime:m,jitterTime:u,jitterTimeMax:c,jitterTimeMin:l,duringTime:f/1e3,startTime:r.startTime}}}s.inherits(u,i.EventEmitter);function c(){var t=this;i.EventEmitter.call(t);t._sessions={};t._db=null}s.inherits(c,i.EventEmitter);c.prototype.addPktInfo=function(e,r,s,i){var o=this;if(t)a.debug("[RtpSessionMgr.addPktInfo]","rtpKey:",e,"seq:",r,"timestamp:",s,"capTime:",i);if(!n.isValidVar(e)||!n.isValidVar(r)||!n.isValidVar(s)||!n.isValidVar(i)){return false}var m=false;var c=o._sessions[e.toString()];if(c===undefined){c=new u(e);o._sessions[e.toString()]=c;c.on("end",function(t){o.emit("data",t.rtpKey,t.compute());delete o._sessions[e.toString()]});m=true}c.addPktInfo(r,s,i);if(m){c.startTime=d().format("YYYY-MM-DD HH:mm:ss");o.emit("start",e)}return true};c.prototype.getStartTime=function(t){var e=this;if(!n.isValidVar(t)){return null}var r=e._sessions[t.toString()];if(r===undefined){return null}return r.getStartTime()};c.prototype.getLastTime=function(t){var e=this;if(!n.isValidVar(t)){return null}var r=e._sessions[t.toString()];if(r===undefined){return null}return r.getLastTime()};c.prototype.getResult=function(e){var r=this;if(t)a.debug("[RtpSessionMgr.getResult]","rtpKey:",e);if(!n.isValidVar(e)){return null}var s=r._sessions[e.toString()];if(s===undefined){return null}return s.compute()};c.prototype.setDb=function(e,r){var s=this;if(t)a.debug("[RtpSessionMgr.setDb]");if(!n.isValidVar(e)){return false}if(s._db!==null){return false}e.serialize();s._db=e;s.dbMgr=r;s._db.run("CREATE TABLE IF NOT EXISTS measure_rtp("+"srcAddr VARCHAR(32),"+"dstAddr VARCHAR(32),"+"srcPort INTEGER,"+"dstPort INTEGER,"+"ssrc INTEGER,"+"lossRate FLOAT,"+"delayTime FLOAT,"+"jitterTime FLOAT,"+"jitterTimeMax FLOAT,"+"jitterTimeMin FLOAT,"+"startTime DATETIME,"+"endTime DATETIME,"+"duringTime FLOAT,"+"good INTEGER,"+"PRIMARY KEY(srcAddr, dstAddr, srcPort, dstPort, ssrc, startTime)"+");");s.on("data",function(t,e){s.addDb(t,e)});return true};c.prototype.addDb=function(t,e){var r=this;if(e==null){return}if(r._db===null){return false}var s=0;if(l(e)){s=1}var i=d(e.startTime).add(e.duringTime,"second").format("YYYY-MM-DD HH:mm:ss");var n="INSERT INTO measure_rtp(srcAddr, dstAddr, srcPort, dstPort, ssrc,lossRate, delayTime, jitterTime, jitterTimeMax, jitterTimeMin,startTime,endTime,duringTime,good) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?);";var o=[t.srcAddr,t.dstAddr,t.srcPort,t.dstPort,t.ssrc,e.lossRate,e.delayTime,e.jitterTime,e.jitterTimeMax,e.jitterTimeMin,e.startTime,i,e.duringTime,s];var m=function(t){if(t){a.debug("[Error: REPLACE INTO measure_rtp] "+t)}};r.dbMgr.run(n,o,m,["measure_rtp"]);return true};c.prototype.getAll=function(t){var e=this;if(e._db===null){return false}e._db.all("SELECT * FROM measure_rtp",function(e,r){if(t instanceof Function){t(e,r)}});return true};c.prototype.getLastestUsersAndRate=function(t){var e=this;if(e._db===null){return false}var r={};r.endTime=d().format("YYYY-MM-DD HH:mm:ss");r.startTime=d().add(-1,"hours").format("YYYY-MM-DD HH:mm:ss");var s="SELECT strftime('%Y-%m-%d %H:00:00', endTime) as timeIntervals,count(*) as count_all,sum(good) as count_good,"+"(count(*)-sum(good)) as count_notgood,total(good)/count(*) as good_percent "+"FROM measure_rtp WHERE  (endTIme BETWEEN '"+r.startTime+"' AND '"+r.endTime+"')  GROUP BY strftime('%Y-%m-%d %H:00:00', endTime)"+"order by strftime('%Y-%m-%d %H:00:00', endTime) desc limit 1";e._db.all(s,function(e,r){t(e,r)});return true};c.prototype.getHistoryMaxUsersAndRate=function(t){var e=this;if(e._db===null){return false}var r="SELECT max(A.count_all) as maxcount,max(A.good_percent) as max_good_percent FROM (SELECT strftime('%Y-%m-%d %H:00:00', endTime) as timeIntervals,"+"count(*) as count_all,sum(good) as count_good,(count(*)-sum(good)) as count_notgood,total(good)/count(*) as good_percent "+"FROM measure_rtp  GROUP BY strftime('%Y-%m-%d %H:00:00', endTime))A";e._db.all(r,function(e,r){t(e,r)});return true};c.prototype.getRtpUsersAndRate=function(t,e){var r=this;if(r._db===null){return false}if(t.interval=="hour"){var s="SELECT strftime('%H:00', endTime) as timeIntervals,count(*) as count_all,sum(good) as count_good,"+"(count(*)-sum(good)) as count_notgood,total(good)/count(*) as good_percent "+"FROM measure_rtp WHERE  (endTime BETWEEN '"+t.startTime+"' AND '"+t.endTime+"')  GROUP BY strftime('%Y-%m-%d %H:00:00', endTime)";r._db.all(s,function(t,r){e(t,r)})}else if(t.interval=="day"){var s="SELECT strftime('%m-%d', endTime) as timeIntervals,count(*) as count_all,sum(good) as count_good,"+"(count(*)-sum(good)) as count_notgood,total(good)/count(*) as good_percent "+"FROM measure_rtp WHERE  (endTime BETWEEN '"+t.startTime+"' AND '"+t.endTime+"')  GROUP BY  strftime('%m-%d', endTime)";r._db.all(s,function(t,r){e(t,r)})}return true};c.prototype.queryTypeFromDb=function(t,e){var r=this;var s="select * from measure_rtp";var i=0;if(t!=null){s+=" where ";if(t.srcAddr!=""){s+="(srcAddr="+"'"+t.srcAddr+"')";i++}if(t.dstAddr!=""){if(i!=0){s+=" and (dstAddr="+"'"+t.dstAddr+"')"}else{s+="(dstAddr="+"'"+t.dstAddr+"')"}i++}if(t.srcPort!=""){if(i!=0){s+=" and (srcPort="+"'"+t.srcPort+"')"}else{s+="(srcPort="+"'"+t.srcPort+"')"}i++}if(t.dstPort!=""){if(i!=0){s+=" and (dstPort="+"'"+t.dstPort+"')"}else{s+="(dstPort="+"'"+t.dstPort+"')"}i++}if(t.ssrc!=""){if(i!=0){s+=" and (ssrc="+"'"+t.ssrc+"')"}else{s+="(ssrc="+"'"+t.ssrc+"')"}i++}if(t.startTime!=""&&t.endTime!=""){if(i!=0){s+=" and (endTime between "+"'"+t.startTime+"'"+" and "+"'"+t.endTime+"')"}else{s+="endTime between "+"'"+t.startTime+"'"+" and "+"'"+t.endTime+"'"}}}s+=" order by endTime desc limit 1000";r._db.all(s,function(t,r){e(t,r)})};c.prototype.getVoiceCallRadarQuality=function(t,e){var r=this;if(r._db===null){return false}this._db.all("SELECT avg(lossRate) as avgLossRate,avg(delayTime) as avgDelayTime,avg(jitterTime) as avgJitterTime FROM measure_rtp WHERE (endTime BETWEEN ? AND ?) ;",[t.startTime,t.endTime],function(t,r){e(t,r)});return true};c.prototype.getTopVoiceCall=function(t,e){var r=this;if(r._db===null){return false}this._db.all("select dstAddr,count(*) as num  from measure_rtp  WHERE  (endTime BETWEEN ? AND ?) GROUP BY dstAddr ORDER BY count(*) desc limit 5;",[t.startTime,t.endTime],function(t,r){e(t,r)});return true};c.prototype.getTopDelayTimeBadExpCall=function(t,e){var r=this;if(r._db===null){return false}this._db.all("select dstAddr,max(delayTime) as badDelayTime  from measure_rtp  WHERE  (endTime BETWEEN ? AND ?) GROUP BY dstAddr ORDER BY max(delayTime) desc limit 5;",[t.startTime,t.endTime],function(t,r){e(t,r)});return true};c.prototype.getTopJitterTimeBadExpCall=function(t,e){var r=this;if(r._db===null){return false}this._db.all("select dstAddr,max(jitterTime) as badJitterTime  from measure_rtp  WHERE  (endTime BETWEEN ? AND ?)  GROUP BY dstAddr ORDER BY max(jitterTime) desc limit 5;",[t.startTime,t.endTime],function(t,r){e(t,r)});return true};c.prototype.getTopLossRateBadExpCall=function(t,e){var r=this;if(r._db===null){return false}this._db.all("select dstAddr,max(lossRate) as badLossRate  from measure_rtp  WHERE  (endTime BETWEEN ? AND ?)  GROUP BY dstAddr ORDER BY max(lossRate) desc limit 5;",[t.startTime,t.endTime],function(t,r){e(t,r)});return true};c.prototype.getTopCallTime=function(t,e){var r=this;if(r._db===null){return false}this._db.all("select dstAddr,sum(duringTime) as duringTimes from measure_rtp  WHERE  (endTime BETWEEN ? AND ?) GROUP BY dstAddr ORDER BY sum(duringTime) desc limit 5;",[t.startTime,t.endTime],function(t,r){e(t,r)});return true};exports.RtpSessionMgr=c;function l(t){if(!n.isValidVar(t)){return null}return t.lossRate<=.01&&t.delayTime<=30+20&&t.jitterTime<=150}exports.measureRtp=l;if(r){var T=function(t,e){var r=new m;r.setAddr(e.rtpKey.srcAddr,e.rtpKey.dstAddr).setPort(e.rtpKey.srcPort,e.rtpKey.dstPort).setRtp(e.rtpKey.ssrc);t.addPktInfo(r,e.seq,e.timestamp,e.capTime[0]*1e3+e.capTime[1]/1e6)};var f=require("sqlite3").verbose();var p=new f.Database("./xx.db");var g=new c;var E=require("./dbMgr");var v=new E(p,3e3);g.setDb(p,v);g.on("start",function(t){var e=g.getStartTime(t);var r=g.getLastTime(t);a.debug("==================================");a.debug("startTime:",e,"duringTime:",r-e);a.debug("rtpKey:",t)});g.on("data",function(t){var e=g.getStartTime(t);var r=g.getLastTime(t);var s=g.getResult(t);a.debug("==================================");a.debug("startTime:",e,"duringTime:",r-e);a.debug("rtpKey:",t);a.debug("result:",s);a.debug("measure:",l(s))});T(g,{rtpKey:{srcAddr:"10.61.243.72",dstAddr:"10.61.93.150",srcPort:17550,dstPort:4e4,ssrc:279721468},seq:27189,timestamp:1413173782,capTime:[1734273,158187234]});T(g,{rtpKey:{srcAddr:"10.61.243.72",dstAddr:"10.61.93.150",srcPort:17550,dstPort:4e4,ssrc:279721468},seq:27190,timestamp:1413173942,capTime:[1734273,163254735]});T(g,{rtpKey:{srcAddr:"10.61.243.72",dstAddr:"10.61.93.150",srcPort:17550,dstPort:4e4,ssrc:279721468},seq:27191,timestamp:1413174102,capTime:[1734273,166806536]});T(g,{rtpKey:{srcAddr:"10.61.243.72",dstAddr:"10.61.93.150",srcPort:17550,dstPort:4e4,ssrc:279721468},seq:27192,timestamp:1413174262,capTime:[1734273,168981572]});T(g,{rtpKey:{srcAddr:"10.61.93.150",dstAddr:"10.20.16.192",srcPort:4e4,dstPort:10314,ssrc:2705443},seq:1,timestamp:160,capTime:[1734273,170720201]});T(g,{rtpKey:{srcAddr:"10.61.243.72",dstAddr:"10.61.93.150",srcPort:17550,dstPort:4e4,ssrc:279721468},seq:27193,timestamp:1413174422,capTime:[1734273,173147212]});T(g,{rtpKey:{srcAddr:"10.61.93.150",dstAddr:"10.20.16.192",srcPort:4e4,dstPort:10314,ssrc:2705443},seq:2,timestamp:320,capTime:[1734273,175232657]});T(g,{rtpKey:{srcAddr:"10.61.243.72",dstAddr:"10.61.93.150",srcPort:17550,dstPort:4e4,ssrc:279721468},seq:27194,timestamp:1413174582,capTime:[1734273,177419592]});T(g,{rtpKey:{srcAddr:"10.61.93.150",dstAddr:"10.20.16.192",srcPort:4e4,dstPort:10314,ssrc:2705443},seq:3,timestamp:480,capTime:[1734273,181883402]});T(g,{rtpKey:{srcAddr:"10.61.243.72",dstAddr:"10.61.93.150",srcPort:17550,dstPort:4e4,ssrc:279721468},seq:27195,timestamp:1413174742,capTime:[1734273,185882109]})}})();