(function(){var e=0;"use strict";var t=require("util");var i=require("events");var a=require("moment");var r=require("./jsUtil");function s(e,t){i.EventEmitter.call(this);if(false===this instanceof s){return new s}this.setupDb(e);this.dbMgr=t}t.inherits(s,i.EventEmitter);s.prototype.setupDb=function(e){var t=this;var i="CREATE TABLE IF NOT EXISTS device_perf_table(deviceName VARCHAR(32),seriaNo VARCHAR(32), time DATETIME, type VARCHAR(12), used INTEGER, PRIMARY KEY(deviceName, seriaNo, time));";var a="CREATE TABLE IF NOT EXISTS device_uptime_table(deviceName VARCHAR(32),seriaNo VARCHAR(32), time DATETIME, uptime VARCHAR(32), PRIMARY KEY(deviceName, seriaNo));";var r="CREATE TABLE IF NOT EXISTS device_sta_table(deviceName VARCHAR(32),seriaNo VARCHAR(32), time DATETIME, type VARCHAR(12), used INTEGER, PRIMARY KEY(deviceName, seriaNo, time));";this.db=e;this.db.serialize(function(){t.db.run(i);t.db.run(a);t.db.run(r)})};s.prototype.insertAndUpdatePerfTable=function(e,t){var i=this;var r=a().format("YYYY-MM-DD HH:mm:ss");var s={seriaNo:typeof e.seriaNo!=="undefined"?e.seriaNo:"xxxxxxx",deviceName:typeof e.deviceName!=="undefined"?e.deviceName:"vsu1",type:"cpu",used:typeof e.used!=="undefined"?e.used:0};i.db.run("INSERT INTO device_perf_table(time, deviceName,seriaNo, type, used) "+"VALUES (?, ?, ?, ?, ?);",[r,s.deviceName,s.seriaNo,s.type,s.used],function(e){if(e){t(e)}else{t(null)}})};s.prototype.insertAndUpdateStaTable=function(e,t){var i=this;var s=a().format("YYYY-MM-DD HH:mm:ss");var n={seriaNo:typeof e.seriaNo!=="undefined"?e.seriaNo:"xxxxxxx",deviceName:typeof e.deviceName!=="undefined"?e.deviceName:"vsu1",type:typeof e.type!=="undefined"?e.type:"xxx",used:typeof e.used!=="undefined"?e.used:0,daystr:typeof e.daystr!=="undefined"?e.daystr:s};var m=r.strFormat("INSERT INTO device_sta_table(time, deviceName,seriaNo, type, used)"+" VALUES ('{0}', '{1}', '{2}', '{3}','{4}');\n",n.daystr,n.deviceName,n.seriaNo,n.type,n.used);i.dbMgr.insertSqlIntoList(m,"warn_table",function(e){if(e){log.debug("[Error: insertAndUpdateStaTable] "+e);t(error)}else{t(null)}})};s.prototype.insertUptimeIntoTable=function(e,t){var i=this;var r=a().format("YYYY-MM-DD HH:mm:ss");var s={seriaNo:typeof e.seriaNo!=="undefined"?e.seriaNo:"xxxxxxx",deviceName:typeof e.deviceName!=="undefined"?e.deviceName:"vsu1",uptime:typeof e.uptime!=="undefined"?e.uptime:"0:0:0:0"};i.db.run("INSERT INTO device_uptime_table(time, deviceName,seriaNo, uptime) "+"VALUES (?, ?, ?, ?);",[r,s.deviceName,s.seriaNo,s.uptime],function(e){console.log(e);if(e){t(e)}else{t(null)}})};function n(e){var t=0;var i=0;var a=0;var r=0;e=parseInt(e/1e3);if(e>=24*60*60){t=parseInt(e/(24*60*60));e=e-t*24*60*60}if(e>=60*60){i=parseInt(e/(60*60));e=e-i*60*60}if(e>=60){a=parseInt(e/60);e=e-a*60}if(e>=0){r=e}var s={day:t,hour:i,minute:a,second:r};console.log(s);return s}function m(e,t){var i=new Date;var a=Date.parse(e);var r=i-a;var s=n(r);var m=t.split(":");s.day=s.day+Math.ceil(m[0]);s.hour=s.hour+Math.ceil(m[1]);s.minute=s.minute+Math.ceil(m[2]);s.second=s.second+Math.ceil(m[3]);var d=""+s.day+":"+s.hour+":"+s.minute+":"+s.second;return d}s.prototype.getUptimeFromTable=function(e,t){var i=this;this.db.all("SELECT * FROM device_uptime_table WHERE deviceName = ?;",[e],function(e,i){if(i.length==0){t("0:0:0:0")}else{var a=i[0].time;var r=i[0].uptime;var s=m(a,r);t(s)}})};s.prototype.queryAvgCpuUsedRateFromDb=function(e,t){var i=this;console.log("interval = "+e.interval);console.log("startTime = "+e.startTime);console.log("name = "+e.deviceName);console.log("endTime = "+e.endTime);if(e.interval=="hour"){this.db.all("SELECT strftime('%Y-%m-%d %H:00:00', time) as timeInterval, avg(used) as used FROM device_perf_table WHERE deviceName = ? AND type='cpu' AND (time BETWEEN ? AND ?) GROUP BY timeInterval;",[e.deviceName,e.startTime,e.endTime],function(e,i){t(e,i)})}else if(e.interval=="day"){this.db.all("SELECT strftime('%Y-%m-%d', time) as timeInterval, avg(used) as used FROM device_perf_table WHERE deviceName = ? AND type='cpu' AND (time BETWEEN ? AND ?) GROUP BY timeInterval;",[e.deviceName,e.startTime,e.endTime],function(e,i){t(e,i)})}};s.prototype.queryMaxCpuUsedRateFromDb=function(e,t){var i=this;if(e.interval=="hour"){this.db.all("SELECT strftime('%Y-%m-%d %H:00:00', time) as timeInterval, max(used) as used FROM device_perf_table WHERE deviceName = ? AND (type='cpu') AND (time BETWEEN ? AND ?) GROUP BY timeInterval;",[e.deviceName,e.startTime,e.endTime],function(e,i){t(e,i)})}else if(e.interval=="day"){this.db.all("SELECT strftime('%Y-%m-%d', time) as timeInterval, max(used) as used FROM device_perf_table WHERE deviceName = ? AND (type='cpu') AND (time BETWEEN ? AND ?) GROUP BY timeInterval;",[e.deviceName,e.startTime,e.endTime],function(e,i){t(e,i)})}};s.prototype.queryMaxThroughoutputFromDb=function(e,t){var i=this;if(e.interval=="hour"){this.db.all("SELECT strftime('%Y-%m-%d %H:00:00', A.time) as timeInterval, max(A.thrput) as thrput from (SELECT time, sum(sendBytes + rcvBytes)/interval as thrput FROM intf_flow_table WHERE deviceName = ? AND (time BETWEEN ? AND ?) GROUP BY time)A GROUP BY timeInterval;",[e.deviceName,e.startTime,e.endTime],function(e,i){t(e,i)})}else if(e.interval=="day"){this.db.all("SELECT strftime('%Y-%m-%d', A.time) as timeInterval, max(A.thrput) as thrput from (SELECT time, sum(sendBytes + rcvBytes)/interval as thrput FROM intf_flow_table WHERE deviceName = ? AND (time BETWEEN ? AND ?) GROUP BY time)A GROUP BY timeInterval;",[e.deviceName,e.startTime,e.endTime],function(e,i){t(e,i)})}};s.prototype.queryThroughoutputFromDb=function(e,t){var i=this;if(e.interval=="hour"){this.db.all("SELECT strftime('%Y-%m-%d %H:00:00', A.time) as timeInterval, avg(A.thrput) as thrput from (SELECT time, sum(sendBytes + rcvBytes)/interval as thrput FROM intf_flow_table WHERE deviceName = ? AND (time BETWEEN ? AND ?) GROUP BY time)A GROUP BY timeInterval;",[e.deviceName,e.startTime,e.endTime],function(e,i){t(e,i)})}else if(e.interval=="day"){this.db.all("SELECT strftime('%Y-%m-%d', A.time) as timeInterval, avg(A.thrput) as thrput from (SELECT time, sum(sendBytes + rcvBytes)/interval as thrput FROM intf_flow_table WHERE deviceName = ? AND (time BETWEEN ? AND ?) GROUP BY time)A GROUP BY timeInterval;",[e.deviceName,e.startTime,e.endTime],function(e,i){t(e,i)})}};s.prototype.queryAllDevThroughoutputFromDb=function(e,t){var i=this;if(e.interval=="hour"){this.db.all("SELECT strftime('%Y-%m-%d %H:00:00', time) as timeInterval,sum(sendBytes + rcvBytes) as thrput FROM intf_flow_table WHERE (time BETWEEN ? AND ?) GROUP BY timeInterval;",[e.startTime,e.endTime],function(e,i){t(e,i)})}else if(e.interval=="day"){this.db.all("SELECT strftime('%Y-%m-%d', time) as timeInterval,sum(sendBytes + rcvBytes) as thrput FROM intf_flow_table WHERE (time BETWEEN ? AND ?) GROUP BY timeInterval;",[e.startTime,e.endTime],function(e,i){t(e,i)})}};s.prototype.queryAllStaNumFromDb=function(e,t){var i=this;if(e.interval=="hour"){this.db.all("select strftime('%Y-%m-%d %H:00:00', A.timeIntervals) as timeInterval, max(A.used) as used from (SELECT strftime('%Y-%m-%d %H:%M:00', time) as timeIntervals, sum(used) as used FROM device_sta_table WHERE   type='staNum' AND (time BETWEEN ? AND ?) GROUP BY timeIntervals)A  GROUP BY timeInterval;",[e.startTime,e.endTime],function(e,i){t(e,i)})}else if(e.interval=="day"){this.db.all("SELECT strftime('%Y-%m-%d', time) as timeInterval, sum(used) as used FROM device_sta_table WHERE type='staNum' AND (time BETWEEN ? AND ?) GROUP BY timeInterval;",[e.startTime,e.endTime],function(e,i){t(e,i)})}};s.prototype.queryAllDevFromDb=function(e){var t=this;this.db.all("select count(*) as num, deviceType from device_table group by deviceType",function(t,i){e(t,i)})};s.prototype.queryAllDevPositionFromDb=function(e){var t=this;var i=require("fs");var a=require("./jsUtil");var s=a.getDataPath();var n=s+"/config";var m=s+"/config/device_positon.json";var d="";if(!r.fsExistsSync(n)){i.mkdirSync(n)}this.exists=r.fsExistsSync(m);if(this.exists){var o=i.readFileSync(m,"utf-8");d=JSON.parse(o)}else{var v="设备名";var u={"char":"具体位置"};i.writeFileSync(m,JSON.stringify(u,null,"	"),"utf-8")}var l=function(e){var t=typeof d[e]!=="undefined"?d[e]:"设备位置未知";return t};var E={Switch:"20#3楼",GATEWAY:"20#3楼",AP:"20#3楼",AC:"20#3楼",Router:"19#1楼","-":"19#2楼"};var f=[];this.db.all("select deviceName,seriaNo from device_link",function(t,i){if(t){e(t,null);return}f=i;for(var a=0;a<i.length;a++){f[a]["position"]=l(i[a].deviceName)}var r=[];var s=function(e){var t=false;for(var i=0;i<r.length;i++){if(e.position==r[i].position){t=true;r[i].num++;break}}if(t==false){var a={num:1,position:e.position};r.push(a)}};for(var a=0;a<f.length;a++){s(f[a])}e(t,r)})};s.prototype.queryDeviceTopFlowAndPercent=function(e,t){var i=this;this.db.all("SELECT deviceName,seriaNo,sum(sendBytes + rcvBytes) as thrput FROM intf_flow_table WHERE ( time BETWEEN ? AND ?) GROUP BY deviceName,seriaNo order by sum(sendBytes + rcvBytes) desc  limit 5;",[e.startTime,e.endTime],function(e,i){if(e){t(e,i);return}t(e,i)})};s.prototype.queryDeviceIntfTopFlowAndPercent=function(e,t){var i=this;this.db.all("SELECT deviceName,seriaNo,intfName,sum(sendBytes + rcvBytes) as thrput FROM intf_flow_table WHERE ( time BETWEEN ? AND ?) GROUP BY deviceName,seriaNo,intfName order by sum(sendBytes + rcvBytes) desc  limit 5;",[e.startTime,e.endTime],function(e,i){if(e){t(e,i);return}t(e,i)})};s.prototype.queryBwUsedRateFromDb=function(e,t){var i=this;if(e.interval=="hour"){this.db.all("SELECT strftime('%Y-%m-%d %H:00:00', A.time) as timeInterval, avg(A.bwRate) as bwRate from (SELECT time, sum(sendBytes + rcvBytes)*8/(sum(bandwidth)*1000*interval) as bwRate FROM intf_flow_table WHERE deviceName = ? AND (status = 'up') AND (time BETWEEN ? AND ?) GROUP BY time)A GROUP BY timeInterval;",[e.deviceName,e.startTime,e.endTime],function(e,i){t(e,i)})}else if(e.interval=="day"){this.db.all("SELECT strftime('%Y-%m-%d', A.time) as timeInterval, avg(A.bwRate) as bwRate from (SELECT time, sum(sendBytes + rcvBytes)*8/(sum(bandwidth)*1000*interval) as bwRate FROM intf_flow_table WHERE deviceName = ? AND (status = 'up') AND (time BETWEEN ? AND ?) GROUP BY time)A GROUP BY timeInterval;",[e.deviceName,e.startTime,e.endTime],function(e,i){t(e,i)})}};s.prototype.queryMaxBwUsedRateFromDb=function(e,t){var i=this;if(e.interval=="hour"){this.db.all("SELECT strftime('%Y-%m-%d %H:00:00', A.time) as timeInterval, max(A.bwRate) as bwRate from (SELECT time, sum(sendBytes + rcvBytes)*8/(sum(bandwidth)*1000*interval) as bwRate FROM intf_flow_table WHERE deviceName = ? AND (status = 'up') AND (time BETWEEN ? AND ?) GROUP BY time)A GROUP BY timeInterval;",[e.deviceName,e.startTime,e.endTime],function(e,i){t(e,i)})}else if(e.interval=="day"){this.db.all("SELECT strftime('%Y-%m-%d', A.time) as timeInterval, max(A.bwRate) as bwRate from (SELECT time, sum(sendBytes + rcvBytes)*8/(sum(bandwidth)*1000*interval) as bwRate FROM intf_flow_table WHERE deviceName = ? AND (status = 'up') AND (time BETWEEN ? AND ?) GROUP BY time)A GROUP BY timeInterval;",[e.deviceName,e.startTime,e.endTime],function(e,i){t(e,i)})}};module.exports=s})();