(function(){var e=0;"use strict";var t=require("util");var i=require("events");var n=require("moment");var s=require("./dbMgr");var a=require("./jsUtil");function o(e){i.EventEmitter.call(this);if(false===this instanceof o){return new o}this.setupDb(e);this.dbMgrInstance=new s(e)}t.inherits(o,i.EventEmitter);o.prototype.setupDb=function(e){var t=this;var i="CREATE TABLE IF NOT EXISTS device_intf_table(deviceName VARCHAR(32),seriaNo VARCHAR(32), intfName VARCHAR(32), intfClass VARCHAR(32), descs VARCHAR(32), status VARCHAR(10), adminStatus VARCHAR(10), ip VARCHAR(32), ipv6 VARCHAR(64), sendBytes DOUBLE, rcvBytes DOUBLE, drops INTEGER, errors INTEGER, crcs INTEGER, bandwidth INTEGER, negoSpeed VARCHAR(32),PRIMARY KEY(deviceName, seriaNo,intfName));";var n="CREATE TABLE IF NOT EXISTS intf_flow_table(id INTEGER PRIMARY KEY AUTOINCREMENT, deviceName VARCHAR(32), seriaNo VARCHAR(32), intfName VARCHAR(32), time DATETIME, sendBytes DOUBLE, rcvBytes DOUBLE, status VARCHAR(10), bandwidth INTEGER, interval INTEGER);";var s="CREATE TABLE IF NOT EXISTS device_intf_conf(deviceName VARCHAR(32),seriaNo VARCHAR(32),intfName VARCHAR(32),updown_link_type VARCHAR(32),PRIMARY KEY(deviceName,seriaNo, intfName));";this.db=e;this.db.serialize(function(){t.db.run(i);t.db.run(n);t.db.run(s)})};o.prototype.insertAndUpdateIntoIntf=function(e,t){var i=this;var n={seriaNo:typeof e.seriaNo!=="undefined"?e.seriaNo:"xxxxxxx",deviceName:typeof e.deviceName!=="undefined"?e.deviceName:"vsu1",intfName:typeof e.intfName!=="undefined"?e.intfName:"",intfClass:typeof e.intfClass!=="undefined"?e.intfClass:"physical",descs:typeof e.descs!=="undefined"?e.descs:"",ip:typeof e.ip!=="undefined"?e.ip:"no ip address",ipv6:typeof e.ipv6!=="undefined"?e.ipv6:"no ip address",sendBytes:typeof e.sendBytes!=="undefined"?e.sendBytes:0,rcvBytes:typeof e.rcvBytes!=="undefined"?e.rcvBytes:0,drops:typeof e.drops!=="undefined"?e.drops:0,errors:typeof e.errors!=="undefined"?e.errors:0,crcs:typeof e.crcs!=="undefined"?e.crcs:0,negoSpeed:typeof e.negoSpeed!=="undefined"?e.negoSpeed:"unknown",status:typeof e.status!=="undefined"?e.status:"down",adminStatus:typeof e.adminStatus!=="undefined"?e.adminStatus:"up",bandwidth:typeof e.bandwidth!=="undefined"?e.bandwidth:0};i.db.run("REPLACE INTO device_intf_table(deviceName,seriaNo, intfName, intfClass, descs, ip, ipv6, sendBytes, rcvBytes,drops,errors,crcs,negoSpeed,status, adminStatus, bandwidth) "+"VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?);",[n.deviceName,n.seriaNo,n.intfName,n.intfClass,n.descs,n.ip,n.ipv6,n.sendBytes,n.rcvBytes,n.drops,n.errors,n.crcs,n.negoSpeed,n.status,n.adminStatus,n.bandwidth],function(e){if(e){t(e)}else{t(null)}})};o.prototype.insertAndUpdateIntfBatch=function(e,t){var i="REPLACE INTO device_intf_table(deviceName,seriaNo, intfName, intfClass, descs, ip, ipv6, sendBytes, rcvBytes,drops,errors,crcs,negoSpeed,status, adminStatus, bandwidth) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?);";var n=this;for(var s=0;s<e.length;s++){var a=[e[s].deviceName,e[s].seriaNo,e[s].intfName,e[s].intfClass,e[s].descs,e[s].ip,e[s].ipv6,e[s].sendBytes,e[s].rcvBytes,e[s].drops,e[s].errors,e[s].crcs,e[s].negoSpeed,e[s].status,e[s].adminStatus,e[s].bandwidth];n.dbMgrInstance.run(i,a,t,["device_intf_table"])}};o.prototype.insertIntoIntfFlowBatch=function(e,t){var i=this;var s="INSERT INTO intf_flow_table(time, deviceName, seriaNo, intfName, sendBytes, rcvBytes, bandwidth, status, interval) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?);";var a=n().format("YYYY-MM-DD HH:mm:ss");for(var o=0;o<e.length;o++){var f=[a,e[o].deviceName,e[o].seriaNo,e[o].intfName,e[o].sendBytes,e[o].rcvBytes,e[o].bandwidth,e[o].status,e[o].interval];i.dbMgrInstance.run(s,f,t,["intf_flow_table"])}};o.prototype.insertIntoIntfFlow=function(e,t){var i=n().format("YYYY-MM-DD HH:mm:ss");console.log("parameter in intfflow"+e);var s={seriaNo:typeof e.seriaNo!=="undefined"?e.seriaNo:"-",deviceName:typeof e.deviceName!=="undefined"?e.deviceName:"",intfName:typeof e.intfName!=="undefined"?e.intfName:"",sendBytes:typeof e.sendBytes!=="undefined"?e.sendBytes:0,rcvBytes:typeof e.rcvBytes!=="undefined"?e.rcvBytes:0,bandwidth:typeof e.bandwidth!=="undefined"?e.bandwidth:0,status:typeof e.status!=="undefined"?e.status:"up",interval:typeof e.interval!=="undefined"?e.interval:30};this.db.run("INSERT INTO intf_flow_table(time, deviceName, seriaNo, intfName, sendBytes, rcvBytes, bandwidth, status, interval) "+"VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?);",[i,s.deviceName,s.seriaNo,s.intfName,s.sendBytes,s.rcvBytes,s.bandwidth,s.status,s.interval],function(e){if(e){t(e)}else{t(null)}})};o.prototype.deleteFromIntfByName=function(e,t){this.db.run("DELETE FROM device_intf_table where deviceName = ?;",[e.deviceName],function(e){if(t!=undefined){if(e){t(e)}else{t(null)}}})};o.prototype.deleteFromDeviceIntfConfByName=function(e,t){this.db.run("DELETE FROM device_intf_conf where deviceName = ?;",[e.deviceName],function(e){if(t!=undefined){if(e){t(e)}else{t(null)}}})};o.prototype.deleteFromIntfFlowByName=function(e,t){this.db.run("DELETE FROM intf_flow_table where deviceName = ?;",[e.deviceName],function(e){if(t!=undefined){if(e){t(e)}else{t(null)}}})};o.prototype.queryIntfInfo=function(e,t){this.db.all("SELECT * FROM device_intf_table WHERE deviceName = ? order by intfName;",[e.deviceName],function(e,i){t(e,i)})};o.prototype.queryIntfInfoBySn=function(e,t){this.db.all("SELECT * FROM device_intf_table WHERE seriaNo = ?;",[e],function(e,i){t(e,i)})};o.prototype.queryIntfDetail=function(e,t){this.db.all("SELECT intfName, descs, ip, ipv6, negoSpeed,status FROM device_intf_table WHERE deviceName = ? AND intfName = ?;",[e.deviceName,e.intfName],function(e,i){t(e,i)})};o.prototype.queryIntfFlow=function(e,t){if(e.interval=="hour"){this.db.all("SELECT strftime('%Y-%m-%d %H:00:00', time) as timeInterval, intfName, sum(sendBytes) as send, sum(rcvBytes) as receive FROM intf_flow_table WHERE deviceName = ? AND intfName = ? AND time BETWEEN ? AND ? GROUP BY timeInterval;",[e.deviceName,e.intfName,e.startTime,e.endTime],function(e,i){t(e,i)})}else if(e.interval=="day"){this.db.all("SELECT strftime('%Y-%m-%d', time) as timeInterval, intfName, sum(sendBytes) as send, sum(rcvBytes) as receive FROM intf_flow_table WHERE deviceName = ? AND intfName = ? AND time BETWEEN ? AND ? GROUP BY timeInterval;",[e.deviceName,e.intfName,e.startTime,e.endTime],function(e,i){t(e,i)})}};o.prototype.queryIntfCountInfo=function(e,t){var i=function(e,i){if(e!=null){t(e)}else{var n=i.length;var s=0;var a=0;for(var o=0;o<i.length;o++){if(i[o].adminStatus=="up"){s++}if(i[o].status=="up"){a++}}var f={totalPort:n,confPort:s,upPort:a};t(f)}};this.db.all("SELECT intfName, status, adminStatus FROM device_intf_table WHERE deviceName = ?;",[e.deviceName],function(e,t){i(e,t)})};o.prototype.queryTotalFlowsByInterval=function(t,i,n,s){if(e){console.log("[deviceIntfDb.js] queryTotalFlowsByInterval:")}if(t!="day"&&t!="hour"){return false}var a=this;var o="intf_flow_table AS flow LEFT JOIN device_link AS link ON flow.deviceName = link.deviceName AND flow.seriaNo = link.seriaNo WHERE link.status = '管理中'";var f=null;if(t=="day"){f="SELECT SUM(sendBytes) AS send_bytes, SUM(rcvBytes) AS rcv_bytes, strftime('%Y-%m-%d', flow.time) AS interval_time"+" FROM "+o+" AND flow.time between ? AND ?"+" GROUP BY strftime('%Y-%m-%d', flow.time)"}else if(t=="hour"){f="SELECT SUM(sendBytes) AS send_bytes, SUM(rcvBytes) AS rcv_bytes, strftime('%Y-%m-%d %H:00:00', flow.time) AS interval_time"+" FROM "+o+" AND flow.time between ? AND ?"+" GROUP BY strftime('%Y-%m-%d %H:00:00', flow.time)"}if(e){console.log(f)}a.db.all(f,[i,n],function(e,t){s(e,t)});return true};o.prototype.queryUpLinkFlowsByInterval=function(t,i,n,s){if(e){console.log("[deviceIntfDb.js] queryUpLinkFlowsByInterval:")}if(t!="day"&&t!="hour"){return false}var a=this;var o="intf_flow_table AS flow LEFT JOIN device_link AS link ON flow.deviceName = link.deviceName AND flow.seriaNo = link.seriaNo LEFT JOIN  device_intf_conf AS conf ON flow.deviceName = conf.deviceName AND flow.seriaNo = conf.seriaNo AND flow.intfName = conf.intfName WHERE link.status = '管理中'";var f=null;if(t=="day"){f="SELECT SUM(flow.sendBytes) AS send_bytes, SUM(flow.rcvBytes) AS rcv_bytes, strftime('%Y-%m-%d', flow.time) AS interval_time"+" FROM "+o+" AND conf.updown_link_type = ? AND flow.time between ? AND ?"+" GROUP BY strftime('%Y-%m-%d', flow.time)"}else if(t=="hour"){f="SELECT SUM(flow.sendBytes) AS send_bytes, SUM(flow.rcvBytes) AS rcv_bytes, strftime('%Y-%m-%d %H:00:00', flow.time) AS interval_time"+" FROM "+o+" AND conf.updown_link_type = ? AND flow.time between ? AND ?"+" GROUP BY strftime('%Y-%m-%d %H:00:00', flow.time)"}if(e){console.log(f)}a.db.all(f,["uplink",i,n],function(e,t){s(e,t)});return true};o.prototype.queryDownLinkFlowsByInterval=function(t,i,n,s){if(e){console.log("[deviceIntfDb.js] queryDownLinkFlowsByInterval:")}if(t!="day"&&t!="hour"){return false}var a=this;var o="intf_flow_table AS flow LEFT JOIN device_link AS link ON flow.deviceName = link.deviceName AND flow.seriaNo = link.seriaNo LEFT JOIN  device_intf_conf AS conf ON flow.deviceName = conf.deviceName AND flow.seriaNo = conf.seriaNo AND flow.intfName = conf.intfName WHERE link.status = '管理中'";var f=null;if(t=="day"){f="SELECT sum(flow.sendBytes) AS send_bytes, sum(flow.rcvBytes) AS rcv_bytes, strftime('%Y-%m-%d', flow.time) as interval_time"+" FROM "+o+" AND (conf.updown_link_type <> ? OR conf.updown_link_type is null)"+" AND flow.time between ? AND ?"+" GROUP BY strftime('%Y-%m-%d', flow.time)"}else if(t=="hour"){f="SELECT sum(flow.sendBytes) AS send_bytes, sum(flow.rcvBytes) AS rcv_bytes, strftime('%Y-%m-%d %H:00:00', flow.time) as interval_time"+" FROM "+o+" AND (conf.updown_link_type <> ? OR conf.updown_link_type is null)"+" AND flow.time between ? AND ?"+" GROUP BY strftime('%Y-%m-%d %H:00:00', flow.time)"}if(e){console.log(f)}a.db.all(f,["uplink",i,n],function(e,t){s(e,t)});return true};o.prototype.queryMaxDayFlows=function(t){if(e){console.log("[deviceIntfDb.js] queryMaxDayFlows:")}var i=this;var n="intf_flow_table AS flow LEFT JOIN device_link AS link ON flow.deviceName = link.deviceName AND flow.seriaNo = link.seriaNo WHERE link.status = '管理中'";var s=" SELECT MAX(send_bytes) AS maxSendBytes,MAX(rcv_bytes) AS maxRcvBytes"+" FROM( SELECT SUM(flow.sendBytes) AS send_bytes, SUM(flow.rcvBytes) AS rcv_bytes"+" FROM "+n+" GROUP BY strftime('%Y-%m-%d', flow.time) );";if(e){console.log(s)}i.db.all(s,function(e,i){if(e==null){if(i[0].maxSendBytes==null){i[0].maxSendBytes=0}if(i[0].maxRcvBytes==null){i[0].maxRcvBytes=0}t(e,i)}else{t(e,null)}})};o.prototype.queryTotalFlows=function(t){if(e){console.log("[deviceIntfDb.js] queryTotalFlows:")}var i=this;var n="intf_flow_table AS flow LEFT JOIN device_link AS link ON flow.deviceName = link.deviceName AND flow.seriaNo = link.seriaNo WHERE link.status = '管理中'";var s="SELECT SUM(sendBytes) AS sendSum,SUM(rcvBytes) AS rcvSum FROM "+n+";";if(e){console.log(s)}i.db.all(s,function(i,n){if(i==null){if(n[0].sendSum==null){n[0].sendSum=0}if(n[0].rcvSum==null){n[0].rcvSum=0}t(i,n)}else{if(e){console.log(i)}t(i,null)}})};o.prototype.queryLastTotalFlows=function(t){if(e){console.log("[deviceIntfDb.js] queryLastTotalFlows:")}var i=this;var n="intf_flow_table AS flow LEFT JOIN device_link AS link ON flow.deviceName = link.deviceName AND flow.seriaNo = link.seriaNo WHERE link.status = '管理中'";var s=" SELECT MAX(flow.time), flow.sendBytes AS sendBytes, flow.rcvBytes AS rcvBytes"+" FROM "+n+" GROUP BY flow.deviceName, flow.seriaNo, flow.intfName";s="SELECT sum(sendBytes) as sendSum, sum(rcvBytes) as rcvSum from ("+s+");";if(e){console.log(s)}i.db.all(s,function(i,n){console.log(i);if(i==null){if(n[0].sendSum==null){n[0].sendSum=0}if(n[0].rcvSum==null){n[0].rcvSum=0}t(i,n)}else{if(e){console.log(i)}t(i,null)}})};o.prototype.queryIntfFlowWithSn=function(e,t){if(e.interval=="hour"){this.db.all("SELECT strftime('%Y-%m-%d %H:00:00', time) as timeInterval, intfName, sum(sendBytes) as send, sum(rcvBytes) as receive FROM intf_flow_table WHERE deviceName = ? AND intfName = ? AND seriaNo = ? AND time BETWEEN ? AND ? GROUP BY timeInterval;",[e.deviceName,e.intfName,e.seriaNo,e.startTime,e.endTime],function(e,i){t(e,i)})}else if(e.interval=="day"){this.db.all("SELECT strftime('%Y-%m-%d', time) as timeInterval, intfName, sum(sendBytes) as send, sum(rcvBytes) as receive FROM intf_flow_table WHERE deviceName = ? AND intfName = ?  AND seriaNo = ? AND time BETWEEN ? AND ? GROUP BY timeInterval;",[e.deviceName,e.intfName,e.seriaNo,e.startTime,e.endTime],function(e,i){t(e,i)})}};o.prototype.queryIntfDetailWithSn=function(e,t){this.db.all("SELECT intfName, descs, ip, ipv6, negoSpeed,status FROM device_intf_table WHERE deviceName = ? AND intfName = ? AND seriaNo = ?;",[e.deviceName,e.intfName,e.seriaNo],function(e,i){t(e,i)})};o.prototype.replaceIntfLinkType=function(t,i,n,s,a){if(e){console.log("[deviceIntfDb.js] replaceIntfLinkType;")}if(e){console.log("seriaNo: "+i)}if(s!=="uplink"&&s!=="downlink"){return}var o=this;o.db.run("REPLACE INTO device_intf_conf(deviceName,seriaNo, intfName, updown_link_type) "+"VALUES                 (?,           ?,          ?,                ?);",[t,i,n,s],function(e){if(typeof a!=="undefined"){if(e){a(e)}else{a(null)}}})};o.prototype.queryIntfInfoWithConfByName=function(t,i){var n=this;var s="SELECT device.deviceName AS deviceName,device.seriaNo AS seriaNo,device.descs AS descs"+",device.ip AS ip,device.ipv6 AS ipv6,device.status AS status, device.sendBytes AS sendBytes"+",device.rcvBytes AS rcvBytes,device.intfName AS intfName,conf.updown_link_type AS linkType"+",device.drops AS drops, device.errors AS errors,device.crcs AS crcs,device.negoSpeed AS negoSpeed,device.intfClass as intfClass"+" FROM device_intf_table AS device left join device_intf_conf AS conf ON device.deviceName = conf.deviceName and device.seriaNo = conf.seriaNo and device.intfName = conf.intfName"+" WHERE device.deviceName = ? AND device.seriaNo = ?;";if(e){console.log(s)}n.db.all(s,[t.deviceName,t.serialNo],function(e,t){if(e==null){var n;for(n=0;n<t.length;++n){if(t[n].linkType==null){t[n].linkType="downlink"}}i(e,t)}else{i(e,null)}})};module.exports=o})();