﻿<%@ page language="C#" autoeventwireup="true" inherits="regsiter_RPReply, 25175_ALL" %>

<%@ Register Src="~/regsiter/RHead.ascx" TagPrefix="uc1" TagName="RHead" %>
<%@ Register Src="~/regsiter/RFooter.ascx" TagPrefix="uc1" TagName="RFooter" %>



<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>密码找回</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

    <link href="css/bootstrap.min.css" rel="stylesheet" />
    <script src="js/jquery.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <!-- ionicons -->
    <link href="css/ionicons/ionicons.min.css" rel="stylesheet" />
    <!-- base -->
    <link href="css/base.css" rel="stylesheet" />
</head>
<body>
    <div class="wrapper">
        <uc1:RHead runat="server" ID="RHead" />

        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <h3 class="page-header">密码找回<small>回答提问找回密码</small></h3>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <form id="from1" runat="server">

                        <asp:Panel ID="PanelQuestion" runat="server" Visible="true">
                        <div class="panel panel-default">
                            <div class="panel-body">
                                <!-- Add.aspx -->
                                <div class="form-group">
                                    <label class=" control-label">
                                        提问<span class='rd'>*</span>：</label>
                                    <div>
                                        <asp:Label ID="litOldQuestion" runat="server" Font-Size="20px"></asp:Label>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class=" control-label">
                                        回答<span class='rd'>*</span>：</label>
                                    <div>
                                        <asp:TextBox ID="txtOldAnswer" runat="server" MaxLength="100" CssClass="form-control"></asp:TextBox>
                                    </div>
                                    <div>
                                        <asp:RequiredFieldValidator ID="rfvt_pass" runat="server" ForeColor="Red" Display="Dynamic"
                                            ErrorMessage="请填写旧的回答" ControlToValidate="txtOldAnswer">
                                        </asp:RequiredFieldValidator>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <asp:Button ID="btnSubmit" runat="server" Text="下一步" CssClass="btn btn-block btn-default btn-primary btn-lg" OnClick="btnSubmit_Click" />
                                </div>


                            </div>
                        </div>
                        </asp:Panel>

                        <asp:Panel ID="PanelUpdatePass" runat="server" Visible="false">
                            <div class="panel panel-default">
                                <div class="panel-body">
                                    <!-- Add.aspx -->
                                    <div class="form-group">
                                        <label class=" control-label">
                                            用户名<span class='rd'>*</span>：</label>
                                        <div>
                                            <asp:TextBox ID="txtt_user" runat="server" MaxLength="50" CssClass="form-control"></asp:TextBox>
                                        </div>
                                        <div>
                                            <asp:RequiredFieldValidator ID="rfvt_user" runat="server" ForeColor="Red" Display="Dynamic" ErrorMessage="请填写用户名" ControlToValidate="txtt_user"></asp:RequiredFieldValidator>
                                            <asp:RegularExpressionValidator ID="revtxtu_user" runat="server" ControlToValidate="txtt_user"
                                            ErrorMessage="最少5位（字母和数字@.组合）" ValidationExpression="^[\da-z@.]{5,}$"
                                            ForeColor="Red" Display="Dynamic"></asp:RegularExpressionValidator>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class=" control-label">
                                            密码<span class='rd'>*</span>：</label>
                                        <div>
                                            <asp:TextBox ID="txtt_pass" runat="server" TextMode="Password" MaxLength="100" CssClass="form-control"></asp:TextBox>
                                        </div>
                                        <div>
                                            <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ForeColor="Red" Display="Dynamic" ErrorMessage="请填写密码" ControlToValidate="txtt_pass"></asp:RequiredFieldValidator>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class=" control-label">
                                            密码验证 <span class='rd'>*</span>：
                                        </label>
                                        <div>
                                            <asp:TextBox ID="txtt_pass2" runat="server" TextMode="Password" MaxLength="100" CssClass="form-control"></asp:TextBox>
                                        </div>
                                        <div>
                                            <asp:CompareValidator ID="cbpass" runat="server" ControlToValidate="txtt_pass2" ControlToCompare="txtt_pass" ErrorMessage="两次密码输入不一致" Display="Dynamic" ForeColor="Red"></asp:CompareValidator>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <asp:Button ID="btnUpdate" runat="server" Text="保存密码修改" CssClass="btn btn-block btn-default btn-primary btn-lg" OnClick="btnUpdate_Click" />
                                    
                                  
                                                    
                                    
                                    </div>

                                </div>
                            </div>

                        </asp:Panel>


                    </form>
                </div>
            </div>
        </div>

        <uc1:RFooter runat="server" ID="RFooter" />
    </div>
</body>
</html>
